package at.jku.fmv.qbf.nnf.formula;

import java.util.List;
import java.util.ArrayList;


/**
 * 
 * a quantifier block in a quantifer prefix (note that this prefix might also occurr within the formula) 
 * a quantifier block is a quantifier (universal, existential) plus a list of vars in the scope of this quantifier
 * the quantifier prefix the quantifier block belongs to
 */

public class QBlock {
	private QType qtype;							// type of quantification (forall, exists)
	private ArrayList<IVar> vars;			// the variables in the scope of this quantifier
	private Quantifiers qp;							// quantifier prefix the QBlock belongs to
	
	/**
	 * init of an empty quantifier block of typ qtype
	 * @param qtype type of the quantifier (forall, exists)
	 * @param f the formla the prefix of the qblock belongs to
	 */
	public QBlock (QType qtype, Formula f) {
		this.qtype = qtype;
		vars = new ArrayList<IVar>();
		this.qp = f.getQuantifiers();
		f.addQBlock(this);
	}
	
	public QBlock (QType qtype) {
		this.qtype = qtype;
		vars = new ArrayList<IVar>();
	}
	
	/**
	 * returns the quantifier prefix this block belongs to
	 * @return the quantifer prefix
	 */
	public Quantifiers getQuantifiers() {
		return qp;
	}
		
	/**
	 * returns the list of variables in the scope of this quantifier
	 * @return the variable in the scope of this quantifer
	 */
	public List<IVar> getVars() {
		return vars;
	}
	
	/**
	 * returns the type of this quantifier block
	 * @return the quantifier type
	 */
	public QType getQType() {
		return qtype;
	}
	
	/**
	 * adds a variable to this scope
	 * @param v the variable to be added
	 */
	public void add(IVar v){
		vars.add(v);
	}

	public void setQuantifiers(Quantifiers qp) {
	
		this.qp = qp;
		
	}
	
}
