package at.jku.fmv.qbf.nnf.formula;


/**
 * 
 * Types of quantifiers (forall, exists)
 *
 */
public enum QType {
	FORALL,						// universal quantifier
	EXISTS;						// existential quantifier

	
	/**
	 * converts the char 'a' to FORALL, the char 'e' to EXISTS
	 * error for other inputs
	 * @param pol 
	 */
	public static QType convert(char type, boolean pol) {
		assert (type == 'a') || (type == 'e') : "unknown qtype " + type;
		
		if (pol) {
			if (type == 'a') return FORALL;
			else return EXISTS;
		} else {
			if (type == 'a') return EXISTS;
			else return FORALL;
		}
	}
 }
