package at.jku.fmv.qbf.nnf.formula;

import java.util.ArrayList;
import java.util.List;

/**
 * list of quantifier blocks (i.e., a quantifier prefix which may occur inside the formula)
 * Note: order is of importance for the formula value
 */
public class Quantifiers {
	private Formula f;										// formula the prefix is attached to
	private ArrayList<QBlock> quantBlocks;					// list of quantifier blocks
	
	
	/**
	 * inits an empty quantifier list
	 */
	public Quantifiers(Formula f) {
		quantBlocks = new ArrayList<QBlock>();
		this.f = f;
	}
	
	/**
	 * returns the formula, the quantifier list is attached to
	 * @return formula of quantifier list
	 */
	public Formula getFormula() {
		return f;
	}
	
	/**
	 * returns the list of quantifier blocks
	 * @return
	 */
	public List<QBlock>getQuantifierBlocks() {
		return quantBlocks;
	}
	
	/**
	 * returns the number of quantifier blocks in this prefix
	 * @return number of quantifier blocks
	 */
	public int size()  {
		return quantBlocks.size();
	}
	
	/**
	 * append a new quantifier block
	 * @param q quantifier block to be added
	 */
	public void addQuantBlock(QBlock q){
		quantBlocks.add(q);
		
	}

	public void setFormula(Formula f2) {
		f = f2;
		
	}
}
