package at.jku.fmv.qbf.nnf.formula;

import java.util.ArrayList;

/**
 * description of an occurrence of a variable (a literal)
 *  position in formula
 *  position in variable info occurrence list
 *  polarity
 */
public class VOccurrence {

	private Integer name;					// position in VariableInfo (name of the occurrence)
	private Formula formula;				// formula where occurrence is located
	private ArrayList<VOccurrence> lits;	// literal list where occurrence is located
	private boolean pol;					// polarity
	private Integer position;
	
	/**
	 * init variable occurrence
	 * @param position name of variable occurrence (position within VariableInfo)
	 */
	public VOccurrence(int name) {
		this.name = name;
	}
	
	/**
	 * name of variable occurrence
	 * @return name of variable occurrence
	 */
	public Integer getVariable() {
		return name;
	}
	
	public int getPosition() {
		return position;
	}
	
	public void setPosition(int pos) {
		this.position = pos;
	}

	/**
	 * set the location of the variable occurrence
	 * @param formula where variable occurrence is located
	 * @param pol polartiy of the literal
	 */
	public void setFormulaPosition(Formula formula, boolean pol) {
		this.formula = formula;
		
		if (pol) {
			lits = (ArrayList<VOccurrence>) formula.getPosLits();
		} else {
			lits = (ArrayList<VOccurrence>) formula.getNegLits();
		}
		
		this.pol = pol;		
	}
	
	/**
	 * returns formula where variable occurrence is located
	 * @return parent formula
	 */
	public Formula getFormula() {
		return formula;
	}
	
	/** 
	 * returns literal list where variable occurrence is located
	 * @return literal list
	 */
	public ArrayList<VOccurrence> getLitList() {
		return lits;
	}
	
	/** 
	 * returns polarity of literal 
	 * @return the polarity of the literal
	 *//*
	public boolean getPolarity() {
		return pol;
	}*/
}
