package at.jku.fmv.qbf.nnf.formula;

import java.util.HashMap;

/**
 * global infos about a variable
 * quantifier:		quantification type of the variable
 * qb:				position of the variable in a quantifier prefix
 * name:			name of the variable
 * poslits, neglit:	positive and negative occurrences of the variable
 *
 */
public class VariableInfo implements IVar {
	
	private QType quantifier;							// quantification type
	private QBlock qb;									// scope of the variable
	
	private HashMap<Integer,VOccurrence> posLits;		// positive occurrences
	private HashMap<Integer,VOccurrence> negLits;		// negative occurrences
	
	private int nextPosPosition, nextNegPosition;		// next free indices in posLits, negLits
	private int name;									// name of the variable
	private boolean isTseitin;

	
	/** 
	 * init empty VariableInfo (e.g. for truth constants)
	 */
	public VariableInfo() {
		posLits = new HashMap<Integer,VOccurrence>();
		negLits = new HashMap<Integer,VOccurrence>();
		isTseitin = false;
	}
	
	/**
	 * init variable for QBlock qb
	 * @param qb scope of the new variable
	 */
	public VariableInfo(QBlock qb) {
		this.setQBlock(qb);
		this.quantifier = qb.getQType();
		
		posLits = new HashMap<Integer,VOccurrence>();
		negLits = new HashMap<Integer,VOccurrence>();
		
		nextPosPosition = 0;
		nextNegPosition = 0;
	}
	
	/**
	 * set the variable name
	 * @param name variable name
	 */
	public void setName(int name) {
		this.name = name;
	}
	
	/**
	 * returns the variable name
	 * @return the variable name
	 */
	public int getName() {
		return name;
	}
	 
	/**
	 * returns the type of the variable
	 * @return quantification type of the variable
	 */
	public QType getQType() {
		return quantifier;
	}
	
	// next free name for pos literals
	
	private int getNextPosPosition(){
		return nextPosPosition++;
	}
	
	
	// next free name for neg literals
	
	private int getNextNegPosition(){
		return nextNegPosition++;
	}	
	
	/** 
	 * add a positive variable occurrence
	 */
	public void addPosOccurrence(VOccurrence v) {
		int pos = getNextPosPosition();
		//VOccurrence v = new VOccurrence(pos);
		v.setPosition(pos);
		posLits.put(pos,v);		
	}
	
	/** 
	 * add a negative variable occurrence
	 */
	public void addNegOccurrence(VOccurrence v) {
		int pos = getNextNegPosition();
		//VOccurrence v = new VOccurrence(pos);
		v.setPosition(pos);
		negLits.put(pos,v);		
	}
	

	/**
	 * remove a negative variable occurrence
	 * @param pos name of the variable occurrence to be removed
	 */
	public void removeNegOccurrence(int pos){
		negLits.remove(pos);
	}
	
	/**
	 * remove a positive variable occurrence
	 * @param pos name of the variable occurrence to be removed
	 */
	public void removePosOccurrence(int pos){
		posLits.remove(pos);
	}

	/**
	 * set the quantification type of the variable
	 * @param qb quantification type of this variable
	 */
	public void setQBlock(QBlock qb) {
		this.qb = qb;
	}

	/**
	 * returns the quantification type of this variable
	 * @return the quantification type of this variable
	 */
	public QBlock getQBlock() {
		return qb;
	}
	
	/**
	 * true if var is introduced during normal form transformation
	 * @return true if var is a tseitin varialbe
	 */
	public boolean isTseitinVar() {
		return isTseitin;
	}
	
	public void setTseitinVar() {
		isTseitin = true;
	}

	
	
}
