package at.jku.fmv.qbf.nnf.formula;

import java.util.ArrayList;

/** 
 * list of variable occurring in a formula
 *
 */
public class Variables {


	private ArrayList<VariableInfo> vars;						// the variable list 
																// the names of the variables depend on their position
																// do not remove elements from this list
	
	
	public Variables() {
		vars = new ArrayList<VariableInfo>();			// the list of variables
		vars.add(new VariableInfo());					// init false
		vars.add(new VariableInfo());					// init true
	}
	
	/**
	 * add a positive variable occurrence
	 * @param v the positive variable occurrence
	 */
	public void addPosOccurrence(VOccurrence v) {
		getVarInfo(v.getVariable()).addPosOccurrence(v);
	}
	
	
	/**
	 * add a negative variable occurrence
	 * @param v the negative variable occurrence
	 */
	public void addNegOccurrence(VOccurrence v) {
		getVarInfo(v.getVariable()).addNegOccurrence(v);
	}
	
	/**
	 * returns infos about a variable
	 * @param name the name of the variable for which infos are requested
	 * @return	infos about the variable
	 */
	public VariableInfo getVarInfo(int name) {
		return vars.get(name);
	}
	
	/**
	 * add a new variable
	 * @param v infos about the new variable
	 * @return the name of the new variable
	 */
	public int addVar(VariableInfo v) {
		v.setName(vars.size());
		vars.add(v);
		return (vars.size()-1);
	}
}
