package at.jku.fmv.qbf.nnf.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;

public class ParserBoole {
	
	private HashMap <String, Integer> vars;
	private Scanner input;
	private String nextToken;
	private int varCounter = 2;
	private FormulaData fd;
	private boolean pol = true;
	
	private ParserBoole (int varNumber, String f) {
		Formula root = new Formula();
	    
		
		f = f.replaceAll("!", " ! ");
		f = f.replaceAll(" > ", " > ");
		f = f.replaceAll("\\&", " \\& ");
		f = f.replaceAll("\\|", " \\| ");
		f = f.replaceAll("\\)", " \\) ");
		f = f.replaceAll("\\(", " \\( ");
		f = f.replaceAll("\\]", " \\] ");
		f = f.replaceAll("\\[", " \\[ ");
		
		input = new Scanner(f);
		
		fd = new FormulaData(varNumber,root);
		nextToken();
		parseFormula(root);
		
		fd.setVarNumber(varCounter);
	}
	
	
	private FormulaData getFormulaData() {
		return fd;
	}
	
	private void parseFormula(Formula f) {
		
		vars = new HashMap <String, Integer>();
		
		if (nextToken.equals("(")) parseBrack(f); else
		if (nextToken.equals("forall") || nextToken.equals("exists")) parseQuant(f); 
		
		//TODO Error
	}
	
	private int getNewVarName() {
		return varCounter++;
	}
	
	private void parseBrack(Formula f) {
		nextToken();
		
		//if (nextToken.equals("forall") || nextToken.equals("exists")) parseQuant(f); else  
		parseConnective(f);
		
		if (!nextToken.equals(")")) ; //Todo return error
	}
	
	private void parseConnective(Formula f) {
		Formula f1;
		
		if (nextToken.equals("forall") || nextToken.equals("exists")) {
			f1 = new Formula();
			parseQuant(f1);  
			f.addSubFormula(f1);
		} else {
			if (nextToken.equals("(")) {
				f1 = new Formula();
				parseBrack(f1);
				f.addSubFormula(f1);
			} else {
				if (nextToken.equals("!")) {
					nextToken();
					if (nextToken.equals("(")) {
						pol = !pol;
						f1 = new Formula();
						parseBrack(f1);
						f.addSubFormula(f1);
						pol = !pol;
					} else {
						assert vars.containsKey(nextToken) : "unknown element";
						assert vars.get(nextToken) != null : "variable not quantified";
						if (pol) {
							fd.addNegVarOcc(vars.get(nextToken), f);
						} else {
							fd.addPosVarOcc(vars.get(nextToken), f);
						}
					}
				} else {
					assert vars.containsKey(nextToken) : "unknown element";
					assert vars.get(nextToken) != null : "variable not quantified";
					fd.addPosVarOcc(vars.get(nextToken), f);
				}

			}
		}
			
		nextToken();
		
		if (nextToken.equals("&")) {
			parseConj(f);
			return;
		}
		
		if (nextToken.equals("|")) {
			parseDisj(f);
			return;
		}
		
		
	}
	
	private void parseDisj(Formula f) {
		Formula f1;
		if (pol) f.setConnective(CType.OR);
		else f.setConnective(CType.AND);
		
		do {
			nextToken();
			if (nextToken.equals("forall") || nextToken.equals("exists")) {
				f1 = new Formula();
				parseQuant(f1);  
				f.addSubFormula(f1);
			} else {
				if (nextToken.equals("(")) {
					f1 = new Formula();
					parseBrack(f1);
					f.addSubFormula(f1);
				} else {
					if (nextToken.equals("!")) {
						nextToken();
						if (nextToken.equals("(")) {
							pol = !pol;
							f1 = new Formula();
							parseBrack(f1);
							f.addSubFormula(f1);
							pol = !pol;
						} else {
							assert vars.containsKey(nextToken) : "unknown element";
							assert vars.get(nextToken) != null : "variable not quantified";
							if (pol) {
								fd.addNegVarOcc(vars.get(nextToken), f);
							} else {
								fd.addPosVarOcc(vars.get(nextToken), f);
							}
						}
					} else {
						assert vars.containsKey(nextToken) : "unknown element";
						fd.addPosVarOcc(vars.get(nextToken), f);
					}

				}
			}	
			nextToken();
		} while (nextToken.equals("|"));
	}
	
	
	private void parseConj(Formula f) {
		Formula f1;
		
		
		if (pol) f.setConnective(CType.AND); 
		else f.setConnective(CType.OR);
		
		do {
			nextToken();
			if (nextToken.equals("forall") || nextToken.equals("exists")) {
				f1 = new Formula();
				parseQuant(f1);  
				f.addSubFormula(f1);
			} else {
				if (nextToken.equals("(")) {
					f1 = new Formula();
					parseBrack(f1);
					f.addSubFormula(f1);
				} else {
					if (nextToken.equals("!")) {
						nextToken();
						if (nextToken.equals("(")) {
							pol = !pol;
							f1 = new Formula();
							parseBrack(f1);
							f.addSubFormula(f1);
							pol = !pol;
						} else {
							assert vars.containsKey(nextToken) : "unknown element";
							assert vars.get(nextToken) != null : "variable not quantified";
							if (pol) {
								fd.addNegVarOcc(vars.get(nextToken), f);
							} else {
								fd.addPosVarOcc(vars.get(nextToken), f);
							}
						}
						assert vars.containsKey(nextToken) : "unknown element";
					
					} else {
						assert vars.containsKey(nextToken) : "unknown element";
						assert vars.get(nextToken) != null : "variable not quantified";
						fd.addPosVarOcc(vars.get(nextToken), f);
					}

				}
			}	
			nextToken();
		} while (nextToken.equals("&"));
		
	}
	
	private void parseQuant(Formula f) {
		String quant = nextToken;
		ArrayList <String> quantVars = new ArrayList<String>();
		int newVar;
		
		
		QBlock qBlock;
		
		if (quant.equals("forall")) {
			if (pol) qBlock = new QBlock(QType.FORALL,f); 
			else qBlock = new QBlock(QType.EXISTS,f); 
		} else {
			if (pol) qBlock = new QBlock(QType.EXISTS,f);
			else qBlock = new QBlock(QType.FORALL,f); 
		}
		nextToken();
		
		assert nextToken.equals("[") : "unexpected character";
		
		nextToken();
		
		do {
			// TODO check if var name is valid
		
						
			assert (!vars.containsKey(nextToken)) : "variable already defined";
			newVar = getNewVarName();
			vars.put(nextToken, newVar);
			quantVars.add(nextToken);
			fd.addVar(newVar, qBlock);
			
			nextToken();
			
		} while (!nextToken.equals("]"));
		
		nextToken();
		
		parseBrack(f);
		
		for (String s : quantVars) {
			vars.put(s, null);
		}
	}
	
	private void nextToken() {
		nextToken = input.next();
	}
	

	
	
	
	
	public static FormulaData parse (int varNumber, String f) {
		ParserBoole p = new ParserBoole(varNumber, f);
		return p.getFormulaData();
	}
	
	
	public static void main (String args[]) {
		FormulaData fd;
		
		//fd = ParserBoole.parse("forall [x y z] (x&(x|z))");
		
		fd = ParserBoole.parse(20,"exists [a b c d] (forall [x y] ((a & b) | !x | !d))");
		
		//fd = ParserBoole.parse("forall [x] (x)");
		
		//fd = ParserBoole.parse("forall [x] (!x)");
		
		//fd = ParserBoole.parse("exists [x] (!x)");
		
		 fd = ParserBoole.parse(5,"forall [x] (x)");
		
		//fd = ParserBoole.parse("(forall [y x] (x & y) & exists [a b] (b) & y)");		
		fd.print();
	}
	
}
