package at.jku.fmv.qbf.nnf.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;

public class ParserBooleSAT {
	
	private HashMap <String, Integer> vars;
	private HashMap <Integer, String> variableMap;

	private Scanner input;
	private String nextToken;
	private int varCounter = 3;
	private FormulaData fd;
	private boolean pol = true;
	private QBlock quant;

	
	public ParserBooleSAT (int varNumber, File f) {
		
		Formula root = new Formula();
		quant = new QBlock(QType.EXISTS,root);
		
		try {
			
			input = new Scanner(f);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		fd = new FormulaData(varNumber,root);
		nextToken();
		parseFormula(root);
		
		fd.setVarNumber(varCounter);

		setVariableMap();
	}
	
	private void setVariableMap(){
	
		variableMap = new HashMap<Integer,String>();
		
		for (String key : vars.keySet()){		
			variableMap.put(vars.get(key)+1, key);	
		}	
	}
	
	public HashMap <Integer, String> getMap(){
		return variableMap;
	}
	
	public String getVariable(int var){
		return variableMap.get(var);
	}
	
	
	private void printMapping(BufferedWriter out) {

		for (String v : vars.keySet()) {
			try {
				out.write("c "+v+"\t\t"+(vars.get(v)+1)+"\n");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	public void printMapping() {
		
		for (String v : vars.keySet()) {
				System.out.println("c "+v+"\t\t"+(vars.get(v)+1));
		}
	}
	
	private FormulaData getFormulaData() {
		return fd;
	}
	
	private void parseFormula(Formula f) {
		
		vars = new HashMap <String, Integer>();
		f.setConnective(CType.AND);
		varCounter = 3;
		
		vars.put("1", 1);
		fd.addVar(1, quant);
	    fd.addPosVarOcc(vars.get("1"), f);
		
	    vars.put("0", 2);
		fd.addVar(2, quant);
	    fd.addNegVarOcc(vars.get("0"), f);
	    
		Formula f1 = new Formula();
		f.addSubFormula(f1);
		
		if (nextToken.equals("(")) parseBrack(f1); else
		if (nextToken.equals("forall") || nextToken.equals("exists")) parseQuant(f1); 
		
		//TODO Error
	}
	
	private int getNewVarName() {
		return varCounter++;
	}
	
	private void parseBrack(Formula f) {
		nextToken();
		
		//if (nextToken.equals("forall") || nextToken.equals("exists")) parseQuant(f); else  
		parseConnective(f);
		
		if (!nextToken.equals(")")) ; //Todo return error
	}
	
	private void parseConnective(Formula f) {
		Formula f1;
		
		if (nextToken.equals("forall") || nextToken.equals("exists")) {
			f1 = new Formula();
			parseQuant(f1);  
			f.addSubFormula(f1);
		} else {
			if (nextToken.equals("(")) {
				f1 = new Formula();
				parseBrack(f1);
				f.addSubFormula(f1);
			} else {
				if (nextToken.equals("!")) {
					nextToken();
					if (nextToken.equals("(")) {
						pol = !pol;
						f1 = new Formula();
						parseBrack(f1);
						f.addSubFormula(f1);
						pol = !pol;
					} else {
						
						if (pol) {
							if (!vars.containsKey(nextToken)) {
								int newVar = getNewVarName();
								vars.put(nextToken, newVar);
								fd.addVar(newVar, quant);
							}
							fd.addNegVarOcc(vars.get(nextToken), f);
						} else {
							if (!vars.containsKey(nextToken)) {
								int newVar = getNewVarName();
								vars.put(nextToken, newVar);
								fd.addVar(newVar, quant);
							} 
							
							fd.addPosVarOcc(vars.get(nextToken), f);
							
						}
					}
				} else {
					if (!vars.containsKey(nextToken)) {
						int newVar = getNewVarName();
						vars.put(nextToken, newVar);
						fd.addVar(newVar, quant);
					} 
					if (pol) 
						fd.addPosVarOcc(vars.get(nextToken), f);
					else fd.addNegVarOcc(vars.get(nextToken), f);	
				}

			}
		}
			
		nextToken();
		
		if (nextToken.equals("&")) {
			parseConj(f);
			return;
		}
		
		if (nextToken.equals("|")) {
			parseDisj(f);
			return;
		}
		
		
	}
	
	private void parseDisj(Formula f) {
		Formula f1;
		if (pol) f.setConnective(CType.OR);
		else f.setConnective(CType.AND);
		
		do {
			nextToken();
			if (nextToken.equals("forall") || nextToken.equals("exists")) {
				f1 = new Formula();
				parseQuant(f1);  
				f.addSubFormula(f1);
			} else {
				if (nextToken.equals("(")) {
					f1 = new Formula();
					parseBrack(f1);
					f.addSubFormula(f1);
				} else {
					if (nextToken.equals("!")) {
						nextToken();
						if (nextToken.equals("(")) {
							pol = !pol;
							f1 = new Formula();
							parseBrack(f1);
							f.addSubFormula(f1);
							pol = !pol;
						} else {
							
							if (pol) {
								if (!vars.containsKey(nextToken)) {
									int newVar = getNewVarName();
									vars.put(nextToken, newVar);
									fd.addVar(newVar, quant);
								} 
								fd.addNegVarOcc(vars.get(nextToken), f);
								
							} else {
								if (!vars.containsKey(nextToken)) {
									int newVar = getNewVarName();
									vars.put(nextToken, newVar);
									fd.addVar(newVar, quant);
								} 
								fd.addPosVarOcc(vars.get(nextToken), f);
								
							}
						}
					} else {
						if (!vars.containsKey(nextToken)) {
							int newVar = getNewVarName();
							vars.put(nextToken, newVar);
							fd.addVar(newVar, quant);
						} 
						if (pol) 
							fd.addPosVarOcc(vars.get(nextToken), f);
						else fd.addNegVarOcc(vars.get(nextToken), f);	
					}

				}
			}	
			nextToken();
		} while (nextToken.equals("|"));
	}
	
	
	private void parseConj(Formula f) {
		Formula f1;
		
		
		if (pol) f.setConnective(CType.AND); 
		else f.setConnective(CType.OR);
		
		do {
			nextToken();
			if (nextToken.equals("forall") || nextToken.equals("exists")) {
				f1 = new Formula();
				parseQuant(f1);  
				f.addSubFormula(f1);
			} else {
				if (nextToken.equals("(")) {
					f1 = new Formula();
					parseBrack(f1);
					f.addSubFormula(f1);
				} else {
					if (nextToken.equals("!")) {
						nextToken();
						if (nextToken.equals("(")) {
							pol = !pol;
							f1 = new Formula();
							parseBrack(f1);
							f.addSubFormula(f1);
							pol = !pol;
						} else {
							if (pol) {
								if (!vars.containsKey(nextToken)) {
									int newVar = getNewVarName();
									vars.put(nextToken, newVar);
									fd.addVar(newVar, quant);
								}
								fd.addNegVarOcc(vars.get(nextToken), f);
								
							} else {
								if (!vars.containsKey(nextToken)) {
									int newVar = getNewVarName();
									vars.put(nextToken, newVar);
									fd.addVar(newVar, quant);
								} 
								fd.addPosVarOcc(vars.get(nextToken), f);
								
							}
						}
						assert vars.containsKey(nextToken) : "unknown element";
					
					} else {
						
						if (!vars.containsKey(nextToken)) {
							int newVar = getNewVarName();
							vars.put(nextToken, newVar);
							fd.addVar(newVar, quant);
						}
						if (pol) 
							fd.addPosVarOcc(vars.get(nextToken), f);
						else fd.addNegVarOcc(vars.get(nextToken), f);	
					}

				}
			}	
			nextToken();
		} while (nextToken.equals("&"));
		
	}
	
	private void parseQuant(Formula f) {
		String quant = nextToken;
		ArrayList <String> quantVars = new ArrayList<String>();
		int newVar;
		
		
		QBlock qBlock;
		
		if (quant.equals("forall")) {
			if (pol) qBlock = new QBlock(QType.FORALL,f); 
			else qBlock = new QBlock(QType.EXISTS,f); 
		} else {
			if (pol) qBlock = new QBlock(QType.EXISTS,f);
			else qBlock = new QBlock(QType.FORALL,f); 
		}
		nextToken();
		
		assert nextToken.equals("[") : "unexpected character";
		
		nextToken();
		
		do {
			// TODO check if var name is valid
		
						
			assert (!vars.containsKey(nextToken)) : "variable already defined";
			newVar = getNewVarName();
			vars.put(nextToken, newVar);
			quantVars.add(nextToken);
			fd.addVar(newVar, qBlock);
			
			nextToken();
			
		} while (!nextToken.equals("]"));
		
		nextToken();
		
		parseBrack(f);
		
		/*for (String s : quantVars) {
			vars.put(s, null);
		}*/
	}
	
	private void nextToken() {
		nextToken = input.next();
		
	}

	public File toCNF(String outFile) {
				
		try {
			FileWriter fstream = new FileWriter(outFile);
			BufferedWriter out = new BufferedWriter(fstream);
	
			FormulaData fd;
						
			printMapping(out);

			fd = getFormulaData();

			FormulaToCNF ftc = new FormulaToCNF(fd,true,out);
			
			ftc.label();
			out.write("p cnf "+fd.getVarNumber()+" "+ftc.countCNF2());
			ftc.printCNF2();
			
			out.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return new File(outFile);
	}
	
	
	
}
