package at.jku.fmv.qbf.nnf.simplifier;

import java.util.ArrayList;
import java.util.List;

public class MatingGraph {
	private List<MatingNode>rootNodes;
	private List<MatingNode>childNodes;
	
	public MatingGraph(MatingNode m) {
		rootNodes = new ArrayList<MatingNode>();
		childNodes = new ArrayList<MatingNode>();
		
		rootNodes.add(m);
		childNodes.add(m);		
	}
	
	public List<MatingNode> getRootNodes() {
		return rootNodes;
	}
	
	public List<MatingNode> getChildNodes() {
		return childNodes;
	}
	
	public void union(MatingGraph g) {
		for (MatingNode n : g.getRootNodes()) {
			rootNodes.add(n);
		}
		
		for (MatingNode n : g.getChildNodes()) {
			childNodes.add(n);
		}		
	}
	
	public void merge (MatingGraph g) {
		
		for (MatingNode n : childNodes) { 
			for (MatingNode m : g.getRootNodes()) {
				n.addChild(m);
				m.addParent(n);
			}
		}
		childNodes = g.getChildNodes();
	}
	
}
