package at.jku.fmv.qbf.nnf.simplifier;

import java.util.ArrayList;
import java.util.List;

import at.jku.fmv.qbf.nnf.formula.VOccurrence;

public class MatingNode {
	
	private int visitedPre, visitedPost;
	private int value;
	private VOccurrence voccurrence;
	private int max;						// max number of Variable in Scope
	private ArrayList<MatingNode> parents;
	private ArrayList<MatingNode> children;

	
	
	public MatingNode(VOccurrence voccurrence) {
		this.voccurrence = voccurrence;
		this.value = Math.abs(voccurrence.getVariable());
		parents = new ArrayList<MatingNode>();
		children = new ArrayList<MatingNode>();
		visitedPre = visitedPost = value;
	}
	
	public MatingNode() {
		this.value = -1;
		parents = new ArrayList<MatingNode>();
		children = new ArrayList<MatingNode>();
	}
	
	
	public int getMaxDown() {
		return visitedPre;
	}
	
	public int getMaxUp() {
		return visitedPost;
	}
	
	public void addParent(MatingNode m) {
		parents.add(m);
	}
	
	public void addChild(MatingNode m) {
		parents.add(m);
	}
	
	public int getLitOccName() {
		return value;
	}
	
	public VOccurrence getVOccurrence() {
		return voccurrence;
	}
	
	public List<MatingNode>getChildren() {
		return children;
	}
	
	public List<MatingNode> getParents() {
		return parents;
	}
	
	public void setMax(int max) {
		this.max = max;
	}
	
	public int getMax() {
		return max;
	}
	
	public boolean biggerThen(MatingNode m) {
		//TODO
		return value > m.getLitOccName();
	}
}
