package at.jku.fmv.qbf.nnf.simplifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.VOccurrence;


public class UniversalReduction {
	private Queue<MatingNode> todo;
	private MatingGraph mg;
	
	public UniversalReduction(Formula f) {
		todo = new LinkedBlockingQueue<MatingNode>();
		mg = buildGraph(f);
		
		for (MatingNode m : mg.getRootNodes()) {
			todo.add(m);
		}
	}
	
	
	public void checkURDown() {
		
		while (!todo.isEmpty()) {
			MatingNode n = todo.poll();
			checkNodeDown(n,n.getMaxDown());
		}
		
	}
	
	private void checkNodeDown(MatingNode n, int max) {
		assert (n.getParents().size() < n.getMax()) : "node has not been finished";
		
		for (MatingNode cn : n.getChildren()) {
			if (cn.getMax() < max) {
				cn.setMax(max);
			}
		}
		
	}
	
	
	
	public MatingGraph buildGraph(Formula f) {
		MatingGraph g1, g2;
		g1 = null;
		
		for (Formula fs : f.getSubformulas()) {
			g2 = buildGraph(fs);
			g1 = combine(g2,g1,f.getConnective());
		}
		
		for (VOccurrence v : f.getPosLits()) {
			g2 = new MatingGraph(new MatingNode(v));
			g1 = combine(g2,g1,f.getConnective());
		}
		

		for (VOccurrence v : f.getNegLits()) {
			g2 = new MatingGraph(new MatingNode(v));
			g1 = combine(g2,g1,f.getConnective());
		}
		
		return g1;
	}
	
	private MatingGraph combine(MatingGraph g1, MatingGraph g2, CType connective) {
		if (connective == CType.AND) {
			g1.union(g2);
		} else {
			g1.merge(g2);
		}
		return g1;
	}

	public void reduce() {
		
	}
	
	
}
