package at.jku.fmv.qbf.nnf.transform.matrix;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.TseitinVar;
import at.jku.fmv.qbf.nnf.formula.VOccurrence;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;

public class FormulaToCNF {
	private Formula formulaRoot;
	private LinkedList<Formula> recent, next;
	private HashMap<Integer,TseitinVar> labels;
	private int varNumber;
	private int counter;
	FormulaData fd;
	private boolean [] definedLabels;
	private int cl;
	private boolean doHashing = true;
	private BufferedWriter out;
	
	public FormulaToCNF(FormulaData fd, boolean doHashing) {
		this.fd = fd;

		this.doHashing = doHashing;

		this.formulaRoot = fd.getFormula();
		next   =   new LinkedList<Formula>();
		recent =   new LinkedList<Formula>();
		this.varNumber = fd.getVarNumber();
		this.counter = varNumber+1;
		this.labels = new HashMap<Integer,TseitinVar>();
	}
	
	public FormulaToCNF(FormulaData fd, boolean doHashing, BufferedWriter out) {
		this(fd, doHashing);
		this.out = out;
	}
	
	
	
	public void label() {
		
		
		labelClauses(formulaRoot);

		labelNonClauses();

		definedLabels = new boolean[counter];
		
	}
	
	private void labelNonClauses() {
		
		while (!next.isEmpty()) {
		   
			recent = next;
			next = new LinkedList<Formula>();
			
			while (!recent.isEmpty()) {
				
				setLabel(recent.poll());
			}
		}
		
	}
	
	
	private void labelClauses(Formula f) {
		
		if (f.getSubformulas().size() != 0) {
			for (Formula sf : f.getSubformulas()) {
				labelClauses(sf);
			}
			return;
		}
		
		setLabel(f);	

	}
	
	private int getHashValue (Formula f) {
		int [] tv = new int[f.getPosLits().size() +
		                f.getNegLits().size() +
		                f.getSubformulas().size() + 1];
		int i = 1;
		
		tv[0] = (f.getConnective() == CType.AND) ? 0 : 1;
		
		for (Formula sf : f.getSubformulas()) {
			
			if (sf.getTseitinVar() == null) {
				return -1;
			}
				
			tv[i++] = sf.getTseitinVar().getName();
		}
		
		for (VOccurrence v : f.getPosLits()) {
			tv[i++] = v.getVariable();
		}
		
		for (VOccurrence v : f.getNegLits()) {
			tv[i++] = v.getVariable()*-1;
		}
		
		Arrays.sort(tv);
		int hc =  Arrays.hashCode(tv);
		
	
		
		if (!labels.containsKey(hc)) return hc;

		if (labels.get(hc).getFormulaOccurrences().get(0).comp(f)) {
			return hc;
		}
		
		while (true) {
			tv[0] += 2;
			hc =  Arrays.hashCode(tv);
			if (!labels.containsKey(hc)) return hc;
			if (labels.get(hc).getFormulaOccurrences().get(0).comp(f)) return hc;
			
		}
		
	}
	
	
	
	


	private void setLabel(Formula f) {
		
		
		
		
		if (f.getTseitinVar() != null) return;
		
		int hash = getHashValue(f);
		
		
		
		if (doHashing &&(hash == -1)) {
			f.push();
			next.add(f);
			return;
		}
		
		f.unpush();
		
		TseitinVar t;
				
		if (doHashing && labels.containsKey(hash)) {
			
			t = labels.get(hash);
			
			assert t != null;
		} else {
			t = new TseitinVar(hash, getNextLabelName());
			labels.put(hash, t);
		}
		
		t.addFormulaOccurrence(f);
		fd.setVarNumber(fd.getVarNumber()+1);
		f.setTseitinVar(t);
	
		
		Formula s = f.getSuperFormula();
		
		if ((s != null) && (!s.isPushed())) {
			s.push();
			next.add(s);
		} 
		
		
	}
	
	private int getNextLabelName() {
		return counter++;
	}
	
	public void printCNF2() {
		for (int i = 0; i < definedLabels.length; i++) {
			definedLabels[i] = false;
		}
		printCNF2(formulaRoot);
	}
	
	public int countCNF2() {
		for (int i = 0; i < definedLabels.length; i++) {
			definedLabels[i] = false;
		}
		cl=0;
		countCNF2(formulaRoot);
		return cl;
	}
	
	public void countCNF2(Formula f) {
		if (f.getConnective() == CType.AND) {
			for (VOccurrence v : f.getPosLits()) {
				cl++;
			}
			
			for (VOccurrence v : f.getNegLits()) {
				cl++;
			}
			
			for (Formula sf : f.getSubformulas()) {
				countCNF2(sf);
			}
			
		} else {
			
			if (f.getSubformulas().size() != 0) {
				countCNFMatrix(f);
				
				return;
			}
			cl++;
		}
		
	}
	
	public void printCNF2(Formula f) {
		if (f.getConnective() == CType.AND) {
			for (VOccurrence v : f.getPosLits()) {
				print(v.getVariable());
				printNewLine();
			}
			
			for (VOccurrence v : f.getNegLits()) {
				print(v.getVariable()*-1);
				printNewLine();
			}
			
			for (Formula sf : f.getSubformulas()) {
				printCNF2(sf);
			}
			
		} else {
			
			if (f.getSubformulas().size() != 0) {
				printCNFMatrix(f);
				
				return;
			}
			for (VOccurrence v : f.getPosLits()) {
				print(v.getVariable());
			}
			
			for (VOccurrence v : f.getNegLits()) {
				print(v.getVariable()*-1);
			}
			printNewLine();
		}
		
	}
	

	public void printCNFMatrix() {
		for (int i = 0; i < definedLabels.length; i++) {
			definedLabels[i] = false;
		}
		printCNFMatrix(formulaRoot);
	}
	
	private void countCNFMatrix(Formula f) {

		cl++;
		
		if (f.getConnective() == CType.AND) {
						
		for (Formula sf : f.getSubformulas()) {
				countTseitinEncoding(sf);
			}
		} else {
			
			countDisjunction(f);			
		
			for (Formula sf : f.getSubformulas()) {
				countTseitinEncoding(sf);
			}
		}
	}
	
	
	private void printCNFMatrix(Formula f) {
		print(f.getTseitinVar().getName());
		printNewLine();
		
		if (f.getConnective() == CType.AND) {
			printConjunction(f);		
			
	/*		for (VOccurrence v : f.getPosLits()) {
				print(v.getVariable());
				printNewLine();
			}
			
			for (VOccurrence v : f.getNegLits()) {
				print(v.getVariable()*-1);
				printNewLine();
			}*/
			
			
			for (Formula sf : f.getSubformulas()) {
				printTseitinEncoding(sf);
			}
		} else {
			print(f.getTseitinVar().getName()*-1);
			printDisjunction(f);			
		
			for (Formula sf : f.getSubformulas()) {
				printTseitinEncoding(sf);
			}
		}
	}
	
	private void printTseitinEncoding(Formula f) {
		
	if (!definedLabels[f.getTseitinVar().getName()]) {
			
		
			if (f.getConnective() == CType.AND) {
				printConjunction(f);
			} else {
				print(f.getTseitinVar().getName()*-1);
				printDisjunction(f);
			}
		
			definedLabels[f.getTseitinVar().getName()] = true;
			
			for (Formula sf : f.getSubformulas()) {
				printTseitinEncoding(sf);
			}
	}
		
	}
	
	private void printConjunction(Formula f) {
		for (VOccurrence v : f.getPosLits()) {
			print(f.getTseitinVar().getName()*-1);
			print(v.getVariable());
			printNewLine();
		}
		
		for (VOccurrence v : f.getNegLits()) {
			print(f.getTseitinVar().getName()*-1);
			print(v.getVariable()*-1);
			printNewLine();
		}
		
		for (Formula sf : f.getSubformulas()) {
			
			print(f.getTseitinVar().getName()*-1);
			print(sf.getTseitinVar().getName());
			printNewLine();
		}
		
	}
	
	private void printDisjunction(Formula f) {
	//	System.out.println("disj");
		for (VOccurrence v : f.getPosLits()) {
			print(v.getVariable());
		}
		
		for (VOccurrence v : f.getNegLits()) {
			print(v.getVariable()*-1);
		}
		
		for (Formula sf : f.getSubformulas()) {
			print(sf.getTseitinVar().getName());
		}
		printNewLine();
	}
	
	
	
	public int countClauses() {
		cl = 0;
		
		for (int i = 0; i < definedLabels.length; i++) {
			definedLabels[i] = false;
		}
		countClauses(formulaRoot);
		return cl;
	}
	
	private void countClauses(Formula f) {
		if (f.getConnective() == CType.AND) {
			for (VOccurrence v : f.getPosLits()) {
				
				cl++;
			}
			
			for (VOccurrence v : f.getNegLits()) {
				cl++;
				
			}
			
			for (Formula sf : f.getSubformulas()) {
				countClauses(sf);
				cl++;
			}
		} else {
			countDisjunction(f);			
			for (Formula sf : f.getSubformulas()) {
				countTseitinEncoding(sf);
			}
		}
	}
	
	private void countTseitinEncoding(Formula f) {
		
			if (!definedLabels[f.getTseitinVar().getName()]) {
			
		
			if (f.getConnective() == CType.AND) {
				countConjunction(f);
			} else {
				countDisjunction(f);
			}
		
			definedLabels[f.getTseitinVar().getName()] = true;
			
			for (Formula sf : f.getSubformulas()) {
				countTseitinEncoding(sf);
			}
		}
		
	}
	
	private void countConjunction(Formula f) {
		for (VOccurrence v : f.getPosLits()) {
			cl++;
		}
		
		for (VOccurrence v : f.getNegLits()) {
			cl++;
		}
		
		for (Formula sf : f.getSubformulas()) {
			cl++;
		}
		
	}
	
	private void countDisjunction(Formula f) {
		cl++;
		
	}
	
	
	
	
	
	
	
//	private void printNewLine() {
//		System.out.println(" "+0);
//	}
//	
//	private void print(int var) {
//		System.out.print(" "+var);
//	}
//	
	private void printNewLine() {
		try {
			out.write(" "+0+"\n");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private void print(int var) {
		try {
			out.write(" "+var);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	
	public static void main(String args[]) {
		
		
		
		System.out.println("starting parsing");
		
		FormulaData fd;
		try {
			fd = Parser.parse(new File("tests/f4.qpro"));
			System.out.println("---");
			
			FormulaToCNF ftc = new FormulaToCNF(fd,true);
			
			ftc.label();
			ftc.printCNFMatrix();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//fd.print();
		
		
		
	}
	
}
