package at.jku.fmv.qbf.nnf.transform.matrix;

import at.jku.fmv.qbf.nnf.formula.CType;

public class Label {
	private int blockSize; 
	int blockNumber;
	int half;
	private int []blocks;
	
	public Label(int nodeNumber, CType connective) {
		this.blockSize = Integer.SIZE;
		this.half = (nodeNumber/blockSize)+1;
		this.blockNumber = half*2;
		blocks = new int [blockNumber*2];
		
		if (connective == CType.AND) {
			blocks[0] = 1;
		} 
		
	}
	
	public void setLabel(int l, boolean pol){
		
		int i = l/blockSize;
		
		int flag = 1 << (l%blockSize);
		
		if (pol) {
			
			blocks[i] = blocks[i] | flag;
		} else {
			blocks[half+i] = blocks[half+i] | flag;
		}
	}
	

	public void printEncoding() {
		for (int i = 0; i < blocks.length; i++) {
			System.out.print(blocks[i]+" ");
		}
		System.out.println();
	}
	
	public int [] getEncoding() {
		return blocks;
	}
	
	public void merge(Label l1) {
		int [] bl1 = l1.getEncoding();
		for (int i = 0; i < blocks.length; i++) {
			blocks[i] = blocks[i] | bl1[i];
		}
	}
	
	
}
