package at.jku.fmv.qbf.nnf.transform.prenex;

import java.util.List;

import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;

public class AUEDMerger extends Merger {

	@Override
	public Quantifiers merge(Quantifiers l, Quantifiers r, Quantifiers prenex) {
		Quantifiers longer;
		Quantifiers shorter;

		
		if (l == null) return r;
		if (r == null) return l;

		
		
		int lsize = l.getQuantifierBlocks().size();
		int rsize = r.getQuantifierBlocks().size();
		
		if (lsize == 0) return r;
		if (rsize == 0) return l;
		
		if (lsize == rsize) {
			
			Quantifiers m = mergeEqualSize(l,r,QType.FORALL);
			return m;
		}
		
		if (lsize > rsize) {
			longer = l;
			shorter = r;
		} else {
			longer = r;
			shorter = l;
		}
		
		int start;
		int end;
		
		List<QBlock> lShorter = shorter.getQuantifierBlocks();
		List<QBlock> lLonger =  longer.getQuantifierBlocks();
		
		end = lShorter.size() - 1;
		
		if (lShorter.size() != 1) {
			if (lShorter.get(0).getQType() == lLonger.get(0).getQType()) {
				start = 0;
			} else {
				start = 1;
			}
		
			for (int i = start; i < end; i++) {
				QBlock bls = shorter.getQuantifierBlocks().get(i);
				QBlock bll = longer.getQuantifierBlocks().get(start+i);
			
				for (IVar v : bls.getVars()) {
					bll.add(v);
				}
			}
		}
		
		QBlock lastItem = lShorter.get(lShorter.size()-1);
		
		if (lastItem.getQType() == QType.EXISTS) {
			if (lLonger.get(lLonger.size()-1).getQType() == QType.EXISTS) {
				end = lLonger.size() - 1;
			} else {
				end = lLonger.size() - 2;
			}
		} 
			
		for (IVar v : lShorter.get(lShorter.size()-1).getVars()) {
			lLonger.get(end).add(v);
		}
		
		return longer;
	}

}
