package at.jku.fmv.qbf.nnf.transform.prenex;

import java.io.File;
import java.io.IOException;
import java.util.List;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;

public class AdvancedPrenexPrinter {
  private IQMerger merger;
  private Quantifiers q = null;
  private Formula f;
  
  public AdvancedPrenexPrinter(IQMerger merger, Formula f){
	  this.merger = merger;
	  this.f = f;
  }
  
  public void printPrefix() {
	  if (q == null) {
		  q = quantifyFormula(f);
		  merger.addTseitinAtBack(f.getQuantifiers());
	  }
	  
	  printPrefix(q);
  }
  
  public static void printPrefix(Quantifiers q) {
	  
	  for (QBlock b : q.getQuantifierBlocks()) {
		  if (b.getQType() == QType.EXISTS) {
			  System.out.print("e");
		  } else {
			  System.out.print("a");
		  }
		  
		  for (IVar v : b.getVars()) {
			  System.out.print(" "+v.getName());
		  }
		  
		  System.out.println(" 0");
		  
	  }
	  
  }
  
  
  public Quantifiers quantifyFormula(Formula f){
	  Quantifiers l;
	  
	 if (f.getSubformulas().size() == 0) {
		  merger.addTseitin(f);
		  return f.getQuantifiers();
	  }
	  
	  List<Formula> fs = f.getSubformulas();
	  
	  l = quantifyFormula(fs.get(0));
	  
	  for (int i = 1; i < fs.size(); i++){
		  
		  l = merger.merge(l, quantifyFormula(fs.get(i)),f.getQuantifiers());
	  }
	  
	  return merger.addPrenex(f, l);
  }
	
  
  public static void main(String args []) {
		try {	
	
			FormulaData fd = Parser.parse(new File(args[0]));
			
					System.out.println("to cnf");
			FormulaToCNF ftc = new FormulaToCNF(fd,true);
			System.out.println("to cnf");
			ftc.label();
			System.out.println("p cnf "+fd.getVarNumber()+" "+ftc.countClauses());
		
			AdvancedPrenexPrinter ap = new AdvancedPrenexPrinter(new UpMerger(), fd.getFormula());
			ap.printPrefix();
			
			ftc.printCNFMatrix();
			
			
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
  }
  
}
