package at.jku.fmv.qbf.nnf.transform.prenex;

import java.awt.List;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.formula.TseitinVar;
import at.jku.fmv.qbf.nnf.formula.VariableInfo;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;

public class AppendPrenexPrinter {
	FormulaData fd;
	LinkedList <QBlock> ex;
	LinkedList <QBlock> all;
	private QBlock last = new QBlock(QType.EXISTS);
	private Quantifiers q;
	
	boolean [] printedVars;
	
	public AppendPrenexPrinter(FormulaData fd) {
		this.fd = fd;
		
		
		printedVars = new boolean[fd.getVarNumber()+1];
		 q = new Quantifiers(fd.getFormula());
		buildPrefix(q,fd.getFormula());
		q.addQuantBlock(last);
		
	}
	
	public void printPrefix() {
		for (QBlock b : q.getQuantifierBlocks()) {
			  if (b.getQType() == QType.EXISTS) {
				  System.out.print("e");
			  } else {
				  System.out.print("a");
			  }
			  
			  for (IVar v : b.getVars()) {
				  System.out.print(" "+v.getName());
			  }
			  
			  System.out.println(" 0");
			  
		  }
			
	
 	}
	
	
	public void buildPrefix(Quantifiers q, Formula f) {
		
	
		for (QBlock qb : f.getQuantifiers().getQuantifierBlocks()) {
			if (q.size() > 0) {
				QBlock l = q.getQuantifierBlocks().get(q.size()-1);
				if (l.getQType() == qb.getQType()) {
					for (IVar v : qb.getVars()) {
						l.add(v);
					}
				} else {
					q.addQuantBlock(qb);
				}
			} else {
				q.addQuantBlock(qb);
			}
		}
		
		if (!printedVars[f.getTseitinVar().getName()]) {
			printedVars[f.getTseitinVar().getName()] = true;
			last.add(f.getTseitinVar());
		}
		
		for (Formula g: f.getSubformulas()) {
			buildPrefix(q,g);
		}
 		
		
		
	}

	public void printPrenex() {
		ex = new LinkedList<QBlock> ();
		all = new LinkedList<QBlock>();
	
		sublookforQuant(fd.getFormula());
		
	
		printedVars = new boolean[fd.getVarNumber()+1];
		
		if (!ex.isEmpty() ) printExists();
		else printForall();
	}
	
	
	private void printExists() {

		

		
		if (!ex.isEmpty()) {
			print("e ");
		} else {
			return;
		}
		
		
		
		while (!ex.isEmpty()) {
			QBlock q = ex.poll();
			
			for (IVar v : q.getVars()) {
				if (!printedVars[v.getName()]) {
					print(v.getName()+" ");
					printedVars[v.getName()] = true;
					
				}
			}
			
			int i = q.getQuantifiers().getQuantifierBlocks().indexOf(q);
			
			if (q.getQuantifiers().getQuantifierBlocks().size() > i+1) {
				all.push(q.getQuantifiers().getQuantifierBlocks().get(i+1));
			} else {
				lookforQuant(q.getQuantifiers().getFormula());
			}
			
			
		}
		
		print("0\n");
		
		printForall();
		
	}
	
	
	private void print(String s) {
		System.out.print(s);
		
	}
	 
	private void printForall() {
	
		if (!all.isEmpty()) {
			print("a ");
		} else {
			return;
		}
		
		while (!all.isEmpty()) {
			QBlock q = all.poll();
			
			for (IVar v : q.getVars()) {
				if (!printedVars[v.getName()]) {
					print(v.getName()+" ");
					printedVars[v.getName()] = true;
					
				}
			}
			
			int i = q.getQuantifiers().getQuantifierBlocks().indexOf(q);
			
			if (q.getQuantifiers().getQuantifierBlocks().size() > i+1) {
				ex.push(q.getQuantifiers().getQuantifierBlocks().get(i+1));
			} else {
				lookforQuant(q.getQuantifiers().getFormula());
			}
		}
		
		print("0\n");
		
		printExists();
	}
	

	
	private void lookforQuant(Formula f) {
		
		for (Formula fs : f.getSubformulas()) {
			sublookforQuant(fs);
		}
		
	}
	
	private void sublookforQuant(Formula f) {
		if (!printedVars[f.getTseitinVar().getName()]) last.add(f.getTseitinVar());
		printedVars[f.getTseitinVar().getName()] = true;
		
		
		if ((f.getQuantifiers() == null) || ((f.getQuantifiers().getQuantifierBlocks() == null) || (f.getQuantifiers().getQuantifierBlocks().size() == 0))){
			for (Formula fs : f.getSubformulas()) {
				sublookforQuant(fs);
			}
			return;
		} else {
			
			Quantifiers q1 = f.getQuantifiers();
	

			ArrayList <QBlock> qb = (ArrayList<QBlock>) q1.getQuantifierBlocks();
			
			
			if (qb.size() != 0) {
				
			QBlock q = qb.get(0);
		  
			if (q.getQType() == QType.EXISTS) {
				ex.push(q);
			} else {
				all.push(q);
			}
			}
		}
	}
	
	
	
	public static void main(String args[]) {
		//System.out.println("starting parsing");
		
		
		long zstVorher;
		long zstNachher;

		//zstVorher = System.currentTimeMillis();

		
		try {
			FormulaData fd = Parser.parse(new File("tests/a.qpro"));
		//	FormulaData fd = Parser.parse(new File(args[0]));
			
			FormulaToCNF ftc = new FormulaToCNF(fd,true);
			ftc.label();
			System.out.println("p cnf "+fd.getVarNumber()+" "+ftc.countClauses());
			AppendPrenexPrinter p = new AppendPrenexPrinter(fd);
			
			p.printPrefix();
		
	//		ftc.printCNFMatrix();
			
			
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//zstNachher = System.currentTimeMillis();
		//System.out.println("Zeit benötigt: " + ((zstNachher - zstVorher)) + " ms");
	
		
		
		
		//System.out.println("---");
		
	//	FormulaToCNF ftc = new FormulaToCNF(fd);
		//ftc.label();
		
	//	zstNachher = System.currentTimeMillis();
	//	System.out.println("Zeit benötigt: " + ((zstNachher - zstVorher)) + " ms");
	
		

		//System.out.println(fd.getVarNumber());
		
	}
	
}
