package at.jku.fmv.qbf.nnf.transform.prenex;

import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;

public class DownMerger extends Merger {

	@Override
	public Quantifiers merge(Quantifiers l, Quantifiers r, Quantifiers prenex) {
		Quantifiers longer;
		Quantifiers shorter;

		
		if (l == null) return r;
		if (r == null) return l;

		
		
		int lsize = l.getQuantifierBlocks().size();
		int rsize = r.getQuantifierBlocks().size();
		
		if (lsize == 0) return r;
		if (rsize == 0) return l;
		
		if (lsize == rsize) {
			
			Quantifiers m = mergeEqualSize(l,r,QType.EXISTS);
			return m;
		}
		
		if (lsize > rsize) {
			longer = l;
			shorter = r;
		} else {
			longer = r;
			shorter = l;
		}
		
		int start;
		int end;
		
		
		if (longer.getQuantifierBlocks().get(longer.getQuantifierBlocks().size()-1).getQType() == 
			shorter.getQuantifierBlocks().get(shorter.getQuantifierBlocks().size()-1).getQType()) {
			start = longer.getQuantifierBlocks().size() - shorter.getQuantifierBlocks().size();
			end = shorter.getQuantifierBlocks().size();
		} else {
			start = longer.getQuantifierBlocks().size() - shorter.getQuantifierBlocks().size()-1;
			end = shorter.getQuantifierBlocks().size();
		}
		for (int i = 0; i < end; i++) {
			QBlock bls = shorter.getQuantifierBlocks().get(i);
			QBlock bll = longer.getQuantifierBlocks().get(start+i);
			
			for (IVar v : bls.getVars()) {
				bll.add(v);
			}
		}
		
//		if (shorter.getQuantifierBlocks().size() != end) {
//			longer.getQuantifierBlocks().add(shorter.getQuantifierBlocks().get(shorter.getQuantifierBlocks().size()-1));
//		}
		
		return longer;
	}

}
