package at.jku.fmv.qbf.nnf.transform.prenex;

import java.util.List;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.formula.TseitinVar;

public abstract class Merger implements IQMerger {
	private TseitinPosition tp = TseitinPosition.FRONT;
	private QBlock last = new QBlock(QType.EXISTS);
	
	
	public void setTseitinPosition(TseitinPosition tp) {
		this.tp = tp;
	}
	
	protected Quantifiers mergeEqualSize(Quantifiers l, Quantifiers r, QType preferedType) {
		
		assert (l.getQuantifierBlocks().size() == r.getQuantifierBlocks().size()) : "assertion failed: different size";
	
		List <QBlock> qll = l.getQuantifierBlocks();
		List <QBlock> qlr = r.getQuantifierBlocks();
		
		
		
		if (qll.size() == 0) return r;
		if (qlr.size() == 0) return l;
		
		if (qll.get(0).getQType() == qlr.get(0).getQType()) {
			
			for (int i = 0; i < qll.size(); i++) {
				QBlock qbr = qlr.get(i);
				QBlock qbl = qll.get(i);
				for (IVar v : qbr.getVars()) {
					qbl.add(v);
				}
			}
			return l;
		}
		
		if (preferedType != qll.get(0).getQType()) {
			
			for (int i = 1; i < qll.size(); i++) {
				QBlock qbr = qlr.get(i-1);
				QBlock qbl = qll.get(i);
				for (IVar v : qbr.getVars()) {
					qbl.add(v);
				}
			}
			return l;
		}
		
		for (int i = 1; i < qlr.size(); i++) {
			QBlock qbr = qlr.get(i);
			QBlock qbl = qll.get(i-1);
			for (IVar v : qbl.getVars()) {
				qbr.add(v);
			}
		}
		return r;
	}
	
	abstract public Quantifiers merge(Quantifiers l, Quantifiers r, Quantifiers prenex);

	

	
	@Override
	public Quantifiers addPrenex(Formula f, Quantifiers q) {
		Quantifiers p;
		q.setFormula(f);
		
		if (f.getQuantifiers().size() != 0) {
			p = f.getQuantifiers();
		} else {
			p = q;
		}
			
		switch (tp) {
			case FRONT:
				addTVAtFront(f.getTseitinVar(), p);
				break;
			case MIDDLE:
				addTVAtMiddle(f.getTseitinVar(), p);
				break;
			case BACK:
				addTVAtBack(f.getTseitinVar());
				break;
		}
		
		if (f.getQuantifiers().size() == 0) {
			f.setQuantifier(p);
			return p;
		}
		
	
		if (q.size() == 0) {
			return f.getQuantifiers();
		}
		
		List <QBlock> ql = q.getQuantifierBlocks();
		List <QBlock> qf = f.getQuantifiers().getQuantifierBlocks();
		
		if (qf.get(qf.size()-1).getQType() == ql.get(0).getQType()) {
			for (IVar v : ql.get(0).getVars()) {
				qf.get(qf.size()-1).add(v);
			}
			for (int i = 1; i < ql.size(); i++) {
				qf.add(ql.get(i));
			}
		} else {
			for (QBlock qb : ql) {
				f.getQuantifiers().addQuantBlock(qb);
			}	
		}
		
		return f.getQuantifiers();
		
	}
	
	public void addTseitinAtBack(Quantifiers q) {
		
		if (tp != TseitinPosition.BACK) return;
		
		List <QBlock> ql = q.getQuantifierBlocks();
		
		if (ql.size() == 0) {
			q.addQuantBlock(last);
			return;
		}
		
		if (ql.get(ql.size()-1).getQType() == QType.EXISTS) {
			
			
			ql.get(ql.size()-1).setQuantifiers(last.getQuantifiers());
			for (IVar v : last.getVars()) {
				ql.get(ql.size()-1).add(v);
			}
			
			return;
		}
		
		q.addQuantBlock(last);
		
	}
	

	private void addTVAtBack(TseitinVar tseitinVar) {
		if (!tseitinVar.isInPrefix()) last.add(tseitinVar);
		tseitinVar.setInPrefix();
	}

	private void addTVAtFront(TseitinVar tseitinVar, Quantifiers q) {
		List <QBlock> ql = q.getQuantifierBlocks();
		
		if (tseitinVar.isInPrefix()) { 
			return;
		}
		
		tseitinVar.setInPrefix();
		
		if (ql.size() == 0) {
			QBlock qb = new QBlock(QType.EXISTS);
			qb.setQuantifiers(q);
			qb.add(tseitinVar);
			q.addQuantBlock(qb);
			return;
		}
		
		if (ql.get(0).getQType() == QType.EXISTS) {
			ql.get(0).add(tseitinVar);
			return;
		}
		
		QBlock qb = new QBlock(QType.EXISTS);
		qb.setQuantifiers(q);
		qb.add(tseitinVar);
		q.getQuantifierBlocks().add(0,qb); // ERROR?
	}
	

	private void addTVAtMiddle(TseitinVar tseitinVar, Quantifiers q) {
		List <QBlock> ql = q.getQuantifierBlocks();

		if (tseitinVar.isInPrefix()) { 
			return;
		}
		
		tseitinVar.setInPrefix();
		
		
		if (ql.size() == 0) {
			QBlock qb = new QBlock(QType.EXISTS);
			qb.setQuantifiers(q);
			qb.add(tseitinVar);
			q.addQuantBlock(qb);
			return;
		}
		
		if (ql.get(ql.size()-1).getQType() == QType.EXISTS) {
			ql.get(ql.size()-1).add(tseitinVar);
			return;
		}
		
		QBlock qb = new QBlock(QType.EXISTS);
		qb.setQuantifiers(q);
		qb.add(tseitinVar);
		q.addQuantBlock(qb); // ERROR?
	}


	
	public void addTseitin(Formula f) {
		
		switch (tp) {
			case FRONT:
				addTVAtFront(f.getTseitinVar(), f.getQuantifiers());
				break;
			case MIDDLE:
				addTVAtMiddle(f.getTseitinVar(), f.getQuantifiers());
				break;
			case BACK:
				addTVAtBack(f.getTseitinVar());
				break;
		}
	}
	
	
}
