package at.jku.fmv.qbf.nnf.transform.prenex;

import java.awt.List;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.formula.TseitinVar;
import at.jku.fmv.qbf.nnf.formula.VariableInfo;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;

public class PrenexPrinter {
	FormulaData fd;
	LinkedList <QBlock> ex;
	LinkedList <QBlock> all;
	LinkedList <TseitinVar> tseitin;
	boolean [] printedTseitinVars;
	
	public PrenexPrinter(FormulaData fd) {
		this.fd = fd;
	}

	public void printPrenex() {
		ex = new LinkedList<QBlock> ();
		all = new LinkedList<QBlock>();
		tseitin = new LinkedList<TseitinVar>();
		sublookforQuant(fd.getFormula());
		
		printedTseitinVars = new boolean[fd.getVarNumber()+1];
		
		if (!ex.isEmpty() || !tseitin.isEmpty()) printExists();
		else printForall();
	}
	
	
	private void printExists() {

		
		while (!tseitin.isEmpty() && printedTseitinVars[tseitin.peek().getName()]) {
			tseitin.pop();
		}
		
		if (!tseitin.isEmpty() || !ex.isEmpty()) {
			print("e ");
		} else {
			return;
		}
		
		while (!tseitin.isEmpty()) {
			TseitinVar t = tseitin.pop();
	
			if (!printedTseitinVars[t.getName()]) {
				
				print(t.getName()+" ");
				printedTseitinVars[t.getName()] = true;
				
			}
		}
		
		while (!ex.isEmpty()) {
			QBlock q = ex.poll();
			
			for (IVar v : q.getVars()) {
				if (!printedTseitinVars[v.getName()]) {
					print(v.getName()+" ");
					printedTseitinVars[v.getName()] = true;
					
				}
			}
			
			int i = q.getQuantifiers().getQuantifierBlocks().indexOf(q);
			
			if (q.getQuantifiers().getQuantifierBlocks().size() > i+1) {
				all.push(q.getQuantifiers().getQuantifierBlocks().get(i+1));
			} else {
				lookforQuant(q.getQuantifiers().getFormula());
			}
			
			while (!tseitin.isEmpty()) {
				TseitinVar t = tseitin.pop();
				if (!printedTseitinVars[t.getName()]) {
					print(t.getName()+" ");
					printedTseitinVars[t.getName()] = true;
					
				}
			}
		}
		
		print("0\n");
		
		printForall();
		
	}
	
	
	private void print(String s) {
		System.out.print(s);
		
	}
	 
	private void printForall() {
	
		if (!all.isEmpty()) {
			print("a ");
		} else {
			return;
		}
		
		while (!all.isEmpty()) {
			QBlock q = all.poll();
			
			for (IVar v : q.getVars()) {
				if (!printedTseitinVars[v.getName()]) {
					print(v.getName()+" ");
					printedTseitinVars[v.getName()] = true;
					
				}
			}
			
			int i = q.getQuantifiers().getQuantifierBlocks().indexOf(q);
			
			if (q.getQuantifiers().getQuantifierBlocks().size() > i+1) {
				ex.push(q.getQuantifiers().getQuantifierBlocks().get(i+1));
			} else {
				lookforQuant(q.getQuantifiers().getFormula());
			}
		}
		
		print("0\n");
		
		printExists();
	}
	

	
	private void lookforQuant(Formula f) {
		
		for (Formula fs : f.getSubformulas()) {
			sublookforQuant(fs);
		}
		
	}
	
	private void sublookforQuant(Formula f) {
		if (f.getTseitinVar() != null) {
			tseitin.add(f.getTseitinVar());
		}
		
		if ((f.getQuantifiers() == null) || ((f.getQuantifiers().getQuantifierBlocks() == null) || (f.getQuantifiers().getQuantifierBlocks().size() == 0))){
			for (Formula fs : f.getSubformulas()) {
				sublookforQuant(fs);
			}
			return;
		} else {
			
			Quantifiers q1 = f.getQuantifiers();
	

			ArrayList <QBlock> qb = (ArrayList<QBlock>) q1.getQuantifierBlocks();
			
			
			if (qb.size() != 0) {
				
			QBlock q = qb.get(0);
		  
			if (q.getQType() == QType.EXISTS) {
				ex.push(q);
			} else {
				all.push(q);
			}
			}
		}
	}
	
	
	
	public static void main(String args[]) {
		//System.out.println("starting parsing");
		
		
		long zstVorher;
		long zstNachher;

		//zstVorher = System.currentTimeMillis();

		
		try {
			FormulaData fd = Parser.parse(new File("tests/f11"));
		//	FormulaData fd = Parser.parse(new File(args[0]));
			
			FormulaToCNF ftc = new FormulaToCNF(fd,true);
			ftc.label();
			System.out.println("p cnf "+fd.getVarNumber()+" "+ftc.countClauses());
			PrenexPrinter p = new PrenexPrinter(fd);
			
			p.printPrenex();
		
			ftc.printCNFMatrix();
			
			
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//zstNachher = System.currentTimeMillis();
		//System.out.println("Zeit benötigt: " + ((zstNachher - zstVorher)) + " ms");
	
		
		
		
		//System.out.println("---");
		
	//	FormulaToCNF ftc = new FormulaToCNF(fd);
		//ftc.label();
		
	//	zstNachher = System.currentTimeMillis();
	//	System.out.println("Zeit benötigt: " + ((zstNachher - zstVorher)) + " ms");
	
		

		//System.out.println(fd.getVarNumber());
		
	}
	
}
