import java.io.File;
import java.io.IOException;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;
import at.jku.fmv.qbf.nnf.transform.prenex.AUEDMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.AdvancedPrenexPrinter;
import at.jku.fmv.qbf.nnf.transform.prenex.DownMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.EUADMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.IQMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.TseitinPosition;
import at.jku.fmv.qbf.nnf.transform.prenex.UpMerger;

public class pcnft {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String filename = null;
		boolean doHashing = true;
		boolean printBoole = false;
		
		Options options = new Options();
		options.addOption("s", true, "strategy: up, down, euad, aued");
		options.addOption("t", true,
				"position of tseitin var: front, middle, back");
		options.addOption("h", false, "print this help");
		options.addOption("i", true,
				"input file (formula to transform in qpro format");
		options.addOption("r", false, "disable structure sharing");
		options.addOption("b", false, "print Formula in Boole format and quit");
		
		HelpFormatter formatter = new HelpFormatter();
		IQMerger merger = null;
		

		CommandLineParser parser = new PosixParser();
		try {
			CommandLine cmd = parser.parse(options, args);
			
			if (cmd.hasOption("b")) {
				printBoole = true;
			}

			if (cmd.hasOption("h")) {
				formatter.printHelp("pcnf transform", options);
				System.exit(0);
			}

			if (cmd.hasOption("i")) {
				filename = cmd.getOptionValue("i");
			}
			
			if (cmd.hasOption("r")) {
				doHashing = false;
			}

			if (cmd.hasOption("s")) {
				String strat = cmd.getOptionValue("s");

				if (strat.equalsIgnoreCase("up")) {
					merger = new UpMerger();
				} else {
					if (strat.equalsIgnoreCase("down")) {
						merger = new DownMerger();
					} else {
						if (strat.equalsIgnoreCase("euad")) {
							merger = new EUADMerger();
						} else {
							if (strat.equalsIgnoreCase("aued")) {
								merger = new AUEDMerger();
							} else {
								System.err.println("unknown strategy");
								System.exit(1);
							}
						}
					}
				}

			} else {
				System.err.println("strategy expected");
				System.exit(1);
			}

			if (cmd.hasOption("t")) {

				String pos = cmd.getOptionValue("t");

				if (pos.equalsIgnoreCase("front")) {
					merger.setTseitinPosition(TseitinPosition.FRONT);
				} else {
					if (pos.equalsIgnoreCase("middle")) {
						merger.setTseitinPosition(TseitinPosition.MIDDLE);
					} else {
						if (pos.equalsIgnoreCase("back")) {
							merger.setTseitinPosition(TseitinPosition.BACK);
						} else {
							System.err.println("unknown tseitin position");
							System.exit(1);
						}
					}
				}
			} else {
				System.err.println("tseitin position expected");
				System.exit(1);
			}

			FormulaData fd;

			if (filename != null) {
				fd = Parser.parse(new File(filename));
			} else {
				fd = Parser.parse(System.in);
			}
			
			if (printBoole) {
				fd.printBoole();
				System.exit(0);
			}

			FormulaToCNF ftc = new FormulaToCNF(fd, doHashing);
			ftc.label();
			
			System.out.println("p cnf " + fd.getVarNumber() + " "
					+ ftc.countClauses());
			AdvancedPrenexPrinter ap = new AdvancedPrenexPrinter(
					merger, fd.getFormula());

			ap.printPrefix();
			ftc.printCNFMatrix();

		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (at.jku.fmv.qbf.nnf.parser.ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}