import java.io.File;
import java.io.IOException;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;
import at.jku.fmv.qbf.nnf.transform.prenex.AUEDMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.AdvancedPrenexPrinter;
import at.jku.fmv.qbf.nnf.transform.prenex.AppendPrenexPrinter;
import at.jku.fmv.qbf.nnf.transform.prenex.DownMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.EUADMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.IQMerger;
import at.jku.fmv.qbf.nnf.transform.prenex.Merger;
import at.jku.fmv.qbf.nnf.transform.prenex.PrenexPrinter;
import at.jku.fmv.qbf.nnf.transform.prenex.TseitinPosition;
import at.jku.fmv.qbf.nnf.transform.prenex.UpMerger;

public class qpro2qdimacs {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String filename = null;
		boolean doHashing = true;
		boolean printBoole = false;
		boolean pol = true;
		
		Options options = new Options();
		options.addOption("n", false, "negate Formula");
		options.addOption("h", false, "print this help");
		options.addOption("b", false, "print Formula in Boole format and quit");
		options.addOption("i", true,
		"input file (formula to transform in qpro format");
		options.addOption("f",false, "put Tseitin as left as possible in prefix");
		
		HelpFormatter formatter = new HelpFormatter();
		IQMerger merger = null;
		

		boolean tseitinPos = false;
		
		CommandLineParser parser = new PosixParser();
		try {
			CommandLine cmd = parser.parse(options, args);
			
			if (cmd.hasOption("b")) {
				printBoole = true;
			}

			if (cmd.hasOption("h")) {
				formatter.printHelp("qpro2qdimacs", options);
				System.exit(0);
			}

			if (cmd.hasOption("n")) {
				pol = false;
			}
			
			if (cmd.hasOption("i")) {
				filename = cmd.getOptionValue("i");
			}
			
			if (cmd.hasOption("f")) {
				tseitinPos = true;
			}
		
			

			FormulaData fd;

			if (filename != null) {
				fd = Parser.parse(new File(filename),pol);
			} else {
				fd = Parser.parse(System.in,pol);
			}
			
			if (printBoole) {
				fd.printBoole();
				System.exit(0);
			}

			FormulaToCNF ftc = new FormulaToCNF(fd, true);
			ftc.label();
			
			System.out.println("p cnf " + fd.getVarNumber() + " "
					+ ftc.countClauses());
			
			
			AppendPrenexPrinter pp = new AppendPrenexPrinter(fd);

			pp.printPrefix();
			ftc.printCNFMatrix();
		/*	if (tseitinPos) {
				AppendPrenexPrinter pp = new AppendPrenexPrinter(fd);

				pp.printPrefix();
				//ftc.printCNFMatrix();
			} else {
				Merger up = new DownMerger();
				up.setTseitinPosition(TseitinPosition.BACK);
				AdvancedPrenexPrinter ap = new AdvancedPrenexPrinter(up, fd.getFormula());
				
				ap.printPrefix();
			//ftc.printCNFMatrix();
			} */
			
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (at.jku.fmv.qbf.nnf.parser.ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}