/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.commandhandler;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.modelevolution.multiview.conflictreport.ConflictReport;
import org.modelevolution.multiview.conflictreport.ConflictReportPackage;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramEditor;

public class LoadConflictReport
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart diagramEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        Shell shell = diagramEditor.getEditorSite().getShell();
        LoadConflictDialog dialog = new LoadConflictDialog(shell, "Load Conflict Report", 4096);
        dialog.open();
        ConflictReport conflictReport = dialog.getConflictReport();
        if (conflictReport != null) {
            MultiviewDiagramEditor editor = (MultiviewDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            editor.setConflictReport(conflictReport);
            editor.initConflictResolveMode();
        }
        return null;
    }

    public class LoadConflictDialog
    extends ResourceDialog {
        private ConflictReport conflictReport;

        public LoadConflictDialog(Shell parent, String title, int style) {
            super(parent, title, style);
            ConflictReportPackage.eINSTANCE.eClass();
        }

        protected boolean processResources() {
            List uriList = this.getURIs();
            if (uriList.size() != 1) {
                this.conflictReport = null;
                MessageDialog.openError((Shell)this.getShell(), (String)"Invalid conflict report", (String)"No conflict report selected");
                return false;
            }
            URI fileURI = (URI)uriList.get(0);
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(fileURI, true);
                this.conflictReport = (ConflictReport)resource.getContents().get(0);
            }
            catch (RuntimeException exception) {
                EMFEditUIPlugin.INSTANCE.log((Object)exception);
                this.conflictReport = null;
                MessageDialog.openError((Shell)this.getShell(), (String)"Invalid conflict report", (String)"Invalid conflict report selected");
                return false;
            }
            return true;
        }

        public ConflictReport getConflictReport() {
            return this.conflictReport;
        }
    }
}

