/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.diagram.edit.policies.MultiviewBaseItemSemanticEditPolicy;

public class MessageReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;
    private Lifeline newLifeline = null;

    public MessageReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        Message msg = (Message)this.getElementToEdit();
        switch (this.reorientDirection) {
            case 1: {
                this.oldEnd = msg.getSender();
                break;
            }
            case 2: {
                this.oldEnd = msg.getReceiver();
                break;
            }
            default: {
                this.oldEnd = null;
            }
        }
        if (request.getNewRelationshipEnd() instanceof Lifeline) {
            this.newLifeline = (Lifeline)request.getNewRelationshipEnd();
            switch (this.reorientDirection) {
                case 1: {
                    this.newEnd = MultiviewFactory.eINSTANCE.createSendEvent();
                    break;
                }
                case 2: {
                    this.newEnd = MultiviewFactory.eINSTANCE.createReceiveEvent();
                    break;
                }
                default: {
                    this.newEnd = null;
                    break;
                }
            }
        } else {
            this.newEnd = request.getNewRelationshipEnd();
        }
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Message)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof SendEvent) || !(this.newEnd instanceof SendEvent) && !(this.newEnd instanceof Lifeline)) {
            return false;
        }
        ReceiveEvent target = this.getLink().getReceiver();
        if (!(this.getLink().eContainer() instanceof SequenceView)) {
            return false;
        }
        SequenceView container = (SequenceView)this.getLink().eContainer();
        return MultiviewBaseItemSemanticEditPolicy.getLinkConstraints().canExistMessage_4001(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ReceiveEvent) || !(this.newEnd instanceof ReceiveEvent)) {
            return false;
        }
        SendEvent source = this.getLink().getSender();
        if (!(this.getLink().eContainer() instanceof SequenceView)) {
            return false;
        }
        SequenceView container = (SequenceView)this.getLink().eContainer();
        return MultiviewBaseItemSemanticEditPolicy.getLinkConstraints().canExistMessage_4001(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        SendEvent newSource = this.getNewSource();
        SendEvent sendEvent = null;
        SendEvent oldSendEvent = this.getOldSource();
        oldSendEvent.getLifeline().getElements().remove((Object)oldSendEvent);
        sendEvent = newSource;
        if (this.newLifeline != null) {
            this.newLifeline.getElements().add((Object)sendEvent);
        }
        this.getLink().setSender(sendEvent);
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        ReceiveEvent newSource = this.getNewTarget();
        ReceiveEvent receiveEvent = null;
        ReceiveEvent oldReceiveEvent = this.getOldTarget();
        oldReceiveEvent.getLifeline().getElements().remove((Object)oldReceiveEvent);
        receiveEvent = newSource;
        if (this.newLifeline != null) {
            this.newLifeline.getElements().add((Object)receiveEvent);
        }
        this.getLink().setReceiver(receiveEvent);
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Message getLink() {
        return (Message)this.getElementToEdit();
    }

    protected SendEvent getOldSource() {
        return (SendEvent)this.oldEnd;
    }

    protected SendEvent getNewSource() {
        return (SendEvent)this.newEnd;
    }

    protected ReceiveEvent getOldTarget() {
        return (ReceiveEvent)this.oldEnd;
    }

    protected ReceiveEvent getNewTarget() {
        return (ReceiveEvent)this.newEnd;
    }
}

