/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.modelevolution.multiview.LifelineElement;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.diagram.requests.ReorderLifelineElementRequest;
import org.modelevolution.multiview.diagram.util.MultiviewDiagramUtil;

public class ReorderLifelineElementCommand
extends EditElementCommand {
    private LifelineElement element;
    private int index;

    public ReorderLifelineElementCommand(ReorderLifelineElementRequest req) {
        super("", (EObject)req.getElement(), (IEditCommandRequest)req);
        this.index = req.getIndexMove();
        this.element = req.getElement();
    }

    public boolean canExecute() {
        boolean executable = this.element != null;
        executable = executable && this.element.getLifeline() != null;
        return executable;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Message msg;
        EList elements = this.element.getLifeline().getElements();
        int size = elements.size();
        int newIndex = this.index;
        ReceiveEvent receiveEvent = null;
        if (this.element instanceof SendEvent && (msg = ((SendEvent)this.element).getMessage()) != null) {
            receiveEvent = msg.getReceiver();
        }
        if (newIndex < 0) {
            return CommandResult.newErrorCommandResult((String)"Undoable move");
        }
        if (newIndex < size) {
            elements.remove((Object)this.element);
            elements.add(newIndex, (Object)this.element);
        } else {
            elements.remove((Object)this.element);
            elements.add((Object)this.element);
        }
        newIndex = elements.indexOf((Object)this.element);
        if (receiveEvent != null && elements.contains((Object)receiveEvent) && elements.indexOf((Object)receiveEvent) < newIndex) {
            elements.remove((Object)receiveEvent);
            elements.add(newIndex, (Object)receiveEvent);
        }
        MultiviewDiagramUtil.getSequenceViewEditPart().getLayout().reorderLifelineElements();
        return CommandResult.newOKCommandResult();
    }
}

