/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.figures;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.modelevolution.multiview.diagram.figures.IMoveableLifelineConflictFigure;

public class ConflictMergeOptionOverview
extends Figure
implements IMoveableLifelineConflictFigure {
    private static final Point DEFAULT_SPACING = new Point(10, 0);
    private static final RGB DEFAULT_OUTLINE_COLOR = new RGB(200, 200, 200);
    private static final RGB DEFAULT_OUTLINE_COLOR_ACTIVE = new RGB(0, 0, 0);
    private static final RGB DEFAULT_OUTLINE_COLOR_ELEMENTS = new RGB(0, 0, 0);
    private static final int[] DASH_PATTERN = new int[]{10, 5};
    private List<List<IFigure>> mergeOptions = new ArrayList<List<IFigure>>();
    private Point spacing = DEFAULT_SPACING;
    private List<Integer> horizontalLifelinePositions = new ArrayList<Integer>();
    private int numLifelines;
    private int selectedMergeOptionIndex;

    public ConflictMergeOptionOverview(int numLifelines) {
        this.numLifelines = numLifelines;
        int i = 0;
        while (i < numLifelines) {
            this.horizontalLifelinePositions.add(null);
            ++i;
        }
        this.selectedMergeOptionIndex = 0;
    }

    protected void paintFigure(Graphics graphics) {
        int i = 0;
        Point childOrigin = new Point();
        for (List<IFigure> children : this.mergeOptions) {
            Dimension mergeOptionAreaDimension = this.calculateChildAreaSize(children);
            ++mergeOptionAreaDimension.width;
            ++mergeOptionAreaDimension.height;
            Rectangle mergeOptionArea = new Rectangle(childOrigin, mergeOptionAreaDimension);
            if (i == this.selectedMergeOptionIndex) {
                graphics.setForegroundColor(new Color((Device)Display.getCurrent(), DEFAULT_OUTLINE_COLOR_ACTIVE));
            } else {
                graphics.setForegroundColor(new Color((Device)Display.getCurrent(), DEFAULT_OUTLINE_COLOR));
            }
            graphics.drawRectangle(mergeOptionArea);
            graphics.translate(childOrigin);
            for (IFigure child : children) {
                graphics.setForegroundColor(new Color((Device)Display.getCurrent(), DEFAULT_OUTLINE_COLOR_ELEMENTS));
                child.paint(graphics);
            }
            graphics.translate(childOrigin.getNegated());
            graphics.pushState();
            this.drawLifelines(graphics, mergeOptionArea, this.numLifelines);
            graphics.popState();
            childOrigin.translate(this.spacing.x, 0);
            childOrigin.translate(mergeOptionAreaDimension.width, 0);
            ++i;
        }
    }

    private void drawLifelines(Graphics graphics, Rectangle bounds, int numLifelines) {
        int lifelineWidth = bounds.width / numLifelines;
        Point topLeft = bounds.getTopLeft();
        Point bottomLeft = bounds.getBottomLeft();
        Point topPoint = bounds.getTopLeft();
        Point bottomPoint = bounds.getBottomLeft();
        int i = 0;
        while (i < numLifelines) {
            Integer value;
            int xOffset = 0;
            xOffset = i < this.horizontalLifelinePositions.size() ? ((value = this.horizontalLifelinePositions.get(i)) == null ? i * lifelineWidth + lifelineWidth / 2 : value) : i * lifelineWidth + lifelineWidth / 2;
            topPoint.setX(topLeft.x + xOffset);
            bottomPoint.setX(bottomLeft.x + xOffset);
            graphics.setLineStyle(2);
            graphics.setLineDash(DASH_PATTERN);
            graphics.drawLine(topPoint, bottomPoint);
            ++i;
        }
    }

    private Dimension calculateChildAreaSize(List<IFigure> childList) {
        Dimension childAreaSize = new Dimension();
        if (childList.isEmpty()) {
            childAreaSize.height = 10;
            childAreaSize.width = 10;
        } else {
            ListIterator<IFigure> childIt = childList.listIterator();
            while (childIt.hasNext()) {
                IFigure child = childIt.next();
                Dimension childSize = child.getSize();
                childAreaSize.height += childSize.height;
                if (childSize.width <= childAreaSize.width) continue;
                childAreaSize.width = childSize.width;
            }
        }
        return childAreaSize;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dimension = new Dimension();
        for (List<IFigure> children : this.mergeOptions) {
            Dimension childDimension = this.calculateChildAreaSize(children);
            if (dimension.width > 0) {
                dimension.width += this.spacing.x;
            }
            dimension.width += childDimension.width;
            dimension.height = Math.max(dimension.height, childDimension.height);
        }
        return dimension;
    }

    public List<List<IFigure>> getMergeOptions() {
        return this.mergeOptions;
    }

    public void addMergeOptionChild(int mergeOptionIndex, IFigure child) {
        while (this.mergeOptions.size() <= mergeOptionIndex) {
            this.mergeOptions.add(new ArrayList());
        }
        List<IFigure> mergeOptionChildren = this.mergeOptions.get(mergeOptionIndex);
        mergeOptionChildren.add(child);
        child.setParent((IFigure)this);
    }

    public int getMergeOptionIndexFromPoint(Point p) {
        int i = 0;
        Point childOrigin = this.getBounds().getTopLeft();
        for (List<IFigure> children : this.mergeOptions) {
            Dimension mergeOptionAreaDimension = this.calculateChildAreaSize(children);
            ++mergeOptionAreaDimension.width;
            ++mergeOptionAreaDimension.height;
            Rectangle mergeOptionArea = new Rectangle(childOrigin, mergeOptionAreaDimension);
            if (mergeOptionArea.contains(p)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void setHorizontalLifelinePosition(int lifeline, int position) {
        this.horizontalLifelinePositions.set(lifeline, new Integer(position));
    }

    @Override
    public Integer getHorizontalLifelinePosition(int lifeline) {
        return this.horizontalLifelinePositions.get(lifeline);
    }

    public int getSelectedMergeOptionIndex() {
        return this.selectedMergeOptionIndex;
    }

    public void setSelectedMergeOptionIndex(int selectedMergeOptionIndex) {
        this.selectedMergeOptionIndex = selectedMergeOptionIndex;
    }
}

