/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class LifelineFigure
extends Shape {
    private static final int[] DASH_PATTERN = new int[]{10, 5};
    private static final int DEFAULT_HEIGHT = 50;

    protected void fillShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        int height = 50;
        if (this.getChildren().size() > 0) {
            Figure child = (Figure)this.getChildren().get(0);
            height = (child.getBounds().y - this.getBounds().y) * 2 + child.getSize().height;
        }
        Rectangle nameRect = new Rectangle(bounds.getTopLeft(), new Dimension(bounds.width, height));
        graphics.fillRectangle(nameRect);
    }

    protected void outlineShape(Graphics graphics) {
        graphics.pushState();
        int height = 50;
        if (this.getChildren().size() > 0) {
            Figure child = (Figure)this.getChildren().get(0);
            height = (child.getBounds().y - this.getBounds().y) * 2 + child.getSize().height;
        }
        Rectangle nameRect = Rectangle.SINGLETON.setBounds(this.getBounds());
        int lineInset = Math.round(this.getLineWidthFloat());
        nameRect.x += lineInset;
        nameRect.y += lineInset;
        nameRect.width -= lineInset * 2;
        nameRect.height = height + lineInset * 2;
        graphics.drawRectangle(nameRect);
        graphics.setLineStyle(2);
        graphics.setLineDash(DASH_PATTERN);
        graphics.drawLine(nameRect.getBottom(), nameRect.getBottom().setY(this.bounds.getBottom().y));
        graphics.popState();
    }
}

