/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.layout;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class DelegatingFreeformLayout
extends FreeformLayout {
    private Map<IFigure, Locator> locators = new HashMap<IFigure, Locator>();

    public void layout(IFigure parent) {
        Iterator children = parent.getChildren().iterator();
        Point offset = this.getOrigin(parent);
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            Locator locator = this.locators.get(f);
            if (locator != null) {
                locator.relocate(f);
                continue;
            }
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (bounds == null) continue;
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = f.getPreferredSize(bounds.width, bounds.height);
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            bounds = bounds.getTranslated(offset);
            f.setBounds(bounds);
        }
    }

    public void setLocator(IFigure figure, Locator locator) {
        this.locators.put(figure, locator);
    }

    public Locator getLocator(IFigure figure) {
        return this.locators.get(figure);
    }

    public void removeLocator(IFigure figure) {
        this.locators.remove(figure);
    }
}

