/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.layout;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class FillLayout
extends AbstractLayout {
    public void layout(IFigure container) {
        Rectangle clientArea = container.getClientArea().getCopy();
        clientArea.shrink(2, 2);
        Rectangle remainingSpace = clientArea.getCopy();
        List children = container.getChildren();
        Iterator childIt = children.iterator();
        while (childIt.hasNext()) {
            IFigure child = (IFigure)childIt.next();
            Dimension preferredSize = child.getPreferredSize();
            Rectangle childBounds = remainingSpace.getCopy();
            if (childIt.hasNext()) {
                childBounds.setHeight(preferredSize.height);
                remainingSpace.translate(0, childBounds.height);
                remainingSpace.setHeight(remainingSpace.height - childBounds.height);
            }
            child.setBounds(childBounds);
        }
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension preferredSize = new Dimension();
        List children = container.getChildren();
        for (IFigure child : children) {
            Dimension childSize = child.getPreferredSize(wHint, hHint);
            preferredSize.width = Math.max(childSize.width, preferredSize.width);
            preferredSize.height += childSize.height;
        }
        Insets insets = container.getInsets();
        preferredSize.expand(insets.getWidth(), insets.getHeight());
        return preferredSize.union(this.getBorderPreferredSize(container));
    }
}

