/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.modelevolution.multiview.CombinedFragment;
import org.modelevolution.multiview.Condition;
import org.modelevolution.multiview.Event;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.LifelineElement;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultipleOperandCF;
import org.modelevolution.multiview.OneOperandCF;
import org.modelevolution.multiview.Operand;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.diagram.edit.parts.ConflictEditPart;
import org.modelevolution.multiview.diagram.edit.parts.MultipleOperandCFEditPart;
import org.modelevolution.multiview.diagram.edit.parts.OneOperandCFEditPart;
import org.modelevolution.multiview.diagram.edit.parts.ReceiveEventEditPart;
import org.modelevolution.multiview.diagram.edit.parts.SendEventEditPart;
import org.modelevolution.multiview.diagram.edit.parts.SequenceView2EditPart;
import org.modelevolution.multiview.diagram.edit.parts.StateConditionEditPart;
import org.modelevolution.multiview.diagram.layout.LayoutIndexDescriptor;
import org.modelevolution.multiview.diagram.util.MultiviewModelUtil;

public class SequenceViewLayout
extends StackLayout {
    private List<GraphicalEditPart> lifelineElements = new ArrayList<GraphicalEditPart>();
    private List<LayoutIndexDescriptor> visibleLifelineElements = new ArrayList<LayoutIndexDescriptor>();
    private List<GraphicalEditPart> combinedFragments = new ArrayList<GraphicalEditPart>();
    private SequenceView seqView = null;
    private List<ConflictFragment> conflictFragments = new LinkedList<ConflictFragment>();

    public void layout(IFigure parent) {
        GraphicalEditPart ep;
        super.layout(parent);
        System.out.println("\n#### SequenceViewLayout.layout() ###");
        int lastY = 20;
        ListIterator<LayoutIndexDescriptor> visibleLifelineElementsIt = this.visibleLifelineElements.listIterator();
        while (visibleLifelineElementsIt.hasNext()) {
            LayoutIndexDescriptor indexDescriptor = visibleLifelineElementsIt.next();
            int maxY = lastY;
            while (indexDescriptor.hasNext()) {
                ep = indexDescriptor.next();
                if (ep instanceof StateConditionEditPart || ep instanceof SendEventEditPart || ep instanceof ReceiveEventEditPart) {
                    IFigure figure = ep.getFigure();
                    if (figure.getParent() == null) continue;
                    ((GraphicalEditPart)ep.getParent()).getFigure().getBounds().getSize();
                    Rectangle constraint = figure.getParent().getBounds().getCopy();
                    Point origin = constraint.getTopLeft();
                    lastY = Math.max(lastY, origin.y);
                    Dimension preferredSize = figure.getPreferredSize();
                    constraint.setX(constraint.getTop().x - preferredSize.width / 2);
                    constraint.setY(lastY);
                    constraint.setSize(preferredSize);
                    figure.setBounds(constraint);
                    maxY = Math.max(maxY, constraint.getBottom().y);
                    continue;
                }
                if (!(ep instanceof ConflictEditPart)) continue;
                ((ConflictEditPart)ep).layout(lastY);
                maxY = Math.max(maxY, ep.getFigure().getClientArea().bottom());
            }
            indexDescriptor.resetIterator();
            lastY = maxY + 20;
        }
        ListIterator<GraphicalEditPart> combinedFragmentsIt = this.combinedFragments.listIterator();
        ArrayList<Rectangle> operandsBounds = new ArrayList<Rectangle>();
        while (combinedFragmentsIt.hasNext()) {
            ep = combinedFragmentsIt.next();
            CombinedFragment combinedFragment = (CombinedFragment)ep.resolveSemanticElement();
            ArrayList<Operand> operands = new ArrayList<Operand>();
            if (combinedFragment instanceof OneOperandCF) {
                Operand operand = ((OneOperandCF)combinedFragment).getOperand();
                if (operand != null) {
                    operands.add(operand);
                }
            } else if (combinedFragment instanceof MultipleOperandCF) {
                operands.addAll((Collection<Operand>)((MultipleOperandCF)combinedFragment).getOperands());
            }
            if (operands.isEmpty()) {
                Figure fragmentFigure = (Figure)ep.getFigure();
                Rectangle fragmentBounds = fragmentFigure.getBounds().getCopy();
                Dimension preferredSize = fragmentFigure.getPreferredSize();
                if (fragmentBounds.height >= preferredSize.height && fragmentBounds.width >= preferredSize.width) continue;
                fragmentBounds.setSize(preferredSize);
                fragmentFigure.setBounds(fragmentBounds);
                continue;
            }
            SequenceView2EditPart seqViewEP = (SequenceView2EditPart)ep.getParent().getParent();
            Point fragmentTopLeftCorner = null;
            Point fragmentBottomRightCorner = null;
            Point operandTopLeftCorner = null;
            Point operandBottomRightCorner = null;
            ListIterator operandsIt = operands.listIterator();
            int operandIndex = 0;
            while (operandsIt.hasNext()) {
                operandTopLeftCorner = null;
                operandBottomRightCorner = null;
                Operand operand = (Operand)operandsIt.next();
                GraphicalEditPart operandEditPart = (GraphicalEditPart)seqViewEP.findEditPart((EditPart)seqViewEP, (EObject)operand);
                EList coveredElements = operand.getCovers();
                if (coveredElements.isEmpty()) {
                    Rectangle parentClientArea = ((ShapeCompartmentEditPart)operandEditPart.getParent()).getShapeCompartmentFigure().getScrollPane().getClientArea();
                    Rectangle operandBounds = new Rectangle();
                    int height = parentClientArea.height / operands.size();
                    operandBounds.setLocation(0, operandIndex * height);
                    operandBounds.setSize(parentClientArea.width, height);
                    operandEditPart.getFigure().setMinimumSize(new Dimension(0, 0));
                    operandEditPart.getFigure().setBounds(operandBounds);
                    ++operandIndex;
                    continue;
                }
                ListIterator coveredElementsIt = coveredElements.listIterator();
                while (coveredElementsIt.hasNext()) {
                    LifelineElement lifelineElement = (LifelineElement)coveredElementsIt.next();
                    GraphicalEditPart editPart = (GraphicalEditPart)seqViewEP.findEditPart((EditPart)seqViewEP, (EObject)lifelineElement);
                    GraphicalEditPart lifelineEditPart = (GraphicalEditPart)editPart.getParent();
                    IFigure elementFigure = editPart.getFigure();
                    IFigure lifelineFigure = lifelineEditPart.getFigure();
                    Rectangle elementBounds = elementFigure.getBounds();
                    Point elementTopLeftCorner = elementBounds.getTopLeft().translate(lifelineFigure.getBounds().getTopLeft()).translate(0, 5);
                    elementTopLeftCorner.x = lifelineFigure.getBounds().getLeft().x;
                    Point elementBottomRightCorner = elementBounds.getBottomRight().translate(lifelineFigure.getBounds().getTopLeft()).translate(0, 5);
                    elementBottomRightCorner.x = lifelineFigure.getBounds().getRight().x;
                    if (operandTopLeftCorner == null) {
                        operandTopLeftCorner = elementTopLeftCorner;
                    } else {
                        if (operandTopLeftCorner.x > elementTopLeftCorner.x) {
                            operandTopLeftCorner.x = elementTopLeftCorner.x;
                        }
                        if (operandTopLeftCorner.y > elementTopLeftCorner.y) {
                            operandTopLeftCorner.y = elementTopLeftCorner.y;
                        }
                    }
                    if (operandBottomRightCorner == null) {
                        operandBottomRightCorner = elementBottomRightCorner;
                        continue;
                    }
                    if (operandBottomRightCorner.x < elementBottomRightCorner.x) {
                        operandBottomRightCorner.x = elementBottomRightCorner.x;
                    }
                    if (operandBottomRightCorner.y >= elementBottomRightCorner.y) continue;
                    operandBottomRightCorner.y = elementBottomRightCorner.y;
                }
                if (operandTopLeftCorner != null && operandBottomRightCorner != null) {
                    operandsBounds.add(new Rectangle(operandTopLeftCorner, operandBottomRightCorner));
                    if (fragmentTopLeftCorner == null) {
                        fragmentTopLeftCorner = operandTopLeftCorner;
                    } else {
                        if (fragmentTopLeftCorner.x > operandTopLeftCorner.x) {
                            fragmentTopLeftCorner.x = operandTopLeftCorner.x;
                        }
                        if (fragmentTopLeftCorner.y > operandTopLeftCorner.y) {
                            fragmentTopLeftCorner.y = operandTopLeftCorner.y;
                        }
                    }
                    if (fragmentBottomRightCorner == null) {
                        fragmentBottomRightCorner = operandBottomRightCorner;
                    } else {
                        if (fragmentBottomRightCorner.x < operandBottomRightCorner.x) {
                            fragmentBottomRightCorner.x = operandBottomRightCorner.x;
                        }
                        if (fragmentBottomRightCorner.y < operandBottomRightCorner.y) {
                            fragmentBottomRightCorner.y = operandBottomRightCorner.y;
                        }
                    }
                }
                ++operandIndex;
            }
            if (fragmentTopLeftCorner == null || fragmentBottomRightCorner == null) continue;
            IFigure fragmentFigure = ep.getFigure();
            ShapeCompartmentFigure compartmentFigure = ((ShapeCompartmentEditPart)ep.getChildren().get(0)).getShapeCompartmentFigure();
            Insets insets = ((IFigure)fragmentFigure.getChildren().get(0)).getBorder().getInsets(fragmentFigure);
            insets = insets.getAdded(compartmentFigure.getScrollPane().getInsets());
            Rectangle fragmentBounds = new Rectangle(fragmentTopLeftCorner.getTranslated(insets.left * -1, insets.top * -1), fragmentBottomRightCorner.getTranslated(insets.right, insets.bottom));
            ep.getFigure().getParent().getLayoutManager().setConstraint(ep.getFigure(), (Object)fragmentBounds);
            ep.getFigure().setBounds(fragmentBounds);
            System.out.println(String.valueOf(ep.getClass().toString()) + " : " + fragmentBounds.toString());
            operandsIt = operands.listIterator();
            ListIterator operandsBoundsIt = operandsBounds.listIterator();
            while (operandsIt.hasNext()) {
                Operand operand = (Operand)operandsIt.next();
                Rectangle bounds = (Rectangle)operandsBoundsIt.next();
                GraphicalEditPart operandEditPart = (GraphicalEditPart)seqViewEP.findEditPart((EditPart)seqViewEP, (EObject)operand);
                bounds.setWidth(fragmentBottomRightCorner.x - fragmentTopLeftCorner.x);
                bounds.setLocation(bounds.getLocation().getTranslated(fragmentTopLeftCorner.getNegated()));
                IFigure operandFigure = operandEditPart.getFigure();
                operandFigure.getParent().getLayoutManager().setConstraint(operandFigure, (Object)bounds);
                operandFigure.setBounds(bounds);
                System.out.println("Operand : " + bounds.toString());
            }
            operandsBounds.clear();
        }
    }

    public void reorderLifelineElements() {
        this.hideAllElements();
        if (this.seqView != null) {
            this.visibleLifelineElements.clear();
            this.insertFirstElements(this.seqView, this.visibleLifelineElements);
            ConflictFragment currentFragment = this.getConlictFragmentForStartMessage(null);
            if (currentFragment != null) {
                LayoutIndexDescriptor descriptor = new LayoutIndexDescriptor();
                GraphicalEditPart ep = this.getLifelineElementByModel((EObject)currentFragment);
                this.setVisibility(ep, true);
                descriptor.add(ep);
                this.visibleLifelineElements.add(descriptor);
            }
            EList messagesList = this.seqView.getOrderedMessages();
            ListIterator orderedMessages = messagesList.listIterator();
            while (orderedMessages.hasNext()) {
                Message lastOriginMessage;
                Message message = (Message)orderedMessages.next();
                if (currentFragment != null && (lastOriginMessage = currentFragment.getLastOrigin()) != null && MultiviewModelUtil.equals(message, lastOriginMessage, true, false)) {
                    currentFragment = null;
                }
                if (currentFragment == null) {
                    GraphicalEditPart ep;
                    LayoutIndexDescriptor descriptor;
                    SendEvent sender = message.getSender();
                    ReceiveEvent receiver = message.getReceiver();
                    if (sender.getLifeline() == receiver.getLifeline()) {
                        descriptor = new LayoutIndexDescriptor();
                        ep = this.getLifelineElementByModel((EObject)sender);
                        this.setVisibility(ep, true);
                        descriptor.add(ep);
                        this.visibleLifelineElements.add(descriptor);
                        descriptor = new LayoutIndexDescriptor();
                        ep = this.getLifelineElementByModel((EObject)receiver);
                        this.setVisibility(ep, true);
                        descriptor.add(ep);
                        this.visibleLifelineElements.add(descriptor);
                    } else {
                        descriptor = new LayoutIndexDescriptor();
                        ep = this.getLifelineElementByModel((EObject)sender);
                        this.setVisibility(ep, true);
                        descriptor.add(ep);
                        ep = this.getLifelineElementByModel((EObject)receiver);
                        this.setVisibility(ep, true);
                        descriptor.add(ep);
                        this.visibleLifelineElements.add(descriptor);
                    }
                    this.insertFollowingElements((Event)sender, this.visibleLifelineElements);
                    this.insertFollowingElements((Event)receiver, this.visibleLifelineElements);
                }
                if (currentFragment != null || (currentFragment = this.getConlictFragmentForStartMessage(message)) == null) continue;
                LayoutIndexDescriptor descriptor = new LayoutIndexDescriptor();
                GraphicalEditPart ep = this.getLifelineElementByModel((EObject)currentFragment);
                this.setVisibility(ep, true);
                descriptor.add(ep);
                this.visibleLifelineElements.add(descriptor);
            }
        }
    }

    private ConflictFragment getConlictFragmentForStartMessage(Message message) {
        ListIterator<ConflictFragment> conflictFragmentsIt = this.conflictFragments.listIterator();
        while (conflictFragmentsIt.hasNext()) {
            ConflictFragment conflictFragment = conflictFragmentsIt.next();
            Message originMessage = conflictFragment.getLastOrigin();
            if (originMessage == null) {
                return conflictFragment;
            }
            if (message == null || !MultiviewModelUtil.equals(message, originMessage, true, false)) continue;
            return conflictFragment;
        }
        return null;
    }

    private void insertFirstElements(SequenceView seqView, List<LayoutIndexDescriptor> visibleLifelineElements) {
        ListIterator lifelineIt = seqView.getLifelines().listIterator();
        block0: while (lifelineIt.hasNext()) {
            Lifeline lifeline = (Lifeline)lifelineIt.next();
            ListIterator lifelineElementsIt = lifeline.getElements().listIterator();
            while (lifelineElementsIt.hasNext()) {
                LifelineElement lifelineElement = (LifelineElement)lifelineElementsIt.next();
                if (!(lifelineElement instanceof Condition)) continue block0;
                LayoutIndexDescriptor descriptor = new LayoutIndexDescriptor();
                GraphicalEditPart ep = this.getLifelineElementByModel((EObject)lifelineElement);
                this.setVisibility(ep, true);
                descriptor.add(ep);
                visibleLifelineElements.add(descriptor);
            }
        }
    }

    private void insertFollowingElements(Event sender, List<LayoutIndexDescriptor> visibleLifelineElements) {
        EList lifelineElements = sender.getLifeline().getElements();
        ListIterator lifelineElementsIt = lifelineElements.listIterator(lifelineElements.indexOf(sender) + 1);
        while (lifelineElementsIt.hasNext()) {
            LifelineElement lifelineElement = (LifelineElement)lifelineElementsIt.next();
            if (!(lifelineElement instanceof Condition)) break;
            LayoutIndexDescriptor descriptor = new LayoutIndexDescriptor();
            GraphicalEditPart ep = this.getLifelineElementByModel((EObject)lifelineElement);
            this.setVisibility(ep, true);
            descriptor.add(ep);
            visibleLifelineElements.add(descriptor);
        }
    }

    private void hideAllElements() {
        ListIterator<GraphicalEditPart> lifelineElementsIt = this.lifelineElements.listIterator();
        while (lifelineElementsIt.hasNext()) {
            GraphicalEditPart graphicalEditPart = lifelineElementsIt.next();
            this.setVisibility(graphicalEditPart, false);
        }
    }

    private void setVisibility(GraphicalEditPart graphicalEditPart, boolean visibility) {
        if (graphicalEditPart != null) {
            graphicalEditPart.getFigure().setVisible(visibility);
            ListIterator sourceConnectionsIt = graphicalEditPart.getSourceConnections().listIterator();
            while (sourceConnectionsIt.hasNext()) {
                Object sourceConnectionEditPart = sourceConnectionsIt.next();
                if (!(sourceConnectionEditPart instanceof ConnectionEditPart)) continue;
                this.setVisibility((ConnectionEditPart)sourceConnectionEditPart, visibility);
            }
            ListIterator targetConnectionsIt = graphicalEditPart.getTargetConnections().listIterator();
            while (targetConnectionsIt.hasNext()) {
                Object targetConnectionEditPart = targetConnectionsIt.next();
                if (!(targetConnectionEditPart instanceof ConnectionEditPart)) continue;
                this.setVisibility((ConnectionEditPart)targetConnectionEditPart, visibility);
            }
        }
    }

    private void setVisibility(ConnectionEditPart graphicalEditPart, boolean visibility) {
        if (graphicalEditPart != null) {
            graphicalEditPart.getFigure().setVisible(visibility);
        }
    }

    private GraphicalEditPart getLifelineElementByModel(EObject element) {
        GraphicalEditPart editPart = null;
        ListIterator<GraphicalEditPart> elementIt = this.lifelineElements.listIterator();
        while (elementIt.hasNext()) {
            GraphicalEditPart graphicalEditPart = elementIt.next();
            if (!graphicalEditPart.resolveSemanticElement().equals(element)) continue;
            editPart = graphicalEditPart;
            break;
        }
        return editPart;
    }

    public void addConflictFragment(ConflictFragment fragment) {
        this.conflictFragments.add(fragment);
        this.reorderLifelineElements();
    }

    public void removeConflictFragment(ConflictFragment fragment) {
        this.conflictFragments.remove(fragment);
        this.reorderLifelineElements();
    }

    public void clearConflictFragments() {
        this.conflictFragments.clear();
        this.reorderLifelineElements();
    }

    public void addLifelineElementEditPart(GraphicalEditPart ep) {
        if (ep instanceof OneOperandCFEditPart || ep instanceof MultipleOperandCFEditPart) {
            this.combinedFragments.add(ep);
        } else {
            this.lifelineElements.add(ep);
        }
        this.reorderLifelineElements();
    }

    public void removeLifelineElement(GraphicalEditPart ep) {
        if (ep instanceof OneOperandCFEditPart || ep instanceof MultipleOperandCFEditPart) {
            this.combinedFragments.remove(ep);
        } else {
            this.lifelineElements.remove(ep);
        }
        this.reorderLifelineElements();
    }

    public void clearLifelineElements() {
        this.lifelineElements.clear();
        this.combinedFragments.clear();
        this.reorderLifelineElements();
    }

    public SequenceView getSeqView() {
        return this.seqView;
    }

    public void setSeqView(SequenceView seqView) {
        this.seqView = seqView;
    }
}

