/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.layout.util;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.ui.PlatformUI;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramEditor;

public class MultiviewLayoutDebugUtil {
    public static String getFigureTree() {
        IDiagramGraphicalViewer diagram = ((MultiviewDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getDiagramGraphicalViewer();
        RenderedDiagramRootEditPart rootEditPart = (RenderedDiagramRootEditPart)diagram.getRootEditPart();
        IFigure rootFigure = rootEditPart.getFigure();
        return MultiviewLayoutDebugUtil.getFigureAndChildrenDescription(rootFigure, 0);
    }

    public static String getFigureAndChildrenDescription(IFigure figure, int level) {
        StringBuffer descriptions = new StringBuffer();
        StringBuffer indent = new StringBuffer();
        int i = 0;
        while (i < level) {
            indent.append("    ");
            ++i;
        }
        IFigure parentFigure = figure;
        descriptions.append(indent);
        descriptions.append("==== Figure Start ====\n");
        descriptions.append(MultiviewLayoutDebugUtil.getFigureDescription(parentFigure, indent.toString()));
        descriptions.append("\n");
        for (Object child : parentFigure.getChildren()) {
            descriptions.append(MultiviewLayoutDebugUtil.getFigureAndChildrenDescription((IFigure)child, level + 1));
        }
        descriptions.append(indent);
        descriptions.append("==== Figure End ====\n\n");
        return descriptions.toString();
    }

    public static String getFigureDescription(IFigure figure, String prefix) {
        StringBuffer description = new StringBuffer();
        description.append(prefix);
        description.append("Figure: ");
        description.append(figure.getClass().getName());
        description.append('@');
        description.append(Integer.toHexString(figure.hashCode()));
        description.append("\n");
        description.append(prefix);
        description.append("Bounds: ");
        description.append(figure.getBounds().toString());
        description.append("\n");
        description.append(prefix);
        description.append("ClientArea: ");
        description.append(figure.getClientArea().toString());
        description.append("\n");
        return description.toString();
    }
}

