/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.parsers;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.diagram.edit.parts.MessageEditPart;
import org.modelevolution.multiview.diagram.edit.parts.WrappingLabel2EditPart;
import org.modelevolution.multiview.diagram.util.MultiviewDiagramUtil;
import org.modelevolution.multiview.diagram.util.MultiviewModelUtil;

public class MessageLabelExpressionLabelParser
implements IParser {
    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, final String newString, int flags) {
        final EObject target = (EObject)element.getAdapter(EObject.class);
        if (!this.validateValues(target, newString)) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)target);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        IFile affectedFile = WorkspaceSynchronizer.getFile((Resource)target.eResource());
        return new AbstractTransactionalCommand(editingDomain, "Set Values", affectedFile == null ? null : Collections.singletonList(affectedFile)){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return new CommandResult(MessageLabelExpressionLabelParser.this.updateValues(target, newString));
            }
        };
    }

    public String getPrintString(IAdaptable element, int flags) {
        Symbol body;
        EObject obj;
        if (element instanceof EObjectAdapter && (obj = (EObject)((EObjectAdapter)element).getRealObject()) instanceof Message && (body = ((Message)obj).getBody()) != null && body.getName() != null) {
            return body.getName();
        }
        return "<specify Symbol>";
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    private boolean validateValues(EObject target, String newString) {
        return true;
    }

    private IStatus updateValues(EObject target, String newString) throws ExecutionException {
        Message message = (Message)target;
        Symbol body = message.getBody();
        body = MultiviewFactory.eINSTANCE.createSymbol();
        body.setName(newString);
        StateView stateview = ((MultiviewModel)message.getSequenceView().eContainer()).getStateview();
        Symbol existingSymbol = MultiviewModelUtil.findEqualSymbol(stateview, body);
        if (existingSymbol == null) {
            EList alphabet = stateview.getAlphabet();
            alphabet.add(body);
        } else {
            body = existingSymbol;
        }
        message.setBody(body);
        MessageEditPart editpart = (MessageEditPart)MultiviewDiagramUtil.findAllEditPartByModel(target);
        if (editpart != null) {
            ((WrappingLabel2EditPart)((Object)editpart.getChildren().get(0))).refresh();
        }
        return new Status(0, "org.modelevolution.multiview.diagram", "");
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }
}

