/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.diagram.expressions.MultiviewOCLFactory;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramEditorPlugin;

public class MultiviewVisualIDRegistry {
    private static final String DEBUG_KEY = "org.modelevolution.multiview.diagram/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return MultiviewVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return MultiviewVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return MultiviewVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return MultiviewVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return MultiviewVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return MultiviewVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Multiview".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return MultiviewVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                MultiviewDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (MultiviewPackage.eINSTANCE.getMultiviewModel().isSuperTypeOf(domainElement.eClass()) && MultiviewVisualIDRegistry.isDiagram((MultiviewModel)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = MultiviewVisualIDRegistry.getModelID(containerView);
        if (!"Multiview".equals(containerModelID)) {
            return -1;
        }
        if ("Multiview".equals(containerModelID)) {
            containerVisualID = MultiviewVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (MultiviewPackage.eINSTANCE.getSequenceView().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (!MultiviewPackage.eINSTANCE.getStateView().isSuperTypeOf(domainElement.eClass())) break;
                return 2009;
            }
            case 7002: {
                if (MultiviewPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (MultiviewPackage.eINSTANCE.getOneOperandCF().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (!MultiviewPackage.eINSTANCE.getMultipleOperandCF().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7005: {
                if (MultiviewPackage.eINSTANCE.getReceiveEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (MultiviewPackage.eINSTANCE.getSendEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (!MultiviewPackage.eINSTANCE.getStateCondition().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7007: {
                if (!MultiviewPackage.eINSTANCE.getOperand().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7006: {
                if (!MultiviewPackage.eINSTANCE.getOperand().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7003: {
                if (!MultiviewPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7004: {
                if (MultiviewPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && MultiviewVisualIDRegistry.isState_3001((State)domainElement)) {
                    return 3001;
                }
                if (!MultiviewPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) || !MultiviewVisualIDRegistry.isState_3012((State)domainElement)) break;
                return 3012;
            }
            case 7009: {
                if (!MultiviewPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7010: {
                if (MultiviewPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && MultiviewVisualIDRegistry.isState_3001((State)domainElement)) {
                    return 3001;
                }
                if (!MultiviewPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) || !MultiviewVisualIDRegistry.isState_3012((State)domainElement)) break;
                return 3012;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = MultiviewVisualIDRegistry.getModelID(containerView);
        if (!"Multiview".equals(containerModelID)) {
            return false;
        }
        if ("Multiview".equals(containerModelID)) {
            containerVisualID = MultiviewVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2009 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3003: {
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5005 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (7010 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6002 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6003 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (MultiviewPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (MultiviewPackage.eINSTANCE.getTransition().isSuperTypeOf(domainElement.eClass()) && MultiviewVisualIDRegistry.isTransition_4004((Transition)domainElement)) {
            return 4004;
        }
        if (MultiviewPackage.eINSTANCE.getTransition().isSuperTypeOf(domainElement.eClass()) && MultiviewVisualIDRegistry.isTransition_4005((Transition)domainElement)) {
            return 4005;
        }
        return -1;
    }

    private static boolean isDiagram(MultiviewModel element) {
        return true;
    }

    private static boolean isState_3001(State domainElement) {
        Object result = MultiviewOCLFactory.getExpression(0, (EClassifier)MultiviewPackage.eINSTANCE.getState(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isState_3012(State domainElement) {
        Object result = MultiviewOCLFactory.getExpression(1, (EClassifier)MultiviewPackage.eINSTANCE.getState(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isTransition_4004(Transition domainElement) {
        Object result = MultiviewOCLFactory.getExpression(2, (EClassifier)MultiviewPackage.eINSTANCE.getTransition(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isTransition_4005(Transition domainElement) {
        Object result = MultiviewOCLFactory.getExpression(3, (EClassifier)MultiviewPackage.eINSTANCE.getTransition(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = MultiviewVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: 
            case 7009: 
            case 7010: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 3001: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: {
                return true;
            }
        }
        return false;
    }
}

