/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.diagram.edit.policies.MultiviewBaseItemSemanticEditPolicy;

public class MessageCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;
    private final SequenceView container;
    private Lifeline sourceLifeline;
    private Lifeline targetLifeline;

    public MessageCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        if (source instanceof Lifeline) {
            this.sourceLifeline = (Lifeline)source;
            this.source = MultiviewFactory.eINSTANCE.createSendEvent();
        } else {
            this.source = source;
        }
        if (target instanceof Lifeline) {
            this.targetLifeline = (Lifeline)target;
            this.target = MultiviewFactory.eINSTANCE.createReceiveEvent();
        } else {
            this.target = target;
        }
        this.container = MessageCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof SendEvent)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof ReceiveEvent)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return MultiviewBaseItemSemanticEditPolicy.getLinkConstraints().canCreateMessage_4001(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Message newElement = MultiviewFactory.eINSTANCE.createMessage();
        this.getContainer().getMessages().add((Object)newElement);
        SendEvent sendEvent = this.getSource();
        ReceiveEvent receiveEvent = this.getTarget();
        if (this.sourceLifeline != null) {
            this.sourceLifeline.getElements().add((Object)sendEvent);
        }
        if (this.targetLifeline != null) {
            this.targetLifeline.getElements().add((Object)receiveEvent);
        }
        newElement.setSender(sendEvent);
        newElement.setReceiver(receiveEvent);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(Message newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected SendEvent getSource() {
        return (SendEvent)this.source;
    }

    protected ReceiveEvent getTarget() {
        return (ReceiveEvent)this.target;
    }

    public SequenceView getContainer() {
        return this.container;
    }

    private static SequenceView deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof SequenceView) {
                return (SequenceView)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

