/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.diagram.edit.policies.MultiviewBaseItemSemanticEditPolicy;

public class Transition2ReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public Transition2ReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Transition)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Region) || !(this.newEnd instanceof Region)) {
            return false;
        }
        State target = this.getLink().getTarget();
        return MultiviewBaseItemSemanticEditPolicy.getLinkConstraints().canExistTransition_4005(this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof State) || !(this.newEnd instanceof State)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Region)) {
            return false;
        }
        Region source = (Region)this.getLink().eContainer();
        return MultiviewBaseItemSemanticEditPolicy.getLinkConstraints().canExistTransition_4005(this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().setInitialTransition(null);
        this.getNewSource().setInitialTransition(this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Transition getLink() {
        return (Transition)this.getElementToEdit();
    }

    protected Region getOldSource() {
        return (Region)this.oldEnd;
    }

    protected Region getNewSource() {
        return (Region)this.newEnd;
    }

    protected State getOldTarget() {
        return (State)this.oldEnd;
    }

    protected State getNewTarget() {
        return (State)this.newEnd;
    }
}

