/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.expressions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.modelevolution.multiview.diagram.expressions.MultiviewAbstractExpression;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramEditorPlugin;

public class MultiviewOCLFactory {
    private final MultiviewAbstractExpression[] expressions = new MultiviewAbstractExpression[4];
    private final String[] expressionBodies = new String[]{"self.subregion->isEmpty()", "self.subregion->notEmpty()", "self.source->notEmpty()", "self.source->isEmpty()"};

    protected MultiviewOCLFactory() {
    }

    private static MultiviewOCLFactory getInstance() {
        MultiviewOCLFactory instance = MultiviewDiagramEditorPlugin.getInstance().getMultiviewOCLFactory();
        if (instance == null) {
            instance = new MultiviewOCLFactory();
            MultiviewDiagramEditorPlugin.getInstance().setMultiviewOCLFactory(instance);
        }
        return instance;
    }

    public static String getExpressionBody(int index) {
        return MultiviewOCLFactory.getInstance().expressionBodies[index];
    }

    public static MultiviewAbstractExpression getExpression(int index, EClassifier context, Map<String, EClassifier> environment) {
        MultiviewOCLFactory cached = MultiviewOCLFactory.getInstance();
        if (index < 0 || index >= cached.expressions.length) {
            throw new IllegalArgumentException();
        }
        if (cached.expressions[index] == null) {
            cached.expressions[index] = MultiviewOCLFactory.getExpression(cached.expressionBodies[index], context, environment == null ? Collections.emptyMap() : environment);
        }
        return cached.expressions[index];
    }

    public static MultiviewAbstractExpression getExpression(String body, EClassifier context, Map<String, EClassifier> environment) {
        return new Expression(body, context, environment);
    }

    public static MultiviewAbstractExpression getExpression(String body, EClassifier context) {
        return MultiviewOCLFactory.getExpression(body, context, Collections.<String, EClassifier>emptyMap());
    }

    private static class Expression
    extends MultiviewAbstractExpression {
        private final OCL oclInstance = OCL.newInstance();
        private org.eclipse.ocl.ecore.OCLExpression oclExpression;

        public Expression(String body, EClassifier context, Map<String, EClassifier> environment) {
            super(body, context);
            Expression.initCustomEnv(this.oclInstance.getEnvironment(), environment);
            OCL.Helper oclHelper = this.oclInstance.createOCLHelper();
            oclHelper.setContext((Object)this.context());
            try {
                this.oclExpression = oclHelper.createQuery(this.body());
                this.setStatus(0, null, null);
            }
            catch (ParserException e) {
                this.setStatus(4, e.getMessage(), e);
            }
        }

        @Override
        protected Object doEvaluate(Object context, Map env) {
            if (this.oclExpression == null) {
                return null;
            }
            EvaluationEnvironment evalEnv = this.oclInstance.getEvaluationEnvironment();
            for (Object nextKey : env.keySet()) {
                evalEnv.replace((String)nextKey, env.get(nextKey));
            }
            try {
                Object result = this.oclInstance.evaluate(context, (OCLExpression)this.oclExpression);
                Object object = this.oclInstance.isInvalid(result) ? null : result;
                return object;
            }
            finally {
                evalEnv.clear();
                this.oclInstance.setExtentMap(null);
            }
        }

        private static void initCustomEnv(Environment<?, EClassifier, ?, ?, ?, EParameter, ?, ?, ?, ?, ?, ?> ecoreEnv, Map<String, EClassifier> environment) {
            ParsingOptions.setOption(ecoreEnv, (Option)ParsingOptions.implicitRootClass(ecoreEnv), (Object)EcorePackage.eINSTANCE.getEObject());
            for (String varName : environment.keySet()) {
                EClassifier varType = environment.get(varName);
                ecoreEnv.addElement(varName, (org.eclipse.ocl.expressions.Variable)Expression.createVar(ecoreEnv, varName, varType), false);
            }
        }

        private static Variable createVar(Environment<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> ecoreEnv, String name, EClassifier type) {
            Variable var = EcoreFactory.eINSTANCE.createVariable();
            var.setName(name);
            var.setType((Object)((EClassifier)ecoreEnv.getUMLReflection().getOCLType((Object)type)));
            return var;
        }
    }
}

