/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.figures;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.modelevolution.multiview.diagram.figures.ConflictMessageFigure;
import org.modelevolution.multiview.diagram.figures.IMoveableLifelineConflictFigure;

public class ConflictFigure
extends Figure
implements IMoveableLifelineConflictFigure {
    public static final int SPACING = 20;
    public static final int CHILD_SPACING = 35;
    public static final RGB OUTLINE_COLOR = new RGB(0, 0, 0);
    public static final RGB DIALOG_BACKGROUND_COLOR = new RGB(255, 255, 255);
    public static final float LINE_WIDTH = 1.0f;
    public static final int[] DASH_PATTERN = new int[]{10, 5};
    public static final int LEFT_TOP_PADDING = 20;
    public static final int LEFT_BOTTOM_PADDING = 20;
    public static final int RIGHT_TOP_PADDING = 20;
    public static final int RIGHT_BOTTOM_PADDING = 20;
    public static final float RELATION_LINE_WIDTH = 1.0f;
    public static final int COMMAND_BAR_HEIGHT = 20;
    private List<IFigure> leftChildren = new ArrayList<IFigure>();
    private List<IFigure> mergeChildren = new ArrayList<IFigure>();
    private List<IFigure> rightChildren = new ArrayList<IFigure>();
    private List<FigureRelationship> relationships;
    private List<Integer> horizontalLifelinePositions = new ArrayList<Integer>();
    private IFigure dialogFigure;
    private int numLifelines = 0;

    public ConflictFigure(int numLifelines) {
        this.numLifelines = numLifelines;
        int i = 0;
        while (i < numLifelines) {
            this.horizontalLifelinePositions.add(null);
            ++i;
        }
        this.relationships = new ArrayList<FigureRelationship>();
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle mergeAreaBounds = this.getBounds().getCopy();
        mergeAreaBounds.shrink(1, 1);
        int width = (mergeAreaBounds.width - 40) / 3;
        mergeAreaBounds.height = this.calculateChildAreaSize(this.mergeChildren).height + 1;
        graphics.pushState();
        graphics.setForegroundColor(new Color((Device)Display.getCurrent(), OUTLINE_COLOR));
        graphics.setLineWidthFloat(1.0f);
        mergeAreaBounds.width = width;
        mergeAreaBounds.translate(width + 20, 0);
        graphics.fillRectangle(mergeAreaBounds);
        graphics.drawRectangle(mergeAreaBounds);
        Rectangle leftAreaBounds = mergeAreaBounds.getTranslated((width + 20) * -1, 0);
        leftAreaBounds.height = this.calculateChildAreaSize(this.leftChildren).height() + 2 + 20 + 20;
        graphics.fillRectangle(leftAreaBounds);
        graphics.drawRectangle(leftAreaBounds);
        Rectangle rightAreaBounds = mergeAreaBounds.getTranslated(width + 20, 0);
        rightAreaBounds.height = this.calculateChildAreaSize(this.rightChildren).height() + 2 + 20 + 20;
        graphics.fillRectangle(rightAreaBounds);
        graphics.drawRectangle(rightAreaBounds);
        graphics.drawLine(mergeAreaBounds.getTopLeft(), leftAreaBounds.getTopRight());
        graphics.drawLine(mergeAreaBounds.getBottomLeft(), leftAreaBounds.getBottomRight());
        graphics.drawLine(mergeAreaBounds.getTopRight(), rightAreaBounds.getTopLeft());
        graphics.drawLine(mergeAreaBounds.getBottomRight(), rightAreaBounds.getBottomLeft());
        Point referencePoint = leftAreaBounds.getLocation().getTranslated(0, 20);
        graphics.translate(referencePoint);
        this.paintChildrenList(graphics, this.leftChildren);
        graphics.translate(referencePoint.getNegated());
        referencePoint = rightAreaBounds.getLocation().getTranslated(0, 20);
        graphics.translate(referencePoint);
        this.paintChildrenList(graphics, this.rightChildren);
        graphics.translate(referencePoint.getNegated());
        graphics.translate(mergeAreaBounds.getLocation());
        this.paintChildrenList(graphics, this.mergeChildren);
        graphics.translate(mergeAreaBounds.getLocation().getNegated());
        this.drawLifelines(graphics, rightAreaBounds, this.numLifelines, 15, 15, true);
        this.drawLifelines(graphics, mergeAreaBounds, this.numLifelines, 0, 0, false);
        this.drawLifelines(graphics, leftAreaBounds, this.numLifelines, 15, 15, true);
        Point relationMergePoint = new Point();
        Point relationSecondPoint = new Point();
        ListIterator<FigureRelationship> relationshipIt = this.relationships.listIterator();
        FigureRelationship prevRelation = null;
        FigureRelationship relation = null;
        FigureRelationship nextRelation = relationshipIt.hasNext() ? relationshipIt.next() : null;
        while (nextRelation != null) {
            prevRelation = relation;
            relation = nextRelation;
            boolean isCurrentRelationshipLeft = relation.isLeftRelationship();
            nextRelation = relationshipIt.hasNext() ? relationshipIt.next() : null;
            graphics.pushState();
            graphics.setLineWidthFloat(1.0f);
            ConflictMessageFigure mergeFigure = (ConflictMessageFigure)relation.getMergedFigure();
            ConflictMessageFigure relatedFigure = (ConflictMessageFigure)relation.getRelatedFigure();
            graphics.setForegroundColor(new Color((Device)Display.getCurrent(), ConflictMessageFigure.getMessageTypeBackgroundRGB(mergeFigure.getMessageType())));
            if (relation.isLeftRelationship()) {
                relationMergePoint.setLocation(mergeAreaBounds.getTopLeft());
                relationMergePoint.translate(-1, 0);
                relationSecondPoint.setLocation(leftAreaBounds.getTopRight());
                relationSecondPoint.translate(1, 20);
            } else {
                relationMergePoint.setLocation(mergeAreaBounds.getTopRight());
                relationMergePoint.translate(1, 0);
                relationSecondPoint.setLocation(rightAreaBounds.getTopLeft());
                relationSecondPoint.translate(-1, 20);
            }
            Rectangle mergeFigureBounds = mergeFigure.getBounds();
            Rectangle relatedFigureBounds = relatedFigure.getBounds();
            relationMergePoint.translate(0, mergeFigureBounds.y);
            relationSecondPoint.translate(0, relatedFigureBounds.y);
            if (prevRelation == null || prevRelation.isLeftRelationship() != isCurrentRelationshipLeft) {
                graphics.drawLine(relationMergePoint, relationSecondPoint);
            }
            relationMergePoint.translate(0, mergeFigureBounds.height);
            relationSecondPoint.translate(0, relatedFigureBounds.height);
            if (nextRelation == null || nextRelation.isLeftRelationship() != isCurrentRelationshipLeft) {
                graphics.drawLine(relationMergePoint, relationSecondPoint);
            }
            graphics.popState();
        }
        if (this.dialogFigure != null) {
            Point dialogPosition = this.getClientArea().getBottom();
            Point dialogContentPosition = this.getClientArea().getBottom();
            Dimension dialogSize = this.dialogFigure.getPreferredSize();
            dialogPosition.translate(dialogSize.width / -2, 0);
            dialogContentPosition.translate(dialogSize.width / -2 + 10, 10);
            dialogSize.expand(20, 20);
            Rectangle dialogArea = new Rectangle(dialogPosition, dialogSize);
            graphics.pushState();
            graphics.setBackgroundColor(new Color((Device)Display.getCurrent(), DIALOG_BACKGROUND_COLOR));
            graphics.fillRectangle(dialogArea);
            graphics.popState();
            graphics.drawRectangle(dialogArea);
            graphics.translate(dialogContentPosition);
            this.dialogFigure.paint(graphics);
            graphics.translate(dialogPosition.getNegated());
        }
        graphics.popState();
    }

    protected void paintChildren(Graphics graphics) {
        List<IFigure> children = this.getButtonBarFigures();
        IClippingStrategy clippingStrategy = this.getClippingStrategy();
        int i = 0;
        while (i < children.size()) {
            IFigure child = children.get(i);
            if (child.isVisible()) {
                Rectangle[] clipping = null;
                clipping = clippingStrategy != null ? clippingStrategy.getClip(child) : new Rectangle[]{child.getBounds()};
                int j = 0;
                while (j < clipping.length) {
                    if (clipping[j].intersects(graphics.getClip(Rectangle.SINGLETON))) {
                        graphics.clipRect(clipping[j]);
                        child.paint(graphics);
                        graphics.restoreState();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void drawLifelines(Graphics graphics, Rectangle bounds, int numLifelines, int paddingTop, int paddingBottom, boolean drawEndPoints) {
        int lifelineWidth = bounds.width / numLifelines;
        Point topLeft = bounds.getTopLeft();
        Point bottomLeft = bounds.getBottomLeft();
        Point topPoint = bounds.getTopLeft().translate(0, paddingTop);
        Point bottomPoint = bounds.getBottomLeft().translate(0, -paddingBottom);
        int i = 0;
        while (i < numLifelines) {
            Integer value;
            int xOffset = 0;
            xOffset = i < this.horizontalLifelinePositions.size() ? ((value = this.horizontalLifelinePositions.get(i)) == null ? i * lifelineWidth + lifelineWidth / 2 : value) : i * lifelineWidth + lifelineWidth / 2;
            topPoint.setX(topLeft.x + xOffset);
            bottomPoint.setX(bottomLeft.x + xOffset);
            graphics.setLineStyle(2);
            graphics.setLineDash(DASH_PATTERN);
            graphics.drawLine(topPoint, bottomPoint);
            if (drawEndPoints) {
                graphics.setLineStyle(1);
                Point topEndPoint = topPoint.getTranslated(4, -5);
                Point bottomEndPoint = topPoint.getTranslated(-4, 5);
                graphics.drawLine(topEndPoint, bottomEndPoint);
                topEndPoint.translate(0, -4);
                bottomEndPoint.translate(0, -4);
                graphics.drawLine(topEndPoint, bottomEndPoint);
                topEndPoint = bottomPoint.getTranslated(4, -5);
                bottomEndPoint = bottomPoint.getTranslated(-4, 5);
                graphics.drawLine(topEndPoint, bottomEndPoint);
                topEndPoint.translate(0, 4);
                bottomEndPoint.translate(0, 4);
                graphics.drawLine(topEndPoint, bottomEndPoint);
            }
            ++i;
        }
    }

    private void paintChildrenList(Graphics graphics, List<IFigure> children) {
        for (IFigure child : children) {
            child.paint(graphics);
        }
    }

    public int getMergeAreaWidth() {
        return (this.getBounds().width - 40) / 3;
    }

    private Dimension calculateChildAreaSize(List<IFigure> childList) {
        Dimension childAreaSize = new Dimension();
        if (childList.isEmpty()) {
            childAreaSize.height = 10;
            childAreaSize.width = 10;
        } else {
            ListIterator<IFigure> childIt = childList.listIterator();
            while (childIt.hasNext()) {
                IFigure child = childIt.next();
                Dimension childSize = child.getSize();
                childAreaSize.height += childSize.height;
                if (childSize.width <= childAreaSize.width) continue;
                childAreaSize.width = childSize.width;
            }
        }
        return childAreaSize;
    }

    @Override
    public void setHorizontalLifelinePosition(int lifeline, int position) {
        this.horizontalLifelinePositions.set(lifeline, new Integer(position));
    }

    @Override
    public Integer getHorizontalLifelinePosition(int lifeline) {
        return this.horizontalLifelinePositions.get(lifeline);
    }

    public void addLeftChild(IFigure figure) {
        figure.setParent((IFigure)this);
        this.leftChildren.add(figure);
    }

    public void removeLeftChild(IFigure figure) {
        figure.setParent(null);
        this.leftChildren.remove(figure);
        this.remove(figure);
    }

    public void addMergeChild(IFigure figure, IFigure relatedFigure) {
        figure.setParent((IFigure)this);
        this.mergeChildren.add(figure);
        if (relatedFigure != null) {
            if (this.relationships == null) {
                this.relationships = new ArrayList<FigureRelationship>();
            }
            boolean isLeftRelationship = false;
            if (this.leftChildren.contains(relatedFigure)) {
                isLeftRelationship = true;
            } else if (this.rightChildren.contains(relatedFigure)) {
                isLeftRelationship = false;
            } else {
                throw new IllegalArgumentException("Related figure is not left or right child");
            }
            this.relationships.add(new FigureRelationship(figure, relatedFigure, isLeftRelationship));
        }
    }

    public void removeMergeChild(IFigure figure) {
        figure.setParent(null);
        this.mergeChildren.remove(figure);
        this.remove(figure);
    }

    public void addRightChild(IFigure figure) {
        figure.setParent((IFigure)this);
        this.rightChildren.add(figure);
    }

    public void removeRightChild(IFigure figure) {
        figure.setParent(null);
        this.rightChildren.remove(figure);
        this.remove(figure);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension mergeChildrenDimension = this.calculateChildAreaSize(this.mergeChildren);
        Dimension leftChildrenDimension = this.calculateChildAreaSize(this.leftChildren).expand(0, 40);
        Dimension rightChildrenDimension = this.calculateChildAreaSize(this.rightChildren).expand(0, 40);
        mergeChildrenDimension.expand(0, 22);
        Dimension preferredSize = new Dimension();
        preferredSize.setHeight(Math.max(Math.max(leftChildrenDimension.height, leftChildrenDimension.height), mergeChildrenDimension.height));
        preferredSize.setWidth(mergeChildrenDimension.width + leftChildrenDimension.width + rightChildrenDimension.width + 40);
        return preferredSize;
    }

    public Rectangle getClientArea(Rectangle rect) {
        Dimension mergeChildrenDimension = this.calculateChildAreaSize(this.mergeChildren);
        rect.width = 0;
        ListIterator<IFigure> buttonBarFigureIt = this.getButtonBarFigures().listIterator();
        while (buttonBarFigureIt.hasNext()) {
            rect.width += buttonBarFigureIt.next().getBounds().width + 2;
        }
        rect.setHeight(20);
        rect.setLocation(this.getBounds().getTop().translate(rect.width / 2 * -1, mergeChildrenDimension.height + 2 + 1));
        return rect;
    }

    public List<IFigure> getMergeChildren() {
        return this.mergeChildren;
    }

    public List<IFigure> getLeftChildren() {
        return this.leftChildren;
    }

    public List<IFigure> getRightChildren() {
        return this.rightChildren;
    }

    public IFigure getDialogFigure() {
        return this.dialogFigure;
    }

    public List<IFigure> getButtonBarFigures() {
        ArrayList<IFigure> buttonBarFigures = new ArrayList<IFigure>(this.getChildren());
        ListIterator figureIt = buttonBarFigures.listIterator();
        while (figureIt.hasNext()) {
            IFigure child = (IFigure)figureIt.next();
            if (!this.leftChildren.contains(child) && !this.mergeChildren.contains(child) && !this.rightChildren.contains(child) && this.dialogFigure != child) continue;
            figureIt.remove();
        }
        return buttonBarFigures;
    }

    public void setDialogFigure(IFigure dialogFigure) {
        if (this.dialogFigure != null) {
            this.remove(this.dialogFigure);
        }
        if (dialogFigure != null) {
            this.add(dialogFigure);
        }
        this.dialogFigure = dialogFigure;
    }

    public void clearConflictFigures() {
        this.leftChildren.clear();
        this.rightChildren.clear();
        this.mergeChildren.clear();
        this.relationships.clear();
    }

    private class FigureRelationship {
        private IFigure mergedFigure;
        private IFigure relatedFigure;
        private boolean isLeftRelationship;

        public FigureRelationship(IFigure mergedFigure, IFigure referencedFigure, boolean isLeftRelationship) {
            this.mergedFigure = mergedFigure;
            this.relatedFigure = referencedFigure;
            this.isLeftRelationship = isLeftRelationship;
        }

        public IFigure getMergedFigure() {
            return this.mergedFigure;
        }

        public void setMergedFigure(IFigure mergedFigure) {
            this.mergedFigure = mergedFigure;
        }

        public IFigure getRelatedFigure() {
            return this.relatedFigure;
        }

        public void setRelatedFigure(IFigure referencedFigure) {
            this.relatedFigure = referencedFigure;
        }

        public boolean isLeftRelationship() {
            return this.isLeftRelationship;
        }

        public void setLeftRelationship(boolean isLeftRelationship) {
            this.isLeftRelationship = isLeftRelationship;
        }
    }
}

