/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.figures;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.modelevolution.multiview.diagram.figures.ConflictMessageType;
import org.modelevolution.multiview.diagram.figures.IMoveableLifelineConflictFigure;

public class ConflictMessageFigure
extends Figure {
    public static final RGB LEFT_ADDED_MESSAGE_COLOR = new RGB(143, 255, 195);
    public static final RGB LEFT_UPDATED_MESSAGE_COLOR = new RGB(253, 255, 180);
    public static final RGB RIGHT_ADDED_MESSAGE_COLOR = new RGB(148, 203, 255);
    public static final RGB RIGHT_UPDATED_MESSAGE_COLOR = new RGB(253, 255, 180);
    public static final RGB DELETED_MESSAGE_COLOR = new RGB(230, 230, 230);
    public static final int TEXT_PADDING = 5;
    private static final Map<ConflictMessageType, RGB> colorMap = new HashMap<ConflictMessageType, RGB>();
    private int fromLifeline = 0;
    private int toLifeline = 0;
    private int numLifelines = 0;
    private ConflictMessageType messageType;
    private String message = "";
    private boolean fillOnlyMessageBackground = false;
    private boolean textVisible = true;

    public ConflictMessageFigure(int numLifelines, int fromLifeline, int toLifeline, ConflictMessageType messageType, String message) {
        this.numLifelines = numLifelines;
        this.fromLifeline = fromLifeline;
        this.toLifeline = toLifeline;
        this.messageType = messageType;
        this.message = message;
    }

    public ConflictMessageFigure(int numLifelines, int fromLifeline, int toLifeline, ConflictMessageType messageType, String message, boolean fillOnlyMessageBackground) {
        this.numLifelines = numLifelines;
        this.fromLifeline = fromLifeline;
        this.toLifeline = toLifeline;
        this.messageType = messageType;
        this.message = message;
        this.fillOnlyMessageBackground = fillOnlyMessageBackground;
    }

    protected void paintFigure(Graphics graphics) {
        int receiverOffset;
        int senderOffset;
        IMoveableLifelineConflictFigure parent = null;
        if (this.getParent() instanceof IMoveableLifelineConflictFigure) {
            parent = (IMoveableLifelineConflictFigure)this.getParent();
        }
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        int lifelineWidth = bounds.width / this.numLifelines;
        graphics.setBackgroundColor(new Color((Device)Display.getCurrent(), ConflictMessageFigure.getMessageTypeBackgroundRGB(this.messageType)));
        if (!this.fillOnlyMessageBackground) {
            graphics.fillRectangle(bounds);
        }
        Point sendPoint = null;
        Point receivePoint = null;
        if (this.fromLifeline != this.toLifeline) {
            senderOffset = 0;
            receiverOffset = 0;
            Integer senderPos = null;
            Integer receiverPos = null;
            if (parent != null) {
                senderPos = parent.getHorizontalLifelinePosition(this.fromLifeline);
                receiverPos = parent.getHorizontalLifelinePosition(this.toLifeline);
            }
            senderOffset = senderPos != null ? senderPos : this.fromLifeline * lifelineWidth + lifelineWidth / 2;
            receiverOffset = receiverPos != null ? receiverPos : this.toLifeline * lifelineWidth + lifelineWidth / 2;
            sendPoint = bounds.getLeft().translate(senderOffset, 0);
            receivePoint = bounds.getLeft().translate(receiverOffset - 1, 0);
            if (this.fillOnlyMessageBackground) {
                Point topLeftBackground = null;
                Point bottomRightBackground = null;
                if (this.messageType == ConflictMessageType.RIGHT_ADDED || this.messageType == ConflictMessageType.RIGHT_UPDATED) {
                    topLeftBackground = sendPoint.x < receivePoint.x ? bounds.getTopLeft().setX(sendPoint.x) : bounds.getTopLeft().setX(receivePoint.x);
                    bottomRightBackground = bounds.getBottomRight().translate(-1, -1);
                } else if (this.messageType == ConflictMessageType.LEFT_ADDED || this.messageType == ConflictMessageType.LEFT_UPDATED) {
                    topLeftBackground = bounds.getTopLeft();
                    bottomRightBackground = sendPoint.x < receivePoint.x ? bounds.getBottomRight().setX(receivePoint.x).translate(0, -1) : bounds.getBottomRight().setX(sendPoint.x).translate(0, -1);
                } else {
                    topLeftBackground = bounds.getTopLeft().setX(sendPoint.x);
                    bottomRightBackground = bounds.getBottomRight().setX(receivePoint.x).translate(0, -1);
                }
                Rectangle backgroundToFill = new Rectangle(topLeftBackground, bottomRightBackground);
                graphics.fillRectangle(backgroundToFill);
            }
            graphics.drawLine(sendPoint, receivePoint);
            if (this.textVisible) {
                Point textReferencePoint = null;
                textReferencePoint = sendPoint.x < receivePoint.x ? sendPoint.getCopy() : receivePoint.getCopy();
                Dimension textExtents = FigureUtilities.getStringExtents((String)this.message, (Font)graphics.getFont());
                int distance = Math.abs(sendPoint.x - receivePoint.x);
                textReferencePoint.translate(distance / 2 - textExtents.width / 2, 0);
                if (distance > textExtents.width) {
                    graphics.drawText(this.message, textReferencePoint);
                }
            }
        } else {
            senderOffset = 0;
            receiverOffset = 0;
            Integer senderPos = null;
            Integer receiverPos = null;
            if (parent != null) {
                senderPos = parent.getHorizontalLifelinePosition(this.fromLifeline);
                receiverPos = parent.getHorizontalLifelinePosition(this.toLifeline);
            }
            senderOffset = senderPos != null ? senderPos : this.fromLifeline * lifelineWidth + lifelineWidth / 2;
            receiverOffset = receiverPos != null ? receiverPos : this.toLifeline * lifelineWidth + lifelineWidth / 2;
            sendPoint = bounds.getTopLeft().translate(senderOffset - 1, 10);
            receivePoint = bounds.getBottomLeft().translate(receiverOffset - 1, -10);
            Dimension textExtents = FigureUtilities.getStringExtents((String)this.message, (Font)graphics.getFont());
            Point textReferencePoint = sendPoint.getTranslated(-20 - textExtents.width - 5, 0);
            if (textReferencePoint.x <= 0) {
                textReferencePoint = sendPoint.getTranslated(2, 0);
            }
            if (this.fillOnlyMessageBackground) {
                Point topLeftBackground = null;
                Point bottomRightBackground = null;
                if (this.messageType == ConflictMessageType.RIGHT_ADDED || this.messageType == ConflictMessageType.RIGHT_UPDATED) {
                    topLeftBackground = bounds.getTopLeft().setX(sendPoint.x - 25);
                    topLeftBackground.x = Math.min(topLeftBackground.x, textReferencePoint.x - 5);
                    bottomRightBackground = bounds.getBottomRight().translate(-1, -1);
                } else if (this.messageType == ConflictMessageType.LEFT_ADDED || this.messageType == ConflictMessageType.LEFT_UPDATED) {
                    topLeftBackground = bounds.getTopLeft().translate(1, 0);
                    bottomRightBackground = bounds.getBottomRight().setX(receiverOffset);
                    bottomRightBackground.x = Math.max(bottomRightBackground.x, textReferencePoint.x + textExtents.width + 5);
                } else {
                    topLeftBackground = bounds.getTopLeft().setX(Math.max(this.fromLifeline * lifelineWidth - lifelineWidth / 2, 1));
                    bottomRightBackground = bounds.getBottomRight().setX(this.toLifeline * lifelineWidth + lifelineWidth / 2);
                }
                Rectangle backgroundToFill = new Rectangle(topLeftBackground, bottomRightBackground);
                graphics.fillRectangle(backgroundToFill);
            }
            graphics.drawLine(sendPoint, sendPoint.getTranslated(-20, 0));
            graphics.drawLine(sendPoint.getTranslated(-20, 0), receivePoint.getTranslated(-20, 0));
            graphics.drawLine(receivePoint.getTranslated(-20, 0), receivePoint);
            if (this.textVisible) {
                graphics.drawText(this.message, textReferencePoint);
            }
        }
        int translationXOffset = 8;
        int translationYOffset = 3;
        if (sendPoint.x <= receivePoint.x) {
            translationXOffset *= -1;
        }
        graphics.drawLine(receivePoint, receivePoint.getTranslated(translationXOffset, translationYOffset));
        graphics.drawLine(receivePoint, receivePoint.getTranslated(translationXOffset, translationYOffset * -1));
        graphics.popState();
    }

    private static void initColorMap() {
        colorMap.put(ConflictMessageType.LEFT_ADDED, LEFT_ADDED_MESSAGE_COLOR);
        colorMap.put(ConflictMessageType.RIGHT_ADDED, RIGHT_ADDED_MESSAGE_COLOR);
        colorMap.put(ConflictMessageType.LEFT_UPDATED, LEFT_UPDATED_MESSAGE_COLOR);
        colorMap.put(ConflictMessageType.RIGHT_UPDATED, RIGHT_UPDATED_MESSAGE_COLOR);
        colorMap.put(ConflictMessageType.DELETED, DELETED_MESSAGE_COLOR);
    }

    public static RGB getMessageTypeBackgroundRGB(ConflictMessageType messageType) {
        RGB rgb;
        if (colorMap.isEmpty()) {
            ConflictMessageFigure.initColorMap();
        }
        if ((rgb = colorMap.get((Object)messageType)) == null) {
            rgb = new RGB(255, 255, 255);
        }
        return rgb;
    }

    public void setFillOnlyMessageBackground(boolean fillOnlyMessageBackground) {
        this.fillOnlyMessageBackground = fillOnlyMessageBackground;
    }

    public boolean isFillOnlyMessageBackground() {
        return this.fillOnlyMessageBackground;
    }

    public ConflictMessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(ConflictMessageType messageType) {
        this.messageType = messageType;
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }
}

