/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.LifelineElement;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.Operand;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.MergeOption;
import org.modelevolution.multiview.diagram.requests.AcceptMergeOptionRequest;
import org.modelevolution.multiview.diagram.util.MultiviewModelUtil;

public class AcceptMergeOptionCommand
extends EditElementCommand {
    private MultiviewModel model = null;
    private MergeOption mergeOption = null;

    public AcceptMergeOptionCommand(AcceptMergeOptionRequest request) {
        super("", (EObject)request.getModel(), (IEditCommandRequest)request);
        this.mergeOption = request.getMergeOption();
        this.model = request.getModel();
    }

    public boolean canExecute() {
        return this.model != null && this.mergeOption != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Message tmpMessage;
        this.mergeOption.getLeftAddedMessages();
        this.mergeOption.getLeftDeletedMessages();
        this.mergeOption.getLeftUpdatedMessages();
        this.mergeOption.getRightAddedMessages();
        this.mergeOption.getRightDeletedMessages();
        this.mergeOption.getRightUpdatedMessages();
        SequenceView seqView = this.model.getSequenceview();
        StateView stateView = this.model.getStateview();
        EList currentMessages = seqView.getOrderedMessages();
        EList mergedMessages = this.mergeOption.getMessages();
        ConflictFragment fragment = this.mergeOption.getConflictFragment();
        Message lastOriginMessage = fragment.getLastOrigin();
        Message nextOriginMessage = fragment.getNextOrigin();
        HashMap<Lifeline, Integer> lastIndexPerLifeline = new HashMap<Lifeline, Integer>();
        ListIterator currentMessagesIt = currentMessages.listIterator();
        ArrayList<Message> messagesToRemove = new ArrayList<Message>();
        if (lastOriginMessage != null) {
            while (currentMessagesIt.hasNext()) {
                tmpMessage = (Message)currentMessagesIt.next();
                SendEvent tmpSender = tmpMessage.getSender();
                lastIndexPerLifeline.put(tmpSender.getLifeline(), tmpSender.getLifeline().getElements().indexOf((Object)tmpSender));
                ReceiveEvent tmpReceiver = tmpMessage.getReceiver();
                lastIndexPerLifeline.put(tmpReceiver.getLifeline(), tmpReceiver.getLifeline().getElements().indexOf((Object)tmpReceiver));
                if (MultiviewModelUtil.equals(tmpMessage, lastOriginMessage, true, false)) break;
            }
        }
        while (currentMessagesIt.hasNext()) {
            tmpMessage = (Message)currentMessagesIt.next();
            if (nextOriginMessage != null && MultiviewModelUtil.equals(tmpMessage, nextOriginMessage, true, false)) break;
            messagesToRemove.add(tmpMessage);
        }
        ListIterator messagesToRemoveIt = messagesToRemove.listIterator();
        while (messagesToRemoveIt.hasNext()) {
            Operand tmpOperand;
            Message tmpMessage2 = (Message)messagesToRemoveIt.next();
            SendEvent sender = tmpMessage2.getSender();
            ReceiveEvent receiver = tmpMessage2.getReceiver();
            ListIterator<Operand> senderContainingOperandsIt = MultiviewModelUtil.findContainingOperands(seqView, (LifelineElement)sender).listIterator();
            ListIterator<Operand> receiverContainingOperandsIt = MultiviewModelUtil.findContainingOperands(seqView, (LifelineElement)receiver).listIterator();
            while (senderContainingOperandsIt.hasNext()) {
                tmpOperand = senderContainingOperandsIt.next();
                tmpOperand.getCovers().remove((Object)sender);
            }
            while (receiverContainingOperandsIt.hasNext()) {
                tmpOperand = receiverContainingOperandsIt.next();
                tmpOperand.getCovers().remove((Object)receiver);
            }
            sender.getLifeline().getElements().remove((Object)sender);
            receiver.getLifeline().getElements().remove((Object)receiver);
            currentMessages.remove(tmpMessage2);
        }
        ListIterator mergedMessagesIt = mergedMessages.listIterator();
        while (mergedMessagesIt.hasNext()) {
            Message tmpMessage3 = (Message)mergedMessagesIt.next();
            SendEvent tmpSender = tmpMessage3.getSender();
            ReceiveEvent tmpReceiver = tmpMessage3.getReceiver();
            Symbol tmpBody = tmpMessage3.getBody();
            Lifeline tmpSenderLifeline = tmpSender.getLifeline();
            Lifeline tmpReceiverLifeline = tmpReceiver.getLifeline();
            Message newMessage = MultiviewFactory.eINSTANCE.createMessage();
            SendEvent newSender = MultiviewFactory.eINSTANCE.createSendEvent();
            ReceiveEvent newReceiver = MultiviewFactory.eINSTANCE.createReceiveEvent();
            Symbol body = null;
            Lifeline newSenderLifeline = null;
            Lifeline newReceiverLifeline = null;
            newSenderLifeline = MultiviewModelUtil.findEqualLifeline(seqView, tmpSenderLifeline, false);
            if (newSenderLifeline == null) {
                return CommandResult.newErrorCommandResult((String)("Could not copy message, model data may be corrupted. ( sender lifeline \"" + tmpSenderLifeline.getName() + "\" not found)"));
            }
            int index = 0;
            Integer lastIndex = (Integer)lastIndexPerLifeline.get(newSenderLifeline);
            if (lastIndex != null) {
                index = lastIndex + 1;
            }
            newSenderLifeline.getElements().add(index, (Object)newSender);
            lastIndexPerLifeline.put(newSenderLifeline, new Integer(index));
            newSender.setName(tmpSender.getName());
            newSender.setTime(tmpSender.getTime());
            newReceiverLifeline = MultiviewModelUtil.findEqualLifeline(seqView, tmpReceiverLifeline, false);
            if (newReceiverLifeline == null) {
                return CommandResult.newErrorCommandResult((String)("Could not copy message, model data may be corrupted. ( receiver lifeline \"" + tmpReceiverLifeline.getName() + "\" not found)"));
            }
            index = 0;
            lastIndex = (Integer)lastIndexPerLifeline.get(newReceiverLifeline);
            if (lastIndex != null) {
                index = lastIndex + 1;
            }
            newReceiverLifeline.getElements().add(index, (Object)newReceiver);
            lastIndexPerLifeline.put(newReceiverLifeline, new Integer(index));
            newReceiver.setName(tmpReceiver.getName());
            newReceiver.setTime(tmpReceiver.getTime());
            if (tmpBody != null && (body = MultiviewModelUtil.findEqualSymbol(stateView, tmpBody)) == null) {
                return CommandResult.newErrorCommandResult((String)("Could not copy message, model data may be corrupted. (Symbol \"" + tmpBody + "\" not found)"));
            }
            newMessage.setBody(body);
            newMessage.setSender(newSender);
            newMessage.setReceiver(newReceiver);
            seqView.getMessages().add((Object)newMessage);
        }
        return CommandResult.newOKCommandResult();
    }
}

