/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.ConflictReport;
import org.modelevolution.multiview.diagram.edit.parts.ConflictEditPart;
import org.modelevolution.multiview.diagram.edit.parts.MessageEditPart;
import org.modelevolution.multiview.diagram.edit.parts.MultiviewEditPart;
import org.modelevolution.multiview.diagram.edit.parts.SequenceViewSequenceViewCompartmentEditPart;
import org.modelevolution.multiview.diagram.edit.parts.StateViewEditPart;
import org.modelevolution.multiview.diagram.edit.policies.SequenceView2ItemSemanticEditPolicy;
import org.modelevolution.multiview.diagram.figures.border.CombinedFragmentBorder;
import org.modelevolution.multiview.diagram.layout.AbstractLayoutListener;
import org.modelevolution.multiview.diagram.layout.SequenceViewLayout;
import org.modelevolution.multiview.diagram.util.MultiviewDiagramUtil;

public class SequenceView2EditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 2008;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private ConflictReport conflictReport;
    private List<ConflictEditPart> conflictEditParts = null;
    private SequenceViewLayout layout = new SequenceViewLayout();

    public SequenceView2EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SequenceView2ItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new SubCanvasFigure();
        return this.primaryShape;
    }

    public SubCanvasFigure getPrimaryShape() {
        return (SubCanvasFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        this.layout.setSeqView((SequenceView)this.resolveSemanticElement());
        figure.setLayoutManager((LayoutManager)this.layout);
        figure.addLayoutListener((LayoutListener)new AbstractLayoutListener(){

            @Override
            public boolean layout(IFigure container) {
                return false;
            }

            @Override
            public void postLayout(IFigure container) {
                EditPart multiviewRoot = (EditPart)SequenceView2EditPart.this.getRoot().getChildren().get(0);
                List<EditPart> messageEditParts = MultiviewDiagramUtil.findEditPartsByClass(multiviewRoot, MessageEditPart.class);
                StateViewEditPart stateViewEditPart = (StateViewEditPart)MultiviewDiagramUtil.findFirstEditPartByClass(multiviewRoot, StateViewEditPart.class);
                IFigure stateViewFigure = stateViewEditPart.getFigure();
                for (EditPart part : messageEditParts) {
                    MessageEditPart messageEditPart = (MessageEditPart)part;
                    IFigure messageFigure = messageEditPart.getFigure();
                    if (messageFigure.intersects(stateViewFigure.getBounds()) && stateViewFigure.isVisible()) {
                        if (!messageFigure.isVisible()) continue;
                        ((GraphicalEditPart)messageEditPart.getSource()).getFigure().setVisible(false);
                        ((GraphicalEditPart)messageEditPart.getSource()).getFigure().repaint();
                        ((GraphicalEditPart)messageEditPart.getTarget()).getFigure().setVisible(false);
                        ((GraphicalEditPart)messageEditPart.getTarget()).getFigure().repaint();
                        messageFigure.setVisible(false);
                        messageFigure.repaint();
                        continue;
                    }
                    if (messageFigure.isVisible()) continue;
                    ((GraphicalEditPart)messageEditPart.getSource()).getFigure().setVisible(true);
                    ((GraphicalEditPart)messageEditPart.getSource()).getFigure().repaint();
                    ((GraphicalEditPart)messageEditPart.getTarget()).getFigure().setVisible(true);
                    ((GraphicalEditPart)messageEditPart.getTarget()).getFigure().repaint();
                    messageFigure.setVisible(true);
                    messageFigure.repaint();
                }
            }
        });
        EditPart parent = this.getParent();
        if (parent instanceof MultiviewEditPart) {
            MultiviewEditPart diagram = (MultiviewEditPart)parent;
            diagram.getContentPane().getLayoutManager();
        }
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public ConflictReport getConflictReport() {
        return this.conflictReport;
    }

    public void setConflictReport(ConflictReport conflictReport) {
        this.conflictEditParts = null;
        this.conflictReport = conflictReport;
    }

    public SequenceViewLayout getLayout() {
        return this.layout;
    }

    public void showConflictReport() {
        if (this.conflictEditParts == null) {
            this.conflictEditParts = this.createConflictEditParts(this.conflictReport);
        }
        SequenceViewSequenceViewCompartmentEditPart compartment = this.getCompartment();
        IFigure contentPane = compartment.getContentPane();
        for (ConflictEditPart conflictEditPart : this.conflictEditParts) {
            this.layout.addConflictFragment(conflictEditPart.getFragment());
            this.layout.addLifelineElementEditPart(conflictEditPart);
            contentPane.add(conflictEditPart.getFigure());
        }
    }

    public void setConflictEditPartResolved(ConflictEditPart editPart) {
        this.conflictEditParts.remove((Object)editPart);
        SequenceViewSequenceViewCompartmentEditPart compartment = this.getCompartment();
        IFigure contentPane = compartment.getContentPane();
        contentPane.remove(editPart.getFigure());
        this.layout.removeConflictFragment(editPart.getFragment());
    }

    public void hideConflictReport() {
        SequenceViewSequenceViewCompartmentEditPart compartment = this.getCompartment();
        IFigure contentPane = compartment.getContentPane();
        for (ConflictEditPart conflictEditPart : this.conflictEditParts) {
            contentPane.remove(conflictEditPart.getFigure());
        }
        this.conflictEditParts = null;
    }

    public List<ConflictEditPart> createConflictEditParts(ConflictReport report) {
        ArrayList<ConflictEditPart> conflictEditParts = new ArrayList<ConflictEditPart>();
        for (ConflictFragment fragment : report.getConflicts()) {
            ConflictEditPart conflictEditPart = new ConflictEditPart(this, fragment, this.getEditingDomain(), this.getDiagramEditDomain());
            conflictEditParts.add(conflictEditPart);
        }
        return conflictEditParts;
    }

    public SequenceViewSequenceViewCompartmentEditPart getCompartment() {
        for (Object childObj : this.getChildren()) {
            if (!(childObj instanceof SequenceViewSequenceViewCompartmentEditPart)) continue;
            return (SequenceViewSequenceViewCompartmentEditPart)((Object)childObj);
        }
        return null;
    }

    public class SubCanvasFigure
    extends RectangleFigure {
        public SubCanvasFigure() {
            this.setBorder(this.createBorder());
        }

        private Border createBorder() {
            CombinedFragmentBorder border = new CombinedFragmentBorder();
            border.setLabel("sd");
            return border;
        }

        protected boolean useLocalCoordinates() {
            return true;
        }
    }
}

