/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramUpdater;
import org.modelevolution.multiview.diagram.part.MultiviewLinkDescriptor;
import org.modelevolution.multiview.diagram.part.MultiviewNodeDescriptor;
import org.modelevolution.multiview.diagram.part.MultiviewVisualIDRegistry;

public class MultiviewCanonicalEditPolicy
extends CanonicalEditPolicy {
    private Set<EStructuralFeature> myFeaturesToSynchronize;

    protected void refreshOnActivate() {
        List c = this.getHost().getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).activate();
            ++i;
        }
        super.refreshOnActivate();
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet<EStructuralFeature>();
            this.myFeaturesToSynchronize.add((EStructuralFeature)MultiviewPackage.eINSTANCE.getMultiviewModel_Sequenceview());
            this.myFeaturesToSynchronize.add((EStructuralFeature)MultiviewPackage.eINSTANCE.getMultiviewModel_Stateview());
        }
        return this.myFeaturesToSynchronize;
    }

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        List<MultiviewNodeDescriptor> childDescriptors = MultiviewDiagramUpdater.getMultiviewModel_1000SemanticChildren(viewObject);
        for (MultiviewNodeDescriptor d : childDescriptors) {
            result.add(d.getModelElement());
        }
        return result;
    }

    protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
        return this.isMyDiagramElement(view) && !semanticChildren.contains(view.getElement());
    }

    private boolean isMyDiagramElement(View view) {
        int visualID = MultiviewVisualIDRegistry.getVisualID(view);
        return visualID == 2008 || visualID == 2009;
    }

    protected void refreshSemantic() {
        if (this.resolveSemanticElement() == null) {
            return;
        }
        LinkedList<IAdaptable> createdViews = new LinkedList<IAdaptable>();
        List<MultiviewNodeDescriptor> childDescriptors = MultiviewDiagramUpdater.getMultiviewModel_1000SemanticChildren((View)this.getHost().getModel());
        LinkedList orphaned = new LinkedList();
        LinkedList<View> knownViewChildren = new LinkedList<View>();
        for (View v : this.getViewChildren()) {
            if (!this.isMyDiagramElement(v)) continue;
            knownViewChildren.add(v);
        }
        Iterator<MultiviewNodeDescriptor> descriptorsIterator = childDescriptors.iterator();
        while (descriptorsIterator.hasNext()) {
            MultiviewNodeDescriptor next = descriptorsIterator.next();
            String hint = MultiviewVisualIDRegistry.getType(next.getVisualID());
            LinkedList<View> perfectMatch = new LinkedList<View>();
            for (View childView : this.getViewChildren()) {
                EObject semanticElement = childView.getElement();
                if (!next.getModelElement().equals(semanticElement) || !hint.equals(childView.getType())) continue;
                perfectMatch.add(childView);
            }
            if (perfectMatch.size() <= 0) continue;
            descriptorsIterator.remove();
            knownViewChildren.remove(perfectMatch.getFirst());
        }
        orphaned.addAll(knownViewChildren);
        ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(childDescriptors.size());
        for (MultiviewNodeDescriptor next : childDescriptors) {
            String hint = MultiviewVisualIDRegistry.getType(next.getVisualID());
            CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(next.getModelElement(), hint);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, hint, -1, false, this.host().getDiagramPreferencesHint());
            viewDescriptors.add(descriptor);
        }
        boolean changed = this.deleteViews(orphaned.iterator());
        CreateViewRequest request = this.getCreateViewRequest(viewDescriptors);
        Command cmd = this.getCreateViewCommand((CreateRequest)request);
        if (cmd != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
            this.executeCommand(cmd);
            List nl = (List)request.getNewObject();
            createdViews.addAll(nl);
        }
        if (changed || createdViews.size() > 0) {
            this.postProcessRefreshSemantic(createdViews);
        }
        Collection<IAdaptable> createdConnectionViews = this.refreshConnections();
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Collection<IAdaptable> refreshConnections() {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<MultiviewLinkDescriptor> linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        block0: while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = MultiviewVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator<MultiviewLinkDescriptor> linkDescriptorsIterator = linkDescriptors.iterator();
            while (linkDescriptorsIterator.hasNext()) {
                MultiviewLinkDescriptor nextLinkDescriptor = linkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                linkDescriptorsIterator.remove();
                continue block0;
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection<MultiviewLinkDescriptor> collectAllLinks(View view, Map<EObject, View> domain2NotationMap) {
        if (!"Multiview".equals(MultiviewVisualIDRegistry.getModelID(view))) {
            return Collections.emptyList();
        }
        LinkedList<MultiviewLinkDescriptor> result = new LinkedList<MultiviewLinkDescriptor>();
        switch (MultiviewVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getMultiviewModel_1000ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getSequenceView_2008ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getStateView_2009ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getLifeline_3002ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getReceiveEvent_3006ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getSendEvent_3007ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getStateCondition_3008ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getOneOperandCF_3003ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getOperand_3010ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getMultipleOperandCF_3004ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getOperand_3009ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getRegion_3005ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getState_3001ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getState_3012ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getRegion_3011ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getMessage_4001ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getTransition_4004ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(MultiviewDiagramUpdater.getTransition_4005ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection<IAdaptable> createConnections(Collection<MultiviewLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (MultiviewLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(nextLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(nextLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), MultiviewVisualIDRegistry.getType(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Map<EObject, View> domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }
}

