/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.parts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.MergeOption;
import org.modelevolution.multiview.diagram.edit.commands.AcceptMergeOptionCommand;
import org.modelevolution.multiview.diagram.edit.parts.LifelineEditPart;
import org.modelevolution.multiview.diagram.edit.parts.LifelineLifelineCompartmentEditPart;
import org.modelevolution.multiview.diagram.edit.parts.MultiviewEditPart;
import org.modelevolution.multiview.diagram.edit.parts.SequenceView2EditPart;
import org.modelevolution.multiview.diagram.edit.parts.SequenceViewSequenceViewCompartmentEditPart;
import org.modelevolution.multiview.diagram.edit.parts.StateViewEditPart;
import org.modelevolution.multiview.diagram.figures.ButtonFigure;
import org.modelevolution.multiview.diagram.figures.ConflictFigure;
import org.modelevolution.multiview.diagram.figures.ConflictMergeOptionOverview;
import org.modelevolution.multiview.diagram.figures.ConflictMessageFigure;
import org.modelevolution.multiview.diagram.figures.ConflictMessageType;
import org.modelevolution.multiview.diagram.layout.AbstractLayoutListener;
import org.modelevolution.multiview.diagram.requests.AcceptMergeOptionRequest;
import org.modelevolution.multiview.diagram.util.MultiviewDiagramUtil;

public class ConflictEditPart
extends GraphicalEditPart {
    private static final int CHILD_HEIGHT = 35;
    private static final double MERGE_OPTION_OVERVIEW_SCALING_FACTOR = 0.8;
    private ConflictFragment fragment;
    private MergeOption currentMergeOption;
    private ConflictFigure conflictFigure;
    private ConflictMergeOptionOverview mergeOptionOverviewFigure;
    private Rectangle lastConstraint = new Rectangle();
    private SequenceView2EditPart seqViewEP;
    private List<LifelineEditPart> lifelineEPs;
    private boolean stateDialogVisible = false;
    private boolean mergeOptionOverviewVisible = false;
    private TransactionalEditingDomain editingDomain = null;
    private IDiagramEditDomain dEditDomain = null;

    public ConflictEditPart(SequenceView2EditPart editpart, ConflictFragment fragment, TransactionalEditingDomain editingDomain, IDiagramEditDomain dEditDomain) {
        super(null);
        this.fragment = fragment;
        this.seqViewEP = editpart;
        if (!fragment.getMergeOptions().isEmpty()) {
            this.currentMergeOption = (MergeOption)fragment.getMergeOptions().get(0);
        }
        this.editingDomain = editingDomain;
        this.dEditDomain = dEditDomain;
    }

    public EObject resolveSemanticElement() {
        return this.getFragment();
    }

    public IFigure getFigure() {
        if (this.conflictFigure == null) {
            this.conflictFigure = (ConflictFigure)this.createFigure();
        }
        return this.conflictFigure;
    }

    protected IFigure createFigure() {
        SequenceViewSequenceViewCompartmentEditPart compartment = (SequenceViewSequenceViewCompartmentEditPart)((Object)this.seqViewEP.getChildren().get(0));
        this.lifelineEPs = new ArrayList<LifelineEditPart>();
        ListIterator childIt = compartment.getChildren().listIterator();
        while (childIt.hasNext()) {
            Object editPart = childIt.next();
            if (!(editPart instanceof LifelineEditPart)) continue;
            this.lifelineEPs.add((LifelineEditPart)((Object)editPart));
        }
        this.figure = this.createConflictFigureForMergeOption(this.currentMergeOption);
        this.mergeOptionOverviewFigure = this.createMergeOptionOverviewFigure();
        return this.figure;
    }

    private ConflictMergeOptionOverview createMergeOptionOverviewFigure() {
        ConflictMergeOptionOverview figure = new ConflictMergeOptionOverview(this.lifelineEPs.size());
        HashMap<String, Integer> lifelineNameIndex = new HashMap<String, Integer>();
        ListIterator<LifelineEditPart> lifelineEPIt = this.lifelineEPs.listIterator();
        while (lifelineEPIt.hasNext()) {
            Integer index = new Integer(lifelineEPIt.nextIndex());
            LifelineEditPart editPart = lifelineEPIt.next();
            Lifeline lifeline = (Lifeline)editPart.resolveSemanticElement();
            lifelineNameIndex.put(lifeline.getName(), index);
        }
        int mergeOptionIndex = 0;
        for (MergeOption mergeOption : this.fragment.getMergeOptions()) {
            EList leftAddedMessages = mergeOption.getLeftAddedMessages();
            EList leftUpdatedMessages = mergeOption.getLeftUpdatedMessages();
            EList leftDeletedMessages = mergeOption.getLeftDeletedMessages();
            EList rightAddedMessages = mergeOption.getRightAddedMessages();
            EList rightUpdatedMessages = mergeOption.getRightUpdatedMessages();
            EList rightDeletedMessages = mergeOption.getRightDeletedMessages();
            EList mergedMessages = mergeOption.getMessages();
            ListIterator mergedMessagesIt = mergedMessages.listIterator();
            while (mergedMessagesIt.hasNext()) {
                Message message = (Message)mergedMessagesIt.next();
                int fromLifeline = 0;
                int toLifeline = 0;
                Integer fromLifelineIndex = (Integer)lifelineNameIndex.get(message.getSender().getLifeline().getName());
                Integer toLifelineIndex = (Integer)lifelineNameIndex.get(message.getReceiver().getLifeline().getName());
                if (fromLifelineIndex == null) continue;
                fromLifeline = fromLifelineIndex;
                if (toLifelineIndex == null) continue;
                toLifeline = toLifelineIndex;
                ConflictMessageType messageType = null;
                if (rightAddedMessages.contains((Object)message)) {
                    messageType = ConflictMessageType.RIGHT_ADDED;
                } else if (rightUpdatedMessages.contains((Object)message)) {
                    messageType = ConflictMessageType.RIGHT_UPDATED;
                } else if (rightDeletedMessages.contains((Object)message)) {
                    messageType = ConflictMessageType.DELETED;
                } else if (leftAddedMessages.contains((Object)message)) {
                    messageType = ConflictMessageType.LEFT_ADDED;
                } else if (leftUpdatedMessages.contains((Object)message)) {
                    messageType = ConflictMessageType.LEFT_UPDATED;
                } else {
                    if (!leftDeletedMessages.contains((Object)message)) continue;
                    messageType = ConflictMessageType.DELETED;
                }
                String name = message.getBody().getName();
                ConflictMessageFigure messageFigure = new ConflictMessageFigure(this.lifelineEPs.size(), fromLifeline, toLifeline, messageType, name == null ? "" : name, true);
                figure.addMergeOptionChild(mergeOptionIndex, (IFigure)messageFigure);
            }
            ++mergeOptionIndex;
        }
        return figure;
    }

    private ConflictFigure createConflictFigureForMergeOption(MergeOption mergeOption) {
        ConflictFigure figure = new ConflictFigure(this.lifelineEPs.size());
        figure.setBounds(new Rectangle(10, 10, 100, 100));
        figure.addLayoutListener(new AbstractLayoutListener(){

            @Override
            public boolean layout(IFigure container) {
                ConflictFigure conflictFigure = (ConflictFigure)container;
                ConflictEditPart.this.updateLifelinePositions(conflictFigure, (List<LifelineEditPart>)ConflictEditPart.this.lifelineEPs);
                ConflictEditPart.this.layoutChildList((List<IFigure>)conflictFigure.getLeftChildren(), conflictFigure);
                ConflictEditPart.this.layoutChildList((List<IFigure>)conflictFigure.getRightChildren(), conflictFigure);
                ConflictEditPart.this.layoutChildList((List<IFigure>)conflictFigure.getMergeChildren(), conflictFigure);
                ConflictEditPart.this.layoutCommandBar(conflictFigure);
                IFigure dialogFigure = conflictFigure.getDialogFigure();
                if (dialogFigure instanceof ConflictMergeOptionOverview) {
                    ConflictEditPart.this.layoutConlictMergeOptionOverview((ConflictMergeOptionOverview)dialogFigure, conflictFigure);
                    ConflictEditPart.this.updateLifelinePositions(ConflictEditPart.this.mergeOptionOverviewFigure, (List<LifelineEditPart>)ConflictEditPart.this.lifelineEPs);
                }
                return true;
            }
        });
        this.createChilds(figure, mergeOption);
        ButtonFigure applyButton = new ButtonFigure("Accept");
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MultiviewEditPart multiviewEditPart = MultiviewDiagramUtil.getMultiviewEditPart();
                EObject element = multiviewEditPart.resolveSemanticElement();
                if (element instanceof MultiviewModel) {
                    AcceptMergeOptionRequest request = new AcceptMergeOptionRequest(ConflictEditPart.this.editingDomain, ConflictEditPart.this.currentMergeOption, (MultiviewModel)element);
                    AcceptMergeOptionCommand acceptCommand = new AcceptMergeOptionCommand(request);
                    ConflictEditPart.this.dEditDomain.getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)acceptCommand));
                    if (acceptCommand.getCommandResult().getStatus().isOK()) {
                        ConflictEditPart.this.seqViewEP.setConflictEditPartResolved(ConflictEditPart.this);
                        MultiviewDiagramUtil.getMultiviewEditPart().addNotify();
                        ConflictEditPart.this.seqViewEP.getFigure().revalidate();
                    } else {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error during merge", (String)acceptCommand.getCommandResult().getStatus().getMessage());
                    }
                }
            }
        });
        figure.add((IFigure)applyButton);
        ButtonFigure stateButton = new ButtonFigure("State diagram", ButtonFigure.STYLE_TOGGLE);
        stateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                StateViewEditPart stateViewEditPart = MultiviewDiagramUtil.getStateViewEditPart();
                if (stateViewEditPart != null) {
                    ConflictEditPart.this.stateDialogVisible = !ConflictEditPart.this.stateDialogVisible;
                    stateViewEditPart.setVisible(ConflictEditPart.this.stateDialogVisible);
                    Point referencePoint = ConflictEditPart.this.conflictFigure.getClientArea().getBottom();
                    referencePoint.translate(ConflictEditPart.this.seqViewEP.getContentPane().getBounds().getLocation());
                    referencePoint.translate(((ConflictEditPart)ConflictEditPart.this).seqViewEP.getContentPane().getInsets().left, ((ConflictEditPart)ConflictEditPart.this).seqViewEP.getContentPane().getInsets().top + 6);
                    System.out.println("referencePoint: " + referencePoint);
                    Point absReferencePoint = ConflictEditPart.this.conflictFigure.getClientArea().getBottom();
                    ConflictEditPart.this.conflictFigure.translateToAbsolute((Translatable)absReferencePoint);
                    System.out.println("absReferencePoint: " + absReferencePoint);
                    stateViewEditPart.setCenteredTopLocation(referencePoint);
                    if (ConflictEditPart.this.stateDialogVisible) {
                        stateViewEditPart.highlightTransitions(ConflictEditPart.this.currentMergeOption);
                    } else {
                        stateViewEditPart.disableHighlights();
                    }
                }
            }
        });
        figure.add((IFigure)stateButton);
        ButtonFigure overviewButton = new ButtonFigure("solutions", ButtonFigure.STYLE_TOGGLE);
        overviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ConflictEditPart.this.mergeOptionOverviewFigure != null) {
                    ConflictEditPart.this.mergeOptionOverviewVisible = !ConflictEditPart.this.mergeOptionOverviewVisible;
                    if (ConflictEditPart.this.mergeOptionOverviewVisible) {
                        ConflictEditPart.this.conflictFigure.setDialogFigure((IFigure)ConflictEditPart.this.mergeOptionOverviewFigure);
                    } else {
                        ConflictEditPart.this.conflictFigure.setDialogFigure(null);
                    }
                    ConflictEditPart.this.conflictFigure.revalidate();
                }
            }
        });
        figure.add((IFigure)overviewButton);
        ButtonFigure nextSolutionButton = new ButtonFigure(">", ButtonFigure.STYLE_BUTTON);
        nextSolutionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EList mergeOptions;
                int nextIndex;
                if (ConflictEditPart.this.mergeOptionOverviewFigure != null && (nextIndex = ConflictEditPart.this.mergeOptionOverviewFigure.getSelectedMergeOptionIndex() + 1) < (mergeOptions = ConflictEditPart.this.fragment.getMergeOptions()).size()) {
                    ConflictEditPart.this.currentMergeOption = (MergeOption)mergeOptions.get(nextIndex);
                    ConflictEditPart.this.conflictFigure.clearConflictFigures();
                    ConflictEditPart.this.createChilds(ConflictEditPart.this.conflictFigure, ConflictEditPart.this.currentMergeOption);
                    ConflictEditPart.this.mergeOptionOverviewFigure.setSelectedMergeOptionIndex(nextIndex);
                    ConflictEditPart.this.conflictFigure.revalidate();
                }
            }
        });
        figure.add((IFigure)nextSolutionButton);
        ButtonFigure prevSolutionButton = new ButtonFigure("<", ButtonFigure.STYLE_BUTTON);
        prevSolutionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ConflictEditPart.this.mergeOptionOverviewFigure != null) {
                    int nextIndex = ConflictEditPart.this.mergeOptionOverviewFigure.getSelectedMergeOptionIndex() - 1;
                    EList mergeOptions = ConflictEditPart.this.fragment.getMergeOptions();
                    if (nextIndex >= 0) {
                        ConflictEditPart.this.currentMergeOption = (MergeOption)mergeOptions.get(nextIndex);
                        ConflictEditPart.this.conflictFigure.clearConflictFigures();
                        ConflictEditPart.this.createChilds(ConflictEditPart.this.conflictFigure, ConflictEditPart.this.currentMergeOption);
                        ConflictEditPart.this.mergeOptionOverviewFigure.setSelectedMergeOptionIndex(nextIndex);
                        ConflictEditPart.this.conflictFigure.revalidate();
                    }
                }
            }
        });
        figure.add((IFigure)prevSolutionButton);
        return figure;
    }

    private void createChilds(ConflictFigure figure, MergeOption mergeOption) {
        HashMap<String, Integer> lifelineNameIndex = new HashMap<String, Integer>();
        ListIterator<LifelineEditPart> lifelineEPIt = this.lifelineEPs.listIterator();
        while (lifelineEPIt.hasNext()) {
            Integer index = new Integer(lifelineEPIt.nextIndex());
            LifelineEditPart editPart = lifelineEPIt.next();
            Lifeline lifeline = (Lifeline)editPart.resolveSemanticElement();
            lifelineNameIndex.put(lifeline.getName(), index);
        }
        HashMap<Message, ConflictMessageFigure> messageFigures = new HashMap<Message, ConflictMessageFigure>();
        EList leftAddedMessages = mergeOption.getLeftAddedMessages();
        EList leftUpdatedMessages = mergeOption.getLeftUpdatedMessages();
        EList leftDeletedMessages = mergeOption.getLeftDeletedMessages();
        EList leftMessages = mergeOption.getLeftMessages();
        ListIterator leftMessagesIt = leftMessages.listIterator();
        while (leftMessagesIt.hasNext()) {
            Message message = (Message)leftMessagesIt.next();
            int fromLifeline = 0;
            int toLifeline = 0;
            Integer fromLifelineIndex = (Integer)lifelineNameIndex.get(message.getSender().getLifeline().getName());
            Integer toLifelineIndex = (Integer)lifelineNameIndex.get(message.getReceiver().getLifeline().getName());
            if (fromLifelineIndex == null) continue;
            fromLifeline = fromLifelineIndex;
            if (toLifelineIndex == null) continue;
            toLifeline = toLifelineIndex;
            ConflictMessageType messageType = null;
            if (leftAddedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.LEFT_ADDED;
            } else if (leftUpdatedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.LEFT_UPDATED;
            } else {
                if (!leftDeletedMessages.contains((Object)message)) continue;
                messageType = ConflictMessageType.DELETED;
            }
            ConflictMessageFigure messageFigure = new ConflictMessageFigure(this.lifelineEPs.size(), fromLifeline, toLifeline, messageType, message.getBody().getName());
            figure.addLeftChild((IFigure)messageFigure);
            messageFigures.put(message, messageFigure);
        }
        EList rightAddedMessages = mergeOption.getRightAddedMessages();
        EList rightUpdatedMessages = mergeOption.getRightUpdatedMessages();
        EList rightDeletedMessages = mergeOption.getRightDeletedMessages();
        EList rightMessages = mergeOption.getRightMessages();
        ListIterator rightMessagesIt = rightMessages.listIterator();
        while (rightMessagesIt.hasNext()) {
            Message message = (Message)rightMessagesIt.next();
            int fromLifeline = 0;
            int toLifeline = 0;
            Integer fromLifelineIndex = (Integer)lifelineNameIndex.get(message.getSender().getLifeline().getName());
            Integer toLifelineIndex = (Integer)lifelineNameIndex.get(message.getReceiver().getLifeline().getName());
            if (fromLifelineIndex == null) continue;
            fromLifeline = fromLifelineIndex;
            if (toLifelineIndex == null) continue;
            toLifeline = toLifelineIndex;
            ConflictMessageType messageType = null;
            if (rightAddedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.RIGHT_ADDED;
            } else if (rightUpdatedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.RIGHT_UPDATED;
            } else {
                if (!rightDeletedMessages.contains((Object)message)) continue;
                messageType = ConflictMessageType.DELETED;
            }
            ConflictMessageFigure messageFigure = new ConflictMessageFigure(this.lifelineEPs.size(), fromLifeline, toLifeline, messageType, message.getBody().getName());
            figure.addRightChild((IFigure)messageFigure);
            messageFigures.put(message, messageFigure);
        }
        EList mergedMessages = mergeOption.getMessages();
        ListIterator mergedMessagesIt = mergedMessages.listIterator();
        while (mergedMessagesIt.hasNext()) {
            Message message = (Message)mergedMessagesIt.next();
            int fromLifeline = 0;
            int toLifeline = 0;
            Integer fromLifelineIndex = (Integer)lifelineNameIndex.get(message.getSender().getLifeline().getName());
            Integer toLifelineIndex = (Integer)lifelineNameIndex.get(message.getReceiver().getLifeline().getName());
            if (fromLifelineIndex == null) continue;
            fromLifeline = fromLifelineIndex;
            if (toLifelineIndex == null) continue;
            toLifeline = toLifelineIndex;
            ConflictMessageType messageType = null;
            if (rightAddedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.RIGHT_ADDED;
            } else if (rightUpdatedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.RIGHT_UPDATED;
            } else if (rightDeletedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.DELETED;
            } else if (leftAddedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.LEFT_ADDED;
            } else if (leftUpdatedMessages.contains((Object)message)) {
                messageType = ConflictMessageType.LEFT_UPDATED;
            } else {
                if (!leftDeletedMessages.contains((Object)message)) continue;
                messageType = ConflictMessageType.DELETED;
            }
            ConflictMessageFigure relatedFigures = (ConflictMessageFigure)((Object)messageFigures.get(message));
            ConflictMessageFigure messageFigure = new ConflictMessageFigure(this.lifelineEPs.size(), fromLifeline, toLifeline, messageType, message.getBody().getName(), true);
            figure.addMergeChild((IFigure)messageFigure, (IFigure)relatedFigures);
        }
    }

    private void updateLifelinePositions(ConflictFigure conflictFigure, List<LifelineEditPart> lifelineEPs) {
        ListIterator<LifelineEditPart> lifelineEPIt = lifelineEPs.listIterator();
        boolean init = true;
        int minX = -1;
        while (lifelineEPIt.hasNext()) {
            IFigure lifelineFigure = lifelineEPIt.next().getFigure();
            if (init) {
                minX = lifelineFigure.getBounds().x;
                init = false;
                continue;
            }
            minX = Math.min(minX, lifelineFigure.getBounds().x);
        }
        while (lifelineEPIt.hasPrevious()) {
            int index = lifelineEPIt.previousIndex();
            IFigure lifelineFigure = lifelineEPIt.previous().getFigure();
            Rectangle figureBounds = lifelineFigure.getBounds();
            conflictFigure.setHorizontalLifelinePosition(index, figureBounds.x + figureBounds.width / 2 - minX);
        }
    }

    private void updateLifelinePositions(ConflictMergeOptionOverview conflictFigure, List<LifelineEditPart> lifelineEPs) {
        ListIterator<LifelineEditPart> lifelineEPIt = lifelineEPs.listIterator();
        boolean init = true;
        int minX = -1;
        while (lifelineEPIt.hasNext()) {
            IFigure lifelineFigure = lifelineEPIt.next().getFigure();
            if (init) {
                minX = lifelineFigure.getBounds().x;
                init = false;
                continue;
            }
            minX = Math.min(minX, lifelineFigure.getBounds().x);
        }
        while (lifelineEPIt.hasPrevious()) {
            int index = lifelineEPIt.previousIndex();
            IFigure lifelineFigure = lifelineEPIt.previous().getFigure();
            Rectangle figureBounds = lifelineFigure.getBounds();
            conflictFigure.setHorizontalLifelinePosition(index, (int)((double)(figureBounds.x + figureBounds.width / 2 - minX) * 0.8));
        }
    }

    private void layoutChildList(List<IFigure> childList, ConflictFigure conflictFigure) {
        int i = 0;
        for (IFigure child : childList) {
            child.setBounds(new Rectangle(1, i * 35 + 1, conflictFigure.getMergeAreaWidth() - 2, 35));
            ++i;
        }
    }

    private void layoutConlictMergeOptionOverview(ConflictMergeOptionOverview figure, ConflictFigure conflictFigure) {
        Dimension childDimension = new Dimension((int)((double)conflictFigure.getMergeAreaWidth() * 0.8), 28);
        List<List<IFigure>> mergeOptions = figure.getMergeOptions();
        for (List<IFigure> children : mergeOptions) {
            this.layoutChildList(children, childDimension);
        }
    }

    private void layoutChildList(List<IFigure> childList, Dimension size) {
        int i = 0;
        for (IFigure child : childList) {
            child.setBounds(new Rectangle(1, i * size.height + 1, size.width - 2, size.height));
            ++i;
        }
    }

    private void layoutCommandBar(ConflictFigure conflictFigure) {
        Rectangle clientArea = conflictFigure.getClientArea();
        Point location = clientArea.getTopRight();
        Iterator<IFigure> iterator = conflictFigure.getButtonBarFigures().iterator();
        while (iterator.hasNext()) {
            IFigure childObject;
            IFigure child = childObject = iterator.next();
            Dimension preferredSize = child.getPreferredSize();
            Rectangle bounds = new Rectangle();
            bounds.setSize(preferredSize);
            location.translate((preferredSize.width + 2) * -1, 0);
            bounds.setLocation(location.getCopy());
            child.setBounds(bounds);
        }
    }

    public ConflictFragment getFragment() {
        return this.fragment;
    }

    public void layout(int yPos) {
        if (this.conflictFigure.getParent() != null) {
            Message lastOriginMessage;
            this.conflictFigure.getParent();
            Rectangle bounds = new Rectangle(0, 0, 50, 50);
            SequenceViewSequenceViewCompartmentEditPart compartment = (SequenceViewSequenceViewCompartmentEditPart)((Object)this.seqViewEP.getChildren().get(0));
            Rectangle lifelineArea = null;
            for (Object child : compartment.getChildren()) {
                if (!(child instanceof LifelineEditPart)) continue;
                LifelineEditPart lifelineEditPart = (LifelineEditPart)((Object)child);
                LifelineLifelineCompartmentEditPart lifelineCompartment = (LifelineLifelineCompartmentEditPart)((Object)lifelineEditPart.getChildren().get(1));
                if (lifelineArea == null) {
                    lifelineArea = lifelineCompartment.getFigure().getBounds().getCopy();
                    continue;
                }
                lifelineArea.union(lifelineCompartment.getFigure().getBounds());
            }
            if (lifelineArea != null) {
                bounds = lifelineArea;
                bounds.expand(bounds.width + 20, 0);
            }
            if ((lastOriginMessage = this.fragment.getLastOrigin()) != null) {
                bounds.translate(0, yPos);
            }
            this.conflictFigure.setMinimumSize(new Dimension());
            if (!bounds.equals((Object)this.conflictFigure.getBounds())) {
                this.conflictFigure.setBounds(bounds);
            }
        }
    }
}

