/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.parts;

import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.modelevolution.multiview.LifelineElement;
import org.modelevolution.multiview.diagram.edit.commands.ReorderLifelineElementCommand;
import org.modelevolution.multiview.diagram.edit.parts.SequenceView2EditPart;
import org.modelevolution.multiview.diagram.edit.policies.StateConditionItemSemanticEditPolicy;
import org.modelevolution.multiview.diagram.requests.ReorderLifelineElementRequest;

public class StateConditionEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 3008;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public StateConditionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new StateConditionItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.removeEditPolicy("PrimaryDrag Policy");
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicyEx(){});
    }

    public DragTracker getDragTracker(Request request) {
        super.getDragTracker(request);
        return new DragEditPartsTracker((EditPart)this){

            protected Command getCommand() {
                Request rawRequest = this.getTargetRequest();
                if (rawRequest instanceof ChangeBoundsRequest) {
                    CompoundCommand command = new CompoundCommand();
                    ChangeBoundsRequest request = (ChangeBoundsRequest)rawRequest;
                    ListIterator editPartIt = request.getEditParts().listIterator();
                    LifelineElement element = null;
                    StateConditionEditPart eventEditPart = null;
                    while (editPartIt.hasNext()) {
                        EditPart editPart = (EditPart)editPartIt.next();
                        if (!(editPart instanceof StateConditionEditPart)) continue;
                        eventEditPart = (StateConditionEditPart)editPart;
                        element = (LifelineElement)eventEditPart.resolveSemanticElement();
                    }
                    int newY = eventEditPart.getFigure().getBounds().y + request.getMoveDelta().y;
                    int index = 0;
                    ListIterator siblingIt = eventEditPart.getParent().getChildren().listIterator();
                    while (siblingIt.hasNext()) {
                        EObject semanticElement;
                        EditPart child = (EditPart)siblingIt.next();
                        if (!(child instanceof GraphicalEditPart)) continue;
                        GraphicalEditPart graphicalEditPart = (GraphicalEditPart)child;
                        if (graphicalEditPart.getFigure().getBounds().y >= newY || graphicalEditPart == eventEditPart || !((semanticElement = graphicalEditPart.resolveSemanticElement()) instanceof LifelineElement)) continue;
                        ++index;
                    }
                    ReorderLifelineElementRequest req = new ReorderLifelineElementRequest(StateConditionEditPart.this.getEditingDomain(), index, element);
                    command.add((Command)new ICommandProxy((ICommand)new ReorderLifelineElementCommand(req)));
                    command.add(super.getCommand());
                    return command;
                }
                return super.getCommand();
            }
        };
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new EventFigure();
        return this.primaryShape;
    }

    public EventFigure getPrimaryShape() {
        return (EventFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(20, 20);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    public void deactivate() {
        super.deactivate();
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public IFigure getFigure() {
        boolean figureExisted = this.figure != null;
        IFigure figure = super.getFigure();
        if (!figureExisted && figure != null) {
            ((SequenceView2EditPart)this.getParent().getParent().getParent().getParent()).getLayout().addLifelineElementEditPart((GraphicalEditPart)this);
        }
        return figure;
    }

    public class EventFigure
    extends RectangleFigure {
        public EventFigure() {
            this.setPreferredSize(new Dimension(StateConditionEditPart.this.getMapMode().DPtoLP(20), StateConditionEditPart.this.getMapMode().DPtoLP(20)));
        }
    }
}

