/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.edit.parts;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.conflictreport.MergeOption;
import org.modelevolution.multiview.diagram.edit.parts.State2EditPart;
import org.modelevolution.multiview.diagram.edit.parts.StateEditPart;
import org.modelevolution.multiview.diagram.edit.parts.Transition2EditPart;
import org.modelevolution.multiview.diagram.edit.parts.TransitionEditPart;
import org.modelevolution.multiview.diagram.edit.policies.StateViewItemSemanticEditPolicy;
import org.modelevolution.multiview.diagram.util.MultiviewDiagramUtil;
import org.modelevolution.multiview.diagram.util.MultiviewModelUtil;

public class StateViewEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 2009;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private Point centeredTopLocation = new Point(300, 400);

    public StateViewEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new StateViewItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new DialogFigure();
        return this.primaryShape;
    }

    public DialogFigure getPrimaryShape() {
        return (DialogFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        shape.setVisible(true);
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public void refresh() {
        super.refresh();
        this.setVisible(this.isVisible());
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean visible) {
        this.setVisibility(visible);
        this.primaryShape.setVisible(visible);
        List<EditPart> transitions = MultiviewDiagramUtil.findEditPartsByClass((EditPart)this, TransitionEditPart.class);
        for (EditPart editPart : transitions) {
            ((TransitionEditPart)editPart).getFigure().setVisible(visible);
        }
        transitions = MultiviewDiagramUtil.findEditPartsByClass((EditPart)this, Transition2EditPart.class);
        for (EditPart editPart : transitions) {
            ((Transition2EditPart)editPart).getFigure().setVisible(visible);
        }
    }

    public boolean isVisible() {
        return this.primaryShape.isVisible();
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public Point getCenteredTopLocation() {
        return this.centeredTopLocation;
    }

    public void setCenteredTopLocation(Point centeredTopLocation) {
        this.centeredTopLocation = centeredTopLocation;
    }

    public void highlightTransitions(MergeOption currentMergeOption) {
        Color highlightColor = new Color((Device)Display.getDefault(), new RGB(104, 252, 208));
        ListIterator<EditPart> transitions = MultiviewDiagramUtil.findEditPartsInStateView(TransitionEditPart.class).listIterator();
        while (transitions.hasNext()) {
            EditPart target;
            TransitionEditPart transitionEP = (TransitionEditPart)transitions.next();
            Transition transition = (Transition)transitionEP.resolveSemanticElement();
            boolean highlightTransition = false;
            if (this.mergeOptionContainsSymbol(currentMergeOption, transition.getTrigger())) {
                highlightTransition = true;
            }
            ListIterator effects = transition.getEffects().listIterator();
            while (effects.hasNext()) {
                Symbol symbol = (Symbol)effects.next();
                if (!this.mergeOptionContainsSymbol(currentMergeOption, symbol)) continue;
                highlightTransition = true;
                break;
            }
            if (!highlightTransition) continue;
            transitionEP.getFigure().setForegroundColor(highlightColor);
            ((Shape)transitionEP.getFigure()).setLineWidth(2);
            EditPart source = transitionEP.getSource();
            if (source instanceof StateEditPart || source instanceof State2EditPart) {
                ((IFigure)((GraphicalEditPart)source).getFigure().getChildren().get(0)).setBackgroundColor(highlightColor);
            }
            if (!((target = transitionEP.getTarget()) instanceof StateEditPart) && !(target instanceof State2EditPart)) continue;
            ((IFigure)((GraphicalEditPart)target).getFigure().getChildren().get(0)).setBackgroundColor(highlightColor);
        }
    }

    private boolean mergeOptionContainsSymbol(MergeOption mergeOption, Symbol symbol) {
        mergeOption.getLeftAddedMessages();
        mergeOption.getLeftUpdatedMessages();
        mergeOption.getLeftDeletedMessages();
        mergeOption.getRightAddedMessages();
        mergeOption.getRightUpdatedMessages();
        mergeOption.getRightDeletedMessages();
        ListIterator messagesIt = mergeOption.getMessages().listIterator();
        while (messagesIt.hasNext()) {
            Message message = (Message)messagesIt.next();
            if (message.getBody() == null || !MultiviewModelUtil.equals(symbol, message.getBody())) continue;
            return true;
        }
        return false;
    }

    public void disableHighlights() {
        ListIterator<EditPart> transitions = MultiviewDiagramUtil.findEditPartsInStateView(TransitionEditPart.class).listIterator();
        while (transitions.hasNext()) {
            EditPart target;
            TransitionEditPart transitionEP = (TransitionEditPart)transitions.next();
            Color foregroundColor = Display.getDefault().getSystemColor(2);
            Color backgroundColor = Display.getDefault().getSystemColor(1);
            transitionEP.getFigure().setForegroundColor(foregroundColor);
            ((Shape)transitionEP.getFigure()).setLineWidth(1);
            EditPart source = transitionEP.getSource();
            if (source instanceof StateEditPart || source instanceof State2EditPart) {
                ((IFigure)((GraphicalEditPart)source).getFigure().getChildren().get(0)).setBackgroundColor(backgroundColor);
            }
            if (!((target = transitionEP.getTarget()) instanceof StateEditPart) && !(target instanceof State2EditPart)) continue;
            ((IFigure)((GraphicalEditPart)target).getFigure().getChildren().get(0)).setBackgroundColor(backgroundColor);
        }
    }

    public class DialogFigure
    extends RectangleFigure {
        protected boolean useLocalCoordinates() {
            return true;
        }
    }
}

