/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.figures;

import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ButtonFigure
extends Clickable {
    private static final RGB DEFAULT_GRADIENT_COLOR_RGB1 = new RGB(200, 200, 200);
    private static final RGB DEFAULT_GRADIENT_COLOR_RGB2 = new RGB(150, 150, 150);
    private static final RGB DEFAULT_TEXT_COLOR = new RGB(0, 0, 0);
    private static final RGB DEFAULT_BORDER_COLOR_RGB = new RGB(100, 100, 100);
    private static final int DEFAULT_WIDTH_PADDING = 10;
    private static final int DEFAULT_HEIGHT_PADDING = 4;
    private static final float DEFAULT_LINE_WIDTH = 1.0f;
    private String text;
    private RGB gradientColor1 = DEFAULT_GRADIENT_COLOR_RGB1;
    private RGB gradientColor2 = DEFAULT_GRADIENT_COLOR_RGB2;
    private RGB borderColor = DEFAULT_BORDER_COLOR_RGB;
    private RGB textColor = DEFAULT_TEXT_COLOR;
    private int widthPadding = 10;
    private int heightPadding = 4;
    private boolean activated = false;
    private float lineWidth = 1.0f;

    public ButtonFigure(String text) {
        this.text = text;
        this.setStyle(STYLE_BUTTON);
    }

    public ButtonFigure(String text, int style) {
        this.text = text;
        this.setStyle(style);
    }

    protected void fillShape(Graphics graphics) {
        graphics.pushState();
        if (this.getModel().isPressed() || this.getModel().isSelected()) {
            graphics.setForegroundColor(new Color((Device)Display.getCurrent(), this.gradientColor2));
            graphics.setBackgroundColor(new Color((Device)Display.getCurrent(), this.gradientColor1));
        } else {
            graphics.setForegroundColor(new Color((Device)Display.getCurrent(), this.gradientColor1));
            graphics.setBackgroundColor(new Color((Device)Display.getCurrent(), this.gradientColor2));
        }
        Rectangle bounds = this.getBounds().getCopy();
        bounds.shrink((int)this.lineWidth, (int)this.lineWidth);
        graphics.setAntialias(1);
        Path clipPath = new Path(null);
        clipPath.addArc((float)(bounds.right() - bounds.height), (float)bounds.y, (float)bounds.height, (float)bounds.height, 270.0f, 180.0f);
        clipPath.addArc((float)bounds.x, (float)bounds.y, (float)bounds.height, (float)bounds.height, 90.0f, 180.0f);
        clipPath.close();
        graphics.clipPath(clipPath);
        graphics.fillGradient(bounds, true);
        graphics.popState();
    }

    protected void outlineShape(Graphics graphics) {
        graphics.pushState();
        graphics.setForegroundColor(new Color((Device)Display.getCurrent(), this.textColor));
        Dimension textBounds = FigureUtilities.getStringExtents((String)this.text, (Font)this.getFont());
        Point textPos = this.getBounds().getCenter();
        textPos.translate(textBounds.width / 2 * -1, textBounds.height / 2 * -1);
        graphics.drawString(this.text, textPos);
        graphics.setForegroundColor(new Color((Device)Display.getCurrent(), this.borderColor));
        Rectangle bounds = this.getBounds().getCopy();
        bounds.shrink((int)this.lineWidth, (int)this.lineWidth);
        graphics.setLineWidthFloat(this.lineWidth);
        Path borderPath = new Path(null);
        borderPath.addArc((float)(bounds.right() - bounds.height), (float)bounds.y, (float)bounds.height, (float)bounds.height, 270.0f, 180.0f);
        borderPath.addArc((float)bounds.x, (float)bounds.y, (float)bounds.height, (float)bounds.height, 90.0f, 180.0f);
        borderPath.close();
        graphics.drawPath(borderPath);
        graphics.popState();
    }

    public void paint(Graphics graphics) {
        this.fillShape(graphics);
        this.outlineShape(graphics);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension textBounds = FigureUtilities.getStringExtents((String)this.text, (Font)this.getFont());
        return textBounds.expand(this.widthPadding * 2, this.heightPadding * 2);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public RGB getGradientColor1() {
        return this.gradientColor1;
    }

    public void setGradientColor1(RGB gradientColor1) {
        this.gradientColor1 = gradientColor1;
    }

    public RGB getGradientColor2() {
        return this.gradientColor2;
    }

    public void setGradientColor2(RGB gradientColor2) {
        this.gradientColor2 = gradientColor2;
    }

    public int getWidthPadding() {
        return this.widthPadding;
    }

    public void setWidthPadding(int widthPadding) {
        this.widthPadding = widthPadding;
    }

    public int getHeightPadding() {
        return this.heightPadding;
    }

    public void setHeightPadding(int heightPadding) {
        this.heightPadding = heightPadding;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }
}

