/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.parsers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.modelevolution.multiview.Guard;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.diagram.util.MultiviewDiagramUtil;
import org.modelevolution.multiview.diagram.util.MultiviewModelUtil;

public class TransitionLabelExpressionLabelParser
implements IParser {
    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, final String newString, int flags) {
        final EObject target = (EObject)element.getAdapter(EObject.class);
        if (!this.validateValues(target, newString)) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)target);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        IFile affectedFile = WorkspaceSynchronizer.getFile((Resource)target.eResource());
        return new AbstractTransactionalCommand(editingDomain, "Set Values", affectedFile == null ? null : Collections.singletonList(affectedFile)){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return new CommandResult(TransitionLabelExpressionLabelParser.this.updateValues(target, newString));
            }
        };
    }

    public String getPrintString(IAdaptable element, int flags) {
        EObject obj;
        StringBuffer output = new StringBuffer();
        if (element instanceof EObjectAdapter && (obj = (EObject)((EObjectAdapter)element).getRealObject()) instanceof Transition) {
            Transition transition = (Transition)obj;
            Symbol trigger = transition.getTrigger();
            EList effects = transition.getEffects();
            Guard guard = transition.getGuard();
            if (trigger != null) {
                output.append(trigger.getName());
            }
            if (!effects.isEmpty() || guard != null) {
                output.append(" /");
            }
            if (!effects.isEmpty()) {
                for (Symbol effect : effects) {
                    output.append(" ");
                    output.append(effect.getName());
                    output.append(",");
                }
                int length = output.length();
                output.delete(length - 1, length);
            }
            if (guard != null) {
                output.append("[");
                output.append(guard.getOclExpression());
                output.append("]");
            }
            if (output.length() > 0) {
                return output.toString();
            }
        }
        return "";
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    private boolean validateValues(EObject target, String newString) {
        return newString.matches("([^\\[\\]]*/)?(([^\\[\\]]*,)*[^\\[\\]]*)(\\[.+\\])?");
    }

    private IStatus updateValues(EObject target, String newString) throws ExecutionException {
        ConnectionEditPart editpart;
        Transition transition = (Transition)target;
        new StringBuffer(newString);
        String[] elements = newString.split("/");
        if (elements.length > 0) {
            String element = elements[0].trim();
            StateView stateview = null;
            EObject container = transition.eContainer();
            while (container != null && !(container instanceof StateView)) {
                container = container.eContainer();
            }
            if (container == null) {
                return new Status(4, "org.modelevolution.multiview.diagram", "Could not find containing StateView");
            }
            stateview = (StateView)container;
            EList alphabet = stateview.getAlphabet();
            if (element.startsWith("[") && element.endsWith("[")) {
                transition.setGuard(this.createGuard(element.substring(1, element.length() - 1)));
            } else {
                transition.setTrigger(this.createSymbol(element, (List<Symbol>)alphabet));
                if (elements.length > 1) {
                    elements = elements[1].split("\\[");
                    element = elements[0];
                    if (elements.length > 1) {
                        String[] sEffects = element.split(",");
                        EList effects = transition.getEffects();
                        String[] stringArray = sEffects;
                        int n = sEffects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String sEffect = stringArray[n2];
                            Symbol newSymbol = this.createSymbol(sEffect, (List<Symbol>)alphabet);
                            if (MultiviewModelUtil.findEqualSymbol((List<Symbol>)effects, newSymbol) == null) {
                                effects.add(newSymbol);
                            }
                            ++n2;
                        }
                        element = elements[1];
                        transition.setGuard(this.createGuard(element.substring(0, element.length() - 1)));
                    } else if (element.endsWith("]")) {
                        transition.setGuard(this.createGuard(element.substring(0, element.length() - 1)));
                    } else {
                        String[] sEffects = element.split(",");
                        EList effects = transition.getEffects();
                        String[] stringArray = sEffects;
                        int n = sEffects.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String sEffect = stringArray[n3];
                            Symbol newSymbol = this.createSymbol(sEffect, (List<Symbol>)alphabet);
                            if (MultiviewModelUtil.findEqualSymbol((List<Symbol>)effects, newSymbol) == null) {
                                effects.add(newSymbol);
                            }
                            ++n3;
                        }
                    }
                }
            }
        }
        if ((editpart = (ConnectionEditPart)MultiviewDiagramUtil.findAllEditPartByModel(target)) != null) {
            ((LabelEditPart)editpart.getChildren().get(0)).refresh();
        }
        return Status.OK_STATUS;
    }

    private String evaluatePrintExpression(EObject self) {
        throw new UnsupportedOperationException("No user java implementation provided in 'evaluatePrintExpression' operation");
    }

    private Guard createGuard(String expression) {
        Guard guard = MultiviewFactory.eINSTANCE.createGuard();
        guard.setOclExpression(expression);
        return guard;
    }

    private Symbol createSymbol(String name, List<Symbol> alphabet) {
        Symbol symbol = MultiviewFactory.eINSTANCE.createSymbol();
        symbol.setName(name.trim());
        Symbol existingSymbol = MultiviewModelUtil.findEqualSymbol(alphabet, symbol);
        if (existingSymbol == null) {
            alphabet.add(symbol);
        } else {
            symbol = existingSymbol;
        }
        return symbol;
    }
}

