/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.modelevolution.multiview.diagram.part.Messages;
import org.modelevolution.multiview.diagram.part.MultiviewCreationWizardPage;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramEditorPlugin;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramEditorUtil;

public class MultiviewCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected MultiviewCreationWizardPage diagramModelFilePage;
    protected MultiviewCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.MultiviewCreationWizardTitle);
        this.setDefaultPageImageDescriptor(MultiviewDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewMultiviewWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new MultiviewCreationWizardPage("DiagramModelFile", this.getSelection(), "mvmld");
        this.diagramModelFilePage.setTitle(Messages.MultiviewCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.MultiviewCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new MultiviewCreationWizardPage("DomainModelFile", this.getSelection(), "mvml"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = MultiviewCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".mvmld".length());
                    this.setFileName(MultiviewDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "mvml"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.MultiviewCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.MultiviewCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                MultiviewCreationWizard.this.diagram = MultiviewDiagramEditorUtil.createDiagram(MultiviewCreationWizard.this.diagramModelFilePage.getURI(), MultiviewCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (MultiviewCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && MultiviewCreationWizard.this.diagram != null) {
                    try {
                        MultiviewDiagramEditorUtil.openDiagram(MultiviewCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)MultiviewCreationWizard.this.getContainer().getShell(), (String)Messages.MultiviewCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.MultiviewCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                MultiviewDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

