/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.diagram.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.modelevolution.multiview.Class;
import org.modelevolution.multiview.ClassView;
import org.modelevolution.multiview.CombinedFragment;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.LifelineElement;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultipleOperandCF;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.NamedElement;
import org.modelevolution.multiview.OneOperandCF;
import org.modelevolution.multiview.Operand;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateCondition;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;

public class MultiviewModelUtil {
    public static boolean equals(Lifeline obj1, Lifeline obj2, boolean checkElements) {
        Class class1 = obj1.getClass_();
        Class class2 = obj2.getClass_();
        if (class1 != null && class2 != null ? !MultiviewModelUtil.equals((NamedElement)class1, (NamedElement)class2) : class1 != class2) {
            return false;
        }
        if (checkElements && !MultiviewModelUtil.equals((List<LifelineElement>)obj1.getElements(), (List<LifelineElement>)obj2.getElements())) {
            return false;
        }
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(List<LifelineElement> obj1, List<LifelineElement> obj2) {
        if (obj1.size() != obj2.size()) {
            return false;
        }
        ListIterator<LifelineElement> obj1It = obj1.listIterator();
        ListIterator<LifelineElement> obj2It = obj2.listIterator();
        while (obj1It.hasNext() && obj2It.hasNext()) {
            if (MultiviewModelUtil.equals(obj1It.next(), obj1It.next(), false)) continue;
            return false;
        }
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(LifelineElement obj1, LifelineElement obj2, boolean checkIndex) {
        if (!obj1.getClass().equals(obj2.getClass())) {
            return false;
        }
        if (obj1 instanceof SendEvent) {
            return MultiviewModelUtil.equals((SendEvent)obj1, (SendEvent)obj2, checkIndex);
        }
        if (obj1 instanceof ReceiveEvent) {
            return MultiviewModelUtil.equals((ReceiveEvent)obj1, (ReceiveEvent)obj2, checkIndex);
        }
        if (obj1 instanceof StateCondition) {
            return MultiviewModelUtil.equals((StateCondition)obj1, (StateCondition)obj2, checkIndex);
        }
        return true;
    }

    public static boolean equals(SendEvent obj1, SendEvent obj2, boolean checkIndex) {
        if (checkIndex && obj1.getLifeline().getElements().indexOf((Object)obj1) != obj2.getLifeline().getElements().indexOf((Object)obj2)) {
            return false;
        }
        Message msg1 = obj1.getMessage();
        Message msg2 = obj2.getMessage();
        if (msg1 != null && msg2 != null ? !MultiviewModelUtil.equals(msg1, msg2, false, false) : msg1 != msg2) {
            return false;
        }
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(ReceiveEvent obj1, ReceiveEvent obj2, boolean checkIndex) {
        if (checkIndex) {
            if (obj1.getLifeline().getElements().indexOf((Object)obj1) != obj2.getLifeline().getElements().indexOf((Object)obj2)) {
                return false;
            }
            checkIndex = false;
        }
        Message msg1 = obj1.getMessage();
        Message msg2 = obj2.getMessage();
        if (msg1 != null && msg2 != null ? !MultiviewModelUtil.equals(msg1, msg2, false, false) : msg1 != msg2) {
            return false;
        }
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(StateCondition obj1, StateCondition obj2, boolean checkIndex) {
        if (checkIndex) {
            if (obj1.getLifeline().getElements().indexOf((Object)obj1) != obj2.getLifeline().getElements().indexOf((Object)obj2)) {
                return false;
            }
            checkIndex = false;
        }
        return MultiviewModelUtil.equals((NamedElement)obj1.getState(), (NamedElement)obj1.getState());
    }

    public static boolean equals(Message obj1, Message obj2, boolean checkEvents, boolean checkEventPosition) {
        if (checkEvents) {
            ReceiveEvent rEvent1 = obj1.getReceiver();
            ReceiveEvent rEvent2 = obj2.getReceiver();
            if (rEvent1 != null && rEvent2 != null ? !MultiviewModelUtil.equals(rEvent1, rEvent2, checkEventPosition) : rEvent1 != rEvent2) {
                return false;
            }
            SendEvent sEvent1 = obj1.getSender();
            SendEvent sEvent2 = obj2.getSender();
            if (sEvent1 != null && sEvent2 != null ? !MultiviewModelUtil.equals(sEvent1, sEvent2, checkEventPosition) : sEvent1 != sEvent2) {
                return false;
            }
        }
        Symbol symbol1 = obj1.getBody();
        Symbol symbol2 = obj2.getBody();
        return !(symbol1 != null && symbol2 != null ? !MultiviewModelUtil.equals(symbol1, symbol2) : symbol1 != symbol2);
    }

    public static boolean equals(Symbol obj1, Symbol obj2) {
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(MultiviewModel obj1, MultiviewModel obj2) {
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(ClassView obj1, ClassView obj2) {
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(StateView obj1, StateView obj2) {
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(SequenceView obj1, SequenceView obj2) {
        return MultiviewModelUtil.equals((NamedElement)obj1, (NamedElement)obj2);
    }

    public static boolean equals(NamedElement obj1, NamedElement obj2) {
        return obj1.getName().equals(obj2.getName());
    }

    public static Class findEqualClass(ClassView classview, Class class_) {
        Class foundClass = null;
        ListIterator classIt = classview.getClasses().listIterator();
        while (classIt.hasNext()) {
            Class currentClass = (Class)classIt.next();
            if (!MultiviewModelUtil.equals((NamedElement)currentClass, (NamedElement)class_)) continue;
            foundClass = currentClass;
            break;
        }
        return foundClass;
    }

    public static Symbol findEqualSymbol(StateView stateview, Symbol symbol) {
        Symbol foundSymbol = null;
        ListIterator symbolIt = stateview.getAlphabet().listIterator();
        while (symbolIt.hasNext()) {
            Symbol currentSymbol = (Symbol)symbolIt.next();
            if (!MultiviewModelUtil.equals(currentSymbol, symbol)) continue;
            foundSymbol = currentSymbol;
            break;
        }
        return foundSymbol;
    }

    public static Symbol findEqualSymbol(List<Symbol> alphabet, Symbol symbol) {
        Symbol foundSymbol = null;
        ListIterator<Symbol> symbolIt = alphabet.listIterator();
        while (symbolIt.hasNext()) {
            Symbol currentSymbol = symbolIt.next();
            if (!MultiviewModelUtil.equals(currentSymbol, symbol)) continue;
            foundSymbol = currentSymbol;
            break;
        }
        return foundSymbol;
    }

    public static State findEqualState(StateView stateview, State state) {
        State foundState = null;
        ListIterator regionIt = stateview.getStatemachines().listIterator();
        while (regionIt.hasNext()) {
            foundState = MultiviewModelUtil.findEqualState((Region)regionIt.next(), state);
            if (foundState != null) break;
        }
        return foundState;
    }

    public static State findEqualState(Region region, State state) {
        State foundState = null;
        ListIterator stateIt = region.getStates().listIterator();
        while (stateIt.hasNext()) {
            State tmpState = (State)stateIt.next();
            if (MultiviewModelUtil.equals((NamedElement)tmpState, (NamedElement)state)) {
                foundState = tmpState;
                break;
            }
            if (tmpState.getSubregion() != null && (foundState = MultiviewModelUtil.findEqualState(tmpState.getSubregion(), state)) != null) break;
        }
        return foundState;
    }

    public static Lifeline findEqualLifeline(SequenceView seqView, Lifeline lifeline, boolean checkElements) {
        Lifeline foundLifeline = null;
        ListIterator lifelineIt = seqView.getLifelines().listIterator();
        while (lifelineIt.hasNext()) {
            Lifeline tmpLifeline = (Lifeline)lifelineIt.next();
            if (!MultiviewModelUtil.equals(tmpLifeline, lifeline, checkElements)) continue;
            foundLifeline = tmpLifeline;
            break;
        }
        return foundLifeline;
    }

    public static List<Operand> findContainingOperands(SequenceView seqView, LifelineElement element) {
        ArrayList<Operand> operandList = new ArrayList<Operand>();
        ListIterator fragmentIt = seqView.getFragments().listIterator();
        while (fragmentIt.hasNext()) {
            CombinedFragment fragment = (CombinedFragment)fragmentIt.next();
            if (fragment instanceof OneOperandCF) {
                Operand tmpOperand = ((OneOperandCF)fragment).getOperand();
                if (tmpOperand == null || !MultiviewModelUtil.contains(tmpOperand, element)) continue;
                operandList.add(tmpOperand);
                continue;
            }
            if (!(fragment instanceof MultipleOperandCF)) continue;
            ListIterator operandsIt = ((MultipleOperandCF)fragment).getOperands().listIterator();
            while (operandsIt.hasNext()) {
                Operand tmpOperand = (Operand)operandsIt.next();
                if (tmpOperand == null || !MultiviewModelUtil.contains(tmpOperand, element)) continue;
                operandList.add(tmpOperand);
            }
        }
        return operandList;
    }

    public static boolean contains(Operand tmpOperand, LifelineElement element) {
        ListIterator elementIt = tmpOperand.getCovers().listIterator();
        while (elementIt.hasNext()) {
            if (!MultiviewModelUtil.equals((LifelineElement)elementIt.next(), element, true)) continue;
            return true;
        }
        return false;
    }
}

