/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.mc.encoding.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.mc.encoding.engine.IEncodingEngineCheckSequence;
import org.modelevolution.multiview.mc.encoding.engine.impl.StateLifeline;
import org.modelevolution.multiview.mc.encoding.engine.impl.TransitionLifeline;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class EncodingEngineCheckSequence
implements IEncodingEngineCheckSequence {
    private static final String EPSILON_STRING = "e";
    private static final String INTER_STRING = "I:";
    private static final String STATE_STRING = "Q:";
    private static final String SYMBOL_STRING = "S:";
    private static final String TRANS_STRING = "T:";
    private static final String TSEITIN_STRING = "A:";
    private static final int stepsPerMessage = 4;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_TIME = true;
    private ISolver solver;
    private Map<String, Integer> varNames;
    private Map<Integer, String> variableMap;
    private Map<String, Set<TransitionLifeline>> triggerToTransitions;
    private Map<String, Set<TransitionLifeline>> effectToTransitions;
    private Map<String, Object> varToObject;
    private int tseitinCnt;
    private int clauseCnt;

    public EncodingEngineCheckSequence(ISolver solver) {
        this.solver = solver;
    }

    @Override
    public void generateEncoding(MultiviewModel mvmodel, int bound, IProgressMonitor monitor) throws ContradictionException {
        this.generateEncoding(mvmodel, mvmodel.getSequenceview().getMessages().size(), bound, monitor);
    }

    @Override
    public void generateEncoding(MultiviewModel mvmodel, int lastMsgIndex, int bound, IProgressMonitor monitor) throws ContradictionException {
        monitor.beginTask("Generate encoding", 10);
        SequenceView sequenceView = mvmodel.getSequenceview();
        StateView stateView = mvmodel.getStateview();
        this.varNames = new HashMap<String, Integer>();
        this.variableMap = new HashMap<Integer, String>();
        this.triggerToTransitions = new HashMap<String, Set<TransitionLifeline>>();
        this.effectToTransitions = new HashMap<String, Set<TransitionLifeline>>();
        this.varToObject = new HashMap<String, Object>();
        this.tseitinCnt = 0;
        this.clauseCnt = 0;
        monitor.worked(1);
        Assert.isTrue((sequenceView.getMessages().size() >= lastMsgIndex ? 1 : 0) != 0, (String)"lastMsgIndex larger than sequenceView.getMessages().size()");
        bound += sequenceView.getMessages().size() * 4;
        long encodingTimeStart = System.nanoTime();
        long encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        int currentClauseCnt = this.clauseCnt;
        encodingTimeStart = System.nanoTime();
        this.addInit(sequenceView, stateView);
        monitor.worked(1);
        encodingTimeStart = System.nanoTime();
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addInit\t\t\t\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        encodingTimeStart = System.nanoTime();
        this.addTransitionsToIntermediate(sequenceView, stateView, bound);
        monitor.worked(1);
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addTransitionsToIntermediate\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        encodingTimeStart = System.nanoTime();
        this.addTriggerFrame((EList<Symbol>)stateView.getAlphabet(), bound);
        monitor.worked(1);
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addTriggerFrame\t\t\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        encodingTimeStart = System.nanoTime();
        this.addEffectFrame((EList<Symbol>)stateView.getAlphabet(), bound);
        monitor.worked(1);
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addEffectFrame\t\t\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        encodingTimeStart = System.nanoTime();
        this.addStateFrame(sequenceView, stateView, bound);
        monitor.worked(1);
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addStateFrame\t\t\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        encodingTimeStart = System.nanoTime();
        this.addInterStateFrame(sequenceView, stateView, bound);
        monitor.worked(1);
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addInterStateFrame\t\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        encodingTimeStart = System.nanoTime();
        this.addTransitionsFromIntermediate(sequenceView, stateView, bound);
        monitor.worked(1);
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addTransitionsFromIntermediate\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        encodingTimeStart = System.nanoTime();
        this.addOneStateEachTime(sequenceView, stateView, bound);
        monitor.worked(1);
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addOneStateEachTime\t\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        encodingTimeStart = System.nanoTime();
        this.addSequence(sequenceView, stateView, lastMsgIndex, bound);
        monitor.worked(1);
        encodingTimeCurrent = System.nanoTime() - encodingTimeStart;
        currentClauseCnt = this.clauseCnt - currentClauseCnt;
        System.out.println("addSequence\t\t\t" + encodingTimeCurrent / 1000000L + " / " + currentClauseCnt);
        monitor.done();
    }

    private void addOneStateEachTime(SequenceView sequenceView, StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Lifeline lifeline : sequenceView.getLifelines()) {
                Region statemachine = lifeline.getClass_().getStatemachine();
                ArrayList<String> extStateNames = new ArrayList<String>();
                for (State state : statemachine.getStates()) {
                    extStateNames.add(this.getStateVar(state, lifeline, time));
                    for (Transition transition : state.getOutgoing()) {
                        extStateNames.add(this.getInterVar(new TransitionLifeline(transition, lifeline), time));
                    }
                }
                int[] clauseAll = new int[extStateNames.size()];
                int[] clauseBinary = new int[2];
                int cnt = 0;
                while (cnt < extStateNames.size()) {
                    clauseAll[cnt] = this.getVarInt((String)extStateNames.get(cnt));
                    clauseBinary[0] = -1 * this.getVarInt((String)extStateNames.get(cnt));
                    int cnt2 = cnt + 1;
                    while (cnt2 < extStateNames.size()) {
                        clauseBinary[1] = -1 * this.getVarInt((String)extStateNames.get(cnt2));
                        this.addClause(clauseBinary);
                        ++cnt2;
                    }
                    ++cnt;
                }
                this.addClause(clauseAll);
            }
            ++time;
        }
    }

    private void addTransitionsFromIntermediate(SequenceView sequenceView, StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Lifeline lifeline : sequenceView.getLifelines()) {
                Region statemachine = lifeline.getClass_().getStatemachine();
                for (State state : statemachine.getStates()) {
                    for (Transition transition : state.getOutgoing()) {
                        EList effects = transition.getEffects();
                        int[] clause = new int[effects.size() + 2];
                        clause[0] = -1 * this.getVarInt(this.getInterVar(new TransitionLifeline(transition, lifeline), time));
                        int cnt = 1;
                        for (Symbol effect : effects) {
                            clause[cnt] = this.getVarInt(this.getSymbolVar(effect, time + 1));
                            ++cnt;
                        }
                        clause[clause.length - 1] = this.getVarInt(this.getStateVar(transition.getTarget(), lifeline, time + 1));
                        this.addClause(clause);
                    }
                }
            }
            ++time;
        }
    }

    private void addStateFrame(SequenceView sequenceView, StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Lifeline lifeline : sequenceView.getLifelines()) {
                Region statemachine = lifeline.getClass_().getStatemachine();
                for (State srcState : statemachine.getStates()) {
                    EList outgoingTrans = srcState.getOutgoing();
                    int[] clause = new int[outgoingTrans.size() + 2];
                    clause[0] = -1 * this.getVarInt(this.getStateVar(srcState, lifeline, time));
                    clause[1] = this.getVarInt(this.getStateVar(srcState, lifeline, time + 1));
                    int cnt = 2;
                    for (Transition transition : outgoingTrans) {
                        clause[cnt] = this.getVarInt(this.getTransVar(new TransitionLifeline(transition, lifeline), time));
                        ++cnt;
                    }
                    this.addClause(clause);
                }
            }
            ++time;
        }
    }

    private void addInit(SequenceView sequenceView, StateView stateView) throws ContradictionException {
        for (Lifeline lifeline : sequenceView.getLifelines()) {
            Region statemachine = lifeline.getClass_().getStatemachine();
            if (statemachine == null) continue;
            State initState = statemachine.getInitialTransition().getTarget();
            int[] clause = new int[1];
            for (State state : statemachine.getStates()) {
                clause[0] = state.equals(initState) ? this.getVarInt(this.getStateVar(state, lifeline, 0)) : -1 * this.getVarInt(this.getStateVar(state, lifeline, 0));
                this.addClause(clause);
            }
        }
        for (Symbol symbol : stateView.getAlphabet()) {
            int[] clause = new int[]{-1 * this.getVarInt(this.getSymbolVar(symbol, 0))};
            this.addClause(clause);
        }
    }

    private void addSequence(SequenceView sequenceView, StateView stateView, int lastMsgIndex, int bound) throws ContradictionException {
        EList messages = sequenceView.getMessages();
        int time = bound - messages.size() * 4;
        int i = 0;
        while (i < lastMsgIndex) {
            Object tseitinClause;
            Object noMessage;
            Message message = (Message)messages.get(i);
            Lifeline sender = message.getSender().getLifeline();
            Lifeline receiver = message.getReceiver().getLifeline();
            int[] messageClause = new int[]{this.getVarInt(this.getMessageVar(message, time + 1))};
            this.addClause(messageClause);
            messageClause[0] = -1 * this.getVarInt(this.getMessageVar(message, time + 2));
            this.addClause(messageClause);
            for (Symbol symbol : stateView.getAlphabet()) {
                noMessage = new int[2];
                if (symbol != message.getBody()) {
                    noMessage[0] = -1 * this.getVarInt(this.getSymbolVar(symbol, time));
                    noMessage[1] = this.getVarInt(this.getSymbolVar(symbol, time + 1));
                    this.addClause((int[])noMessage);
                    noMessage[0] = -1 * this.getVarInt(this.getSymbolVar(symbol, time + 1));
                    noMessage[1] = this.getVarInt(this.getSymbolVar(symbol, time + 2));
                    this.addClause((int[])noMessage);
                }
                noMessage[0] = -1 * this.getVarInt(this.getSymbolVar(symbol, time + 2));
                noMessage[1] = this.getVarInt(this.getSymbolVar(symbol, time + 3));
                this.addClause((int[])noMessage);
                noMessage[0] = -1 * this.getVarInt(this.getSymbolVar(symbol, time + 3));
                noMessage[1] = this.getVarInt(this.getSymbolVar(symbol, time + 4));
                this.addClause((int[])noMessage);
            }
            ArrayList<TransitionLifeline> transitionsEffect = new ArrayList<TransitionLifeline>();
            noMessage = sender.getClass_().getStatemachine().getStates().iterator();
            while (noMessage.hasNext()) {
                State state = (State)noMessage.next();
                for (Transition transition : state.getOutgoing()) {
                    if (!transition.getEffects().contains((Object)message.getBody())) continue;
                    transitionsEffect.add(new TransitionLifeline(transition, sender));
                }
            }
            int[] transitionsEffectClause = new int[transitionsEffect.size()];
            int transNr = 0;
            for (TransitionLifeline transitionLifeline : transitionsEffect) {
                tseitinClause = new int[2];
                String tseitinVar = this.getTseitinVar(time);
                tseitinClause[0] = -1 * this.getVarInt(tseitinVar);
                tseitinClause[1] = -1 * this.getVarInt(this.getInterVar(transitionLifeline, time + 2));
                this.addClause((int[])tseitinClause);
                tseitinClause[0] = -1 * this.getVarInt(tseitinVar);
                tseitinClause[1] = this.getVarInt(this.getInterVar(transitionLifeline, time + 1));
                this.addClause((int[])tseitinClause);
                transitionsEffectClause[transNr] = this.getVarInt(tseitinVar);
                ++transNr;
            }
            this.addClause(transitionsEffectClause);
            ArrayList<Transition> arrayList = new ArrayList<Transition>();
            tseitinClause = receiver.getClass_().getStatemachine().getStates().iterator();
            while (tseitinClause.hasNext()) {
                State state = (State)tseitinClause.next();
                for (Transition transition : state.getOutgoing()) {
                    if (transition.getTrigger() == null || !transition.getTrigger().equals(message.getBody())) continue;
                    arrayList.add(transition);
                }
            }
            int[] transitionsTriggerClause = new int[arrayList.size()];
            transNr = 0;
            for (Transition transition : arrayList) {
                transitionsTriggerClause[transNr] = this.getVarInt(this.getTransVar(new TransitionLifeline(transition, receiver), time + 1));
                ++transNr;
            }
            time += 4;
            ++i;
        }
    }

    private void addEffectFrame(EList<Symbol> symbols, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Symbol effect : symbols) {
                String effectName = effect.getName();
                if (this.effectToTransitions.keySet().contains(effectName)) {
                    Set<TransitionLifeline> transitions = this.effectToTransitions.get(effectName);
                    int[] clause = new int[transitions.size() + 2];
                    int[] clauseXOR = new int[4];
                    clause[0] = this.getVarInt(this.getStringSymbolVar(effectName, time));
                    clause[1] = -1 * this.getVarInt(this.getStringSymbolVar(effectName, time + 1));
                    clauseXOR[0] = this.getVarInt(this.getStringSymbolVar(effectName, time));
                    clauseXOR[1] = -1 * this.getVarInt(this.getStringSymbolVar(effectName, time + 1));
                    int cnt = 2;
                    for (TransitionLifeline tl : transitions) {
                        clause[cnt] = this.getVarInt(this.getTransVar(tl, time));
                        clauseXOR[2] = -1 * this.getVarInt(this.getTransVar(tl, time));
                        ++cnt;
                        for (TransitionLifeline tl2 : transitions) {
                            if (tl.equals(tl2)) continue;
                            clauseXOR[3] = -1 * this.getVarInt(this.getTransVar(tl2, time));
                            this.addClause(clauseXOR);
                        }
                    }
                    this.addClause(clause);
                    continue;
                }
                int[] clause = new int[]{this.getVarInt(this.getStringSymbolVar(effectName, time)), -1 * this.getVarInt(this.getStringSymbolVar(effectName, time + 1))};
                this.addClause(clause);
            }
            ++time;
        }
    }

    private void addTriggerFrame(EList<Symbol> symbols, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Symbol trigger : symbols) {
                String triggerName = trigger.getName();
                if (this.triggerToTransitions.keySet().contains(triggerName)) {
                    Set<TransitionLifeline> transitions = this.triggerToTransitions.get(triggerName);
                    int[] clause = new int[transitions.size() + 2];
                    int[] clauseXOR = new int[4];
                    clause[0] = -1 * this.getVarInt(this.getStringSymbolVar(triggerName, time));
                    clause[1] = this.getVarInt(this.getStringSymbolVar(triggerName, time + 1));
                    clauseXOR[0] = -1 * this.getVarInt(this.getStringSymbolVar(triggerName, time));
                    clauseXOR[1] = this.getVarInt(this.getStringSymbolVar(triggerName, time + 1));
                    int cnt = 2;
                    for (TransitionLifeline tl : transitions) {
                        clause[cnt] = this.getVarInt(this.getTransVar(tl, time));
                        clauseXOR[2] = -1 * clause[cnt];
                        ++cnt;
                        for (TransitionLifeline tl2 : transitions) {
                            if (tl.equals(tl2)) continue;
                            clauseXOR[3] = -1 * this.getVarInt(this.getTransVar(tl2, time));
                            this.addClause(clauseXOR);
                        }
                    }
                    this.addClause(clause);
                    continue;
                }
                int[] clause = new int[]{-1 * this.getVarInt(this.getStringSymbolVar(triggerName, time)), this.getVarInt(this.getStringSymbolVar(triggerName, time + 1))};
                this.addClause(clause);
            }
            ++time;
        }
    }

    private void addTransitionsToIntermediate(SequenceView sequenceView, StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Lifeline lifeline : sequenceView.getLifelines()) {
                Region statemachine = lifeline.getClass_().getStatemachine();
                for (State srcState : statemachine.getStates()) {
                    for (Transition transition : srcState.getOutgoing()) {
                        Symbol trigger = transition.getTrigger();
                        int[] clause = new int[2];
                        clause[0] = -1 * this.getVarInt(this.getTransVar(new TransitionLifeline(transition, lifeline), time));
                        if (trigger != null) {
                            clause[1] = this.getVarInt(this.getSymbolVar(trigger, time));
                            this.addClause(clause);
                            clause[1] = -1 * this.getVarInt(this.getSymbolVar(trigger, time + 1));
                            this.addClause(clause);
                        }
                        clause[1] = this.getVarInt(this.getStateVar(srcState, lifeline, time));
                        this.addClause(clause);
                        clause[1] = this.getVarInt(this.getInterVar(new TransitionLifeline(transition, lifeline), time + 1));
                        this.addClause(clause);
                        for (Symbol effect : transition.getEffects()) {
                            clause[1] = this.getVarInt(this.getSymbolVar(effect, time + 1));
                            this.addClause(clause);
                            clause[1] = -1 * this.getVarInt(this.getSymbolVar(effect, time));
                            this.addClause(clause);
                            if (effect == null) continue;
                            this.addTransitionToEffect(transition, lifeline, effect);
                        }
                        if (trigger == null) continue;
                        this.addTransitionToTrigger(transition, lifeline, trigger);
                    }
                }
            }
            ++time;
        }
    }

    private void addInterStateFrame(SequenceView sequenceView, StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Lifeline lifeline : sequenceView.getLifelines()) {
                Region statemachine = lifeline.getClass_().getStatemachine();
                for (State state : statemachine.getStates()) {
                    for (Transition transition : state.getOutgoing()) {
                        EList effects = transition.getEffects();
                        if (effects == null || effects.size() <= 0) continue;
                        TransitionLifeline tl = new TransitionLifeline(transition, lifeline);
                        int[] clause1 = new int[3];
                        int[] clause2 = new int[3];
                        clause1[0] = -1 * this.getVarInt(this.getInterVar(tl, time));
                        clause1[1] = -1 * this.getVarInt(this.getInterVar(tl, time + 1));
                        clause2[0] = -1 * this.getVarInt(this.getInterVar(tl, time));
                        clause2[1] = this.getVarInt(this.getInterVar(tl, time + 1));
                        for (Symbol effect : effects) {
                            clause1[2] = this.getVarInt(this.getSymbolVar(effect, time + 1));
                            clause2[2] = -1 * this.getVarInt(this.getSymbolVar(effect, time + 1));
                            this.addClause(clause1);
                            this.addClause(clause2);
                        }
                    }
                }
            }
            ++time;
        }
    }

    private void addTransitionToTrigger(Transition transition, Lifeline lifeline, Symbol trigger) {
        if (!this.triggerToTransitions.containsKey(trigger.getName())) {
            this.triggerToTransitions.put(trigger.getName(), new HashSet());
        }
        this.triggerToTransitions.get(trigger.getName()).add(new TransitionLifeline(transition, lifeline));
    }

    private void addTransitionToEffect(Transition transition, Lifeline lifeline, Symbol effect) {
        if (!this.effectToTransitions.containsKey(effect.getName())) {
            this.effectToTransitions.put(effect.getName(), new HashSet());
        }
        this.effectToTransitions.get(effect.getName()).add(new TransitionLifeline(transition, lifeline));
    }

    private int getVarInt(String var) {
        if (!this.varNames.containsKey(var)) {
            int varInt = this.varNames.size() + 3;
            this.varNames.put(var, varInt);
            this.variableMap.put(varInt, var);
        }
        return this.varNames.get(var);
    }

    private void addClause(int[] clause) throws ContradictionException {
        int i = 0;
        while (i < clause.length) {
            ++i;
        }
        this.solver.addClause((IVecInt)new VecInt(clause));
        ++this.clauseCnt;
    }

    private String getStateVar(State state, Lifeline lifeline, int time) {
        String name = "t" + time + "-" + STATE_STRING + lifeline.getName() + "_" + state.getName();
        if (!this.varToObject.containsKey(name)) {
            this.varToObject.put(name, new StateLifeline(state, lifeline));
        }
        return name;
    }

    private String getTseitinVar(int time) {
        ++this.tseitinCnt;
        return "t" + time + "-" + TSEITIN_STRING + this.tseitinCnt;
    }

    private String getSymbolVar(Symbol symbol, int time) {
        String symbolName = symbol == null ? EPSILON_STRING : symbol.getName();
        String name = "t" + time + "-" + SYMBOL_STRING + symbolName;
        if (!this.varToObject.containsKey(name)) {
            this.varToObject.put(name, symbol);
        }
        return name;
    }

    private String getStringSymbolVar(String string, int time) {
        String name = "t" + time + "-" + SYMBOL_STRING + string;
        if (!this.varToObject.containsKey(name)) {
            this.varToObject.put(name, string);
        }
        return name;
    }

    private String getMessageVar(Message message, int time) {
        String name = this.getSymbolVar(message.getBody(), time);
        if (!this.varToObject.containsKey(name)) {
            this.varToObject.put(name, message);
        }
        return name;
    }

    private String getInterVar(TransitionLifeline tl, int time) {
        String name = "t" + time + "-" + INTER_STRING + tl.getLifeline().getName() + "_" + this.getTransitionName(tl.getTransition());
        if (!this.varToObject.containsKey(name)) {
            this.varToObject.put(name, tl);
        }
        return name;
    }

    private String getTransVar(TransitionLifeline tl, int time) {
        String name = "t" + time + "-" + TRANS_STRING + tl.getLifeline().getName() + "_" + this.getTransitionName(tl.getTransition());
        if (!this.varToObject.containsKey(name)) {
            this.varToObject.put(name, tl);
        }
        return name;
    }

    private String getTransitionName(Transition transition) {
        String sourceName = transition.getSource().getName();
        String targetName = transition.getTarget().getName();
        String triggerName = transition.getTrigger() == null ? EPSILON_STRING : transition.getTrigger().getName();
        String effectName = "";
        for (Symbol effect : transition.getEffects()) {
            effectName = String.valueOf(effectName) + effect.getName();
        }
        return "-src" + sourceName + "-trg" + triggerName + "-eff" + effectName + "-tgt" + targetName;
    }

    @Override
    public void printModel(int[] model) {
        List<String> varNames = this.getModelText(model);
        System.out.println();
        for (String varName : varNames) {
            System.out.println(varName);
        }
        System.out.println();
    }

    @Override
    public List<String> getModelText(int[] model) {
        ArrayList<String> varNames = new ArrayList<String>();
        int i = 0;
        while (i < model.length) {
            if (model[i] > 0) {
                varNames.add(this.variableMap.get(model[i]));
            }
            ++i;
        }
        Collections.sort(varNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                String pattern = "t{1}\\d+-{1}.*";
                if (Pattern.matches(pattern, s1) && Pattern.matches(pattern, s2)) {
                    String s1Sub1 = s1.substring(1, s1.indexOf("-"));
                    String s2Sub1 = s2.substring(1, s2.indexOf("-"));
                    int result = Integer.valueOf(s1Sub1).compareTo(Integer.valueOf(s2Sub1));
                    if (result == 0) {
                        String s1Sub2 = s1.substring(s1.indexOf("-"));
                        String s2Sub2 = s2.substring(s2.indexOf("-"));
                        result = s1Sub2.compareTo(s2Sub2);
                    }
                    return result;
                }
                return s1.compareTo(s2);
            }
        });
        return varNames;
    }

    @Override
    public Map<String, Object> getVariableMap() {
        return this.varToObject;
    }
}

