/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.mc.encoding.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.mc.encoding.engine.IEncodingEngineReachability;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class EncodingEngineReachability
implements IEncodingEngineReachability {
    private static final String EPSILON_STRING = "e";
    private static final String INTER_STRING = "I:";
    private static final String STATE_STRING = "Q:";
    private static final String SYMBOL_STRING = "S:";
    private static final String TRANS_STRING = "T:";
    private static final boolean DEBUG = true;
    private ISolver solver;
    private Map<String, Integer> varNames;
    private Map<Integer, String> variableMap;
    private Map<Symbol, Set<Transition>> triggerToTransitions;
    private Map<Symbol, Set<Transition>> effectToTransitions;
    private Map<Transition, String> transitionToName;
    private Map<State, Integer> transCnt;

    public EncodingEngineReachability(ISolver solver) {
        this.solver = solver;
    }

    @Override
    public void generateEncoding(StateView stateView, int bound, Set<State> goal, IProgressMonitor monitor) throws ContradictionException {
        monitor.beginTask("Generate encoding", 10);
        this.varNames = new HashMap<String, Integer>();
        this.variableMap = new HashMap<Integer, String>();
        this.transCnt = new HashMap<State, Integer>();
        this.triggerToTransitions = new HashMap<Symbol, Set<Transition>>();
        this.effectToTransitions = new HashMap<Symbol, Set<Transition>>();
        this.transitionToName = new HashMap<Transition, String>();
        monitor.worked(1);
        System.out.println();
        System.out.println("addInit ");
        this.addInit(stateView);
        monitor.worked(1);
        System.out.println();
        System.out.println("addGoal ");
        this.addGoal(goal, bound);
        monitor.worked(1);
        System.out.println();
        System.out.println("addTransitionsToIntermediate ");
        this.addTransitionsToIntermediate(stateView, bound);
        monitor.worked(1);
        System.out.println();
        System.out.println("addTriggerFrame");
        this.addTriggerFrame(bound);
        monitor.worked(1);
        System.out.println();
        System.out.println("addEffectFrame ");
        this.addEffectFrame(bound);
        monitor.worked(1);
        System.out.println();
        System.out.println("addStateFrame ");
        this.addStateFrame(stateView, bound);
        monitor.worked(1);
        System.out.println();
        System.out.println("addInterStateFrame ");
        this.addInterStateFrame(stateView, bound);
        monitor.worked(1);
        System.out.println();
        System.out.println("addTransitionsFromIntermediate ");
        this.addTransitionsFromIntermediate(stateView, bound);
        monitor.worked(1);
        System.out.println();
        System.out.println("addOneStateEachTime ");
        this.addOneStateEachTime(stateView, bound);
        monitor.worked(1);
        monitor.done();
    }

    private void addOneStateEachTime(StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time <= bound) {
            for (Region statemachine : stateView.getStatemachines()) {
                ArrayList<String> extStateNames = new ArrayList<String>();
                for (State state : statemachine.getStates()) {
                    extStateNames.add(this.getVariableName(state, time));
                    for (Transition transition : state.getOutgoing()) {
                        extStateNames.add(this.getVariableName(INTER_STRING, this.getTransitionName(transition), time));
                    }
                }
                int[] clauseAll = new int[extStateNames.size()];
                int[] clauseBinary = new int[2];
                int cnt = 0;
                while (cnt < extStateNames.size()) {
                    clauseAll[cnt] = this.getVarInt((String)extStateNames.get(cnt));
                    clauseBinary[0] = -1 * this.getVarInt((String)extStateNames.get(cnt));
                    int cnt2 = cnt + 1;
                    while (cnt2 < extStateNames.size()) {
                        clauseBinary[1] = -1 * this.getVarInt((String)extStateNames.get(cnt2));
                        this.addClause(clauseBinary);
                        ++cnt2;
                    }
                    ++cnt;
                }
                this.addClause(clauseAll);
            }
            ++time;
        }
    }

    private void addTransitionsFromIntermediate(StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Region statemachine : stateView.getStatemachines()) {
                for (State state : statemachine.getStates()) {
                    for (Transition transition : state.getOutgoing()) {
                        EList effects = transition.getEffects();
                        String transitionName = this.getTransitionName(transition);
                        int[] clause = new int[effects.size() + 2];
                        clause[0] = -1 * this.getVarInt(this.getVariableName(INTER_STRING, transitionName, time));
                        int cnt = 1;
                        for (Symbol effect : effects) {
                            clause[cnt] = this.getVarInt(this.getVariableName(effect, time + 1));
                            ++cnt;
                        }
                        clause[clause.length - 1] = this.getVarInt(this.getVariableName(transition.getTarget(), time + 1));
                        this.addClause(clause);
                    }
                }
            }
            ++time;
        }
    }

    private void addStateFrame(StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Region statemachine : stateView.getStatemachines()) {
                for (State srcState : statemachine.getStates()) {
                    EList outgoingTrans = srcState.getOutgoing();
                    int[] clause = new int[outgoingTrans.size() + 2];
                    clause[0] = -1 * this.getVarInt(this.getVariableName(srcState, time));
                    clause[1] = this.getVarInt(this.getVariableName(srcState, time + 1));
                    int cnt = 2;
                    for (Transition transition : outgoingTrans) {
                        clause[cnt] = this.getVarInt(this.getVariableName(transition, time));
                        ++cnt;
                    }
                    this.addClause(clause);
                }
            }
            ++time;
        }
    }

    private void addInit(StateView stateView) throws ContradictionException {
        for (Region statemachine : stateView.getStatemachines()) {
            if (statemachine == null) continue;
            State initState = statemachine.getInitialTransition().getTarget();
            int[] clause = new int[1];
            for (State state : statemachine.getStates()) {
                clause[0] = state.equals(initState) ? this.getVarInt(this.getVariableName(state, 0)) : -1 * this.getVarInt(this.getVariableName(state, 0));
                this.addClause(clause);
            }
        }
        for (Symbol symbol : stateView.getAlphabet()) {
            int[] clause = new int[]{-1 * this.getVarInt(this.getVariableName(symbol, 0))};
            this.addClause(clause);
        }
    }

    private void addGoal(Set<State> goal, int bound) throws ContradictionException {
        for (State state : goal) {
            EList outTransitions = state.getOutgoing();
            EList inTransitions = state.getIncoming();
            Region statemachine = (Region)state.eContainer();
            ArrayList<Integer> clause = new ArrayList<Integer>();
            clause.add(this.getVarInt(this.getVariableName(state, bound - 1)));
            for (Transition transition : outTransitions) {
                if (transition.getEffects().size() <= 0) continue;
                clause.add(this.getVarInt(this.getVariableName(INTER_STRING, this.getTransitionName(transition), bound - 1)));
            }
            for (Transition transition : inTransitions) {
                if (transition.getEffects().size() != 0 || transition.equals(statemachine.getInitialTransition())) continue;
                clause.add(this.getVarInt(this.getVariableName(INTER_STRING, this.getTransitionName(transition), bound - 1)));
            }
            int[] clauseArray = new int[clause.size()];
            int cnt = 0;
            Iterator iterator = clause.iterator();
            while (iterator.hasNext()) {
                int i;
                clauseArray[cnt] = i = ((Integer)iterator.next()).intValue();
                ++cnt;
            }
            this.addClause(clauseArray);
        }
    }

    private void addEffectFrame(int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Symbol effect : this.effectToTransitions.keySet()) {
                Set<Transition> transitions = this.effectToTransitions.get(effect);
                int[] clause = new int[transitions.size() + 2];
                int[] clauseXOR = new int[4];
                clause[0] = this.getVarInt(this.getVariableName(effect, time));
                clause[1] = -1 * this.getVarInt(this.getVariableName(effect, time + 1));
                clauseXOR[0] = this.getVarInt(this.getVariableName(effect, time));
                clauseXOR[1] = -1 * this.getVarInt(this.getVariableName(effect, time + 1));
                int cnt = 2;
                for (Transition transition : transitions) {
                    clause[cnt] = this.getVarInt(this.getVariableName(transition, time));
                    clauseXOR[2] = -1 * this.getVarInt(this.getVariableName(transition, time));
                    ++cnt;
                    for (Transition transition2 : transitions) {
                        if (transition.equals(transition2)) continue;
                        clauseXOR[3] = -1 * this.getVarInt(this.getVariableName(transition2, time));
                    }
                }
                this.addClause(clause);
            }
            ++time;
        }
    }

    private void addTriggerFrame(int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Symbol trigger : this.triggerToTransitions.keySet()) {
                Set<Transition> transitions = this.triggerToTransitions.get(trigger);
                int[] clause = new int[transitions.size() + 2];
                int[] clauseXOR = new int[4];
                clause[0] = -1 * this.getVarInt(this.getVariableName(trigger, time));
                clause[1] = this.getVarInt(this.getVariableName(trigger, time + 1));
                clauseXOR[0] = -1 * this.getVarInt(this.getVariableName(trigger, time));
                clauseXOR[1] = this.getVarInt(this.getVariableName(trigger, time + 1));
                int cnt = 2;
                for (Transition transition : transitions) {
                    clause[cnt] = -1 * this.getVarInt(this.getVariableName(transition, time));
                    clauseXOR[2] = clause[cnt];
                    ++cnt;
                    for (Transition transition2 : transitions) {
                        if (transition.equals(transition2)) continue;
                        clauseXOR[3] = -1 * this.getVarInt(this.getVariableName(transition2, time));
                    }
                }
                this.addClause(clause);
            }
            ++time;
        }
    }

    private void addTransitionsToIntermediate(StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Region statemachine : stateView.getStatemachines()) {
                System.out.println("SM: " + statemachine.getName());
                for (State srcState : statemachine.getStates()) {
                    System.out.println("\tState: " + srcState.getName());
                    for (Transition transition : srcState.getOutgoing()) {
                        Symbol trigger = transition.getTrigger();
                        int[] clause = new int[2];
                        clause[0] = -1 * this.getVarInt(this.getVariableName(transition, time));
                        if (trigger != null) {
                            clause[1] = this.getVarInt(this.getVariableName(trigger, time));
                            this.addClause(clause);
                            clause[1] = -1 * this.getVarInt(this.getVariableName(trigger, time + 1));
                            this.addClause(clause);
                        }
                        clause[1] = this.getVarInt(this.getVariableName(srcState, time));
                        this.addClause(clause);
                        clause[1] = this.getVarInt(this.getVariableName(INTER_STRING, this.getTransitionName(transition), time + 1));
                        this.addClause(clause);
                        for (Symbol effect : transition.getEffects()) {
                            clause[1] = this.getVarInt(this.getVariableName(effect, time + 1));
                            this.addClause(clause);
                            clause[1] = -1 * this.getVarInt(this.getVariableName(effect, time));
                            this.addClause(clause);
                            this.addTransitionToEffect(transition, effect);
                        }
                        this.addTransitionToTrigger(transition, trigger);
                    }
                }
            }
            ++time;
        }
    }

    private void addInterStateFrame(StateView stateView, int bound) throws ContradictionException {
        int time = 0;
        while (time < bound) {
            for (Region statemachine : stateView.getStatemachines()) {
                for (State state : statemachine.getStates()) {
                    for (Transition transition : state.getOutgoing()) {
                        EList effects = transition.getEffects();
                        if (effects == null || effects.size() <= 0) continue;
                        String transitionName = this.getTransitionName(transition);
                        int[] clause1 = new int[3];
                        int[] clause2 = new int[3];
                        clause1[0] = -1 * this.getVarInt(this.getVariableName(INTER_STRING, transitionName, time));
                        clause1[1] = -1 * this.getVarInt(this.getVariableName(INTER_STRING, transitionName, time + 1));
                        clause2[0] = -1 * this.getVarInt(this.getVariableName(INTER_STRING, transitionName, time));
                        clause2[1] = this.getVarInt(this.getVariableName(INTER_STRING, transitionName, time + 1));
                        for (Symbol effect : effects) {
                            clause1[2] = this.getVarInt(this.getVariableName(effect, time + 1));
                            clause2[2] = -1 * this.getVarInt(this.getVariableName(effect, time + 1));
                            this.addClause(clause1);
                            this.addClause(clause2);
                        }
                    }
                }
            }
            ++time;
        }
    }

    private void addTransitionToTrigger(Transition transition, Symbol trigger) {
        if (!this.triggerToTransitions.containsKey(trigger)) {
            this.triggerToTransitions.put(trigger, new HashSet());
        }
        this.triggerToTransitions.get(trigger).add(transition);
    }

    private void addTransitionToEffect(Transition transition, Symbol trigger) {
        if (!this.effectToTransitions.containsKey(trigger)) {
            this.effectToTransitions.put(trigger, new HashSet());
        }
        this.effectToTransitions.get(trigger).add(transition);
    }

    private int getVarInt(String var) {
        if (!this.varNames.containsKey(var)) {
            int varInt = this.varNames.size() + 3;
            this.varNames.put(var, varInt);
            this.variableMap.put(varInt, var);
        }
        return this.varNames.get(var);
    }

    private void addClause(int[] clause) throws ContradictionException {
        int i = 0;
        while (i < clause.length) {
            if (clause[i] < 0) {
                System.out.print("~" + this.variableMap.get(Math.abs(clause[i])) + ", ");
            } else {
                System.out.print(String.valueOf(this.variableMap.get(Math.abs(clause[i]))) + ", ");
            }
            ++i;
        }
        System.out.println();
        this.solver.addClause((IVecInt)new VecInt(clause));
    }

    private String getVariableName(State state, int time) {
        return "t" + time + "-" + STATE_STRING + this.getStateName(state);
    }

    private String getVariableName(Symbol symbol, int time) {
        String symbolName = symbol == null ? EPSILON_STRING : symbol.getName();
        return "t" + time + "-" + SYMBOL_STRING + symbolName;
    }

    private String getVariableName(String classifier, String string, int time) {
        return "t" + time + "-" + classifier + string;
    }

    private String getVariableName(Transition transition, int time) {
        return "t" + time + "-" + TRANS_STRING + this.getTransitionName(transition);
    }

    private String getStateName(State state) {
        Region statemachine = (Region)state.eContainer();
        return String.valueOf(statemachine.getName()) + "-" + state.getName();
    }

    private String getTransitionName(Transition transition) {
        if (this.transitionToName.containsKey(transition)) {
            return this.transitionToName.get(transition);
        }
        State sourceState = transition.getSource();
        if (this.transCnt.containsKey(sourceState)) {
            this.transCnt.put(sourceState, this.transCnt.get(sourceState) + 1);
        } else {
            this.transCnt.put(sourceState, 0);
        }
        String triggerName = transition.getTrigger() == null ? EPSILON_STRING : transition.getTrigger().getName();
        String transitionName = String.valueOf(this.getStateName(sourceState)) + this.transCnt.get(sourceState) + "-" + triggerName + "-" + transition.getTarget().getName();
        this.transitionToName.put(transition, transitionName);
        return transitionName;
    }

    @Override
    public void printModel(int[] model) {
        ArrayList<String> varNames = new ArrayList<String>();
        int i = 0;
        while (i < model.length) {
            if (model[i] > 0) {
                varNames.add(this.variableMap.get(model[i]));
            }
            ++i;
        }
        Collections.sort(varNames);
        System.out.println();
        for (String varName : varNames) {
            System.out.println(varName);
        }
        System.out.println();
    }

    @Override
    public List<String> getModelText(int[] model) {
        ArrayList<String> modelText = new ArrayList<String>();
        ArrayList<String> varNames = new ArrayList<String>();
        int i = 0;
        while (i < model.length) {
            if (model[i] > 0) {
                varNames.add(this.variableMap.get(model[i]));
            }
            ++i;
        }
        Collections.sort(varNames);
        for (String varName : varNames) {
            modelText.add(varName);
        }
        return modelText;
    }
}

