/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.mc.ui.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.diagram.edit.parts.StateEditPart;
import org.modelevolution.multiview.mc.encoding.engine.impl.EncodingEngine;
import org.modelevolution.multiview.mc.ui.MCEncodingUIPlugin;
import org.modelevolution.multiview.mc.ui.model.Configuration;
import org.modelevolution.multiview.mc.ui.model.Evaluation;
import org.modelevolution.multiview.mc.ui.model.Outcome;
import org.modelevolution.multiview.mc.ui.util.ViewUtil;
import org.modelevolution.multiview.mc.ui.view.ConfigurationDialog;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class MCEncodingCommandHandler
extends AbstractHandler {
    private static MCEncodingCommandHandler instance = null;
    private boolean enabled = false;
    private ISelection selection;
    private Set<EditPart> selectedEditParts;
    private Set<State> selectedStates;

    public MCEncodingCommandHandler() {
        instance = this;
        this.selectedEditParts = new HashSet<EditPart>();
        this.selectedStates = new HashSet<State>();
    }

    public static MCEncodingCommandHandler getInstance() {
        if (instance == null) {
            instance = new MCEncodingCommandHandler();
        }
        return instance;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext context;
        Object currentSelection;
        this.enabled = false;
        this.selectedEditParts.clear();
        this.selectedStates.clear();
        if (evaluationContext != null && evaluationContext instanceof IEvaluationContext && (currentSelection = (context = (IEvaluationContext)evaluationContext).getVariable("selection")) != null && currentSelection instanceof ISelection) {
            this.selection = (ISelection)currentSelection;
            if (this.selection instanceof IStructuredSelection) {
                for (Object o : (IStructuredSelection)this.selection) {
                    StateEditPart stateEditPart;
                    Object m;
                    if (!(o instanceof StateEditPart) || !((m = (stateEditPart = (StateEditPart)o).getModel()) instanceof Shape)) continue;
                    Shape stateShape = (Shape)stateEditPart.getModel();
                    EObject e = stateShape.getElement();
                    if (e instanceof State) {
                        this.selectedEditParts.add((EditPart)stateEditPart);
                        this.selectedStates.add((State)e);
                    }
                    ViewUtil.COLOR_DEFAULT_FOREGROUND = stateEditPart.getFigure().getForegroundColor();
                    ViewUtil.COLOR_DEFAULT_BACKGROUND = stateEditPart.getFigure().getBackgroundColor();
                    this.enabled = true;
                }
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Assert.isTrue((boolean)this.selection.equals(HandlerUtil.getCurrentSelection((ExecutionEvent)event)), (String)"the selection is not equal.");
        try {
            this.process();
        }
        catch (InvocationTargetException e) {
            MCEncodingUIPlugin.log(Level.SEVERE, e.getMessage());
        }
        catch (InterruptedException e) {
            MCEncodingUIPlugin.log(Level.SEVERE, e.getMessage());
        }
        return null;
    }

    private void process() throws InvocationTargetException, InterruptedException {
        MCEncodingUIPlugin.getDefault().getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block13: {
                    monitor.beginTask("Composite State Checker", 2);
                    long initTime = System.currentTimeMillis();
                    StateView stateView = (StateView)((Region)((State)MCEncodingCommandHandler.this.selectedStates.iterator().next()).eContainer()).eContainer();
                    ISolver solver = SolverFactory.newDefault();
                    EncodingEngine encodingEngine = new EncodingEngine(solver);
                    int bound = 15;
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ConfigurationDialog inputConfiguration = new ConfigurationDialog(shell, "Enter configuration", "Insert maximum bound for CSC Problem:", Integer.valueOf(bound).toString(), new IntValidator());
                    if (inputConfiguration.open() == 0) {
                        bound = Integer.parseInt(inputConfiguration.getValue());
                        Configuration config = new Configuration();
                        HashSet<State> goalStates = new HashSet<State>();
                        Iterator itStates = MCEncodingCommandHandler.this.selectedStates.iterator();
                        while (itStates.hasNext()) {
                            goalStates.add((State)itStates.next());
                        }
                        HashSet<EditPart> goalEditParts = new HashSet<EditPart>();
                        Iterator itEditParts = MCEncodingCommandHandler.this.selectedEditParts.iterator();
                        while (itEditParts.hasNext()) {
                            goalEditParts.add((EditPart)itEditParts.next());
                        }
                        config.setGoal(goalStates);
                        config.setGoalEditParts(goalEditParts);
                        config.setBound(bound);
                        config.setExpectedOutcome(inputConfiguration.getExpectedOutcome());
                        MCEncodingUIPlugin.getDefault().getConfigurations().addConfigItems(config);
                        try {
                            try {
                                monitor.subTask("Generate encoding");
                                encodingEngine.generateEncoding(stateView, bound, MCEncodingCommandHandler.this.selectedStates);
                                Evaluation eval = new Evaluation();
                                eval.setTimeEncoding(System.currentTimeMillis() - initTime);
                                monitor.subTask("Analyze outcome");
                                if (solver.isSatisfiable()) {
                                    eval.setTrace(encodingEngine.getModelText(solver.model()));
                                    MCEncodingUIPlugin.log(Level.INFO, "GOAL: " + Arrays.toString(config.getGoal().toArray()));
                                    String trace = "";
                                    for (String s : eval.getTrace()) {
                                        trace = String.valueOf(trace) + s + "\n";
                                    }
                                    MCEncodingUIPlugin.log(Level.INFO, "TRACE: " + trace);
                                    eval.setEffectiveOutcome(Outcome.REACHABLE);
                                } else {
                                    eval.setEffectiveOutcome(Outcome.NOT_REACHABLE);
                                }
                                eval.setTimeSolving(System.currentTimeMillis() - initTime);
                                ViewUtil.colorShapes(config.getGoalEditParts(), ViewUtil.getColor(config.getExpectedOutcome(), eval.getEffectiveOutcome()), ViewUtil.getColor(config.getExpectedOutcome(), eval.getEffectiveOutcome()), 60);
                                config.setEvaluation(eval);
                                break block13;
                            }
                            catch (ContradictionException e1) {
                                e1.printStackTrace();
                                monitor.done();
                                break block13;
                            }
                            catch (TimeoutException e) {
                                MCEncodingUIPlugin.log(Level.SEVERE, e.getMessage());
                                monitor.done();
                                break block13;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    monitor.done();
                }
            }
        });
    }

    private class IntValidator
    implements IInputValidator {
        private IntValidator() {
        }

        public String isValid(String newText) {
            try {
                Integer.parseInt(newText);
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return "Input not valid. Number expected.";
            }
        }
    }
}

